/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.provisioning.webservice;

import com.viettel.common.ViettelService;
import com.viettel.provisioning.webservice.ActionProperty;
import com.viettel.provisioning.webservice.DirectActionXml;
import com.viettel.provisioning.webservice.ProductInfoLoader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.xml.parsers.ParserConfigurationException;

public class MessageSupport {
    public String getProcessCode(ViettelService request, String message) throws ParserConfigurationException, SQLException, MalformedObjectNameException, MBeanRegistrationException, NotCompliantMBeanException, InstanceAlreadyExistsException {
        DirectActionXml cmdInfo = new DirectActionXml();
        cmdInfo.parseString(message);
        String productId = cmdInfo.getProductId();
        String modificationType = cmdInfo.getModificationType();
        Hashtable paramList = cmdInfo.getParams();
        for (Map.Entry entry : paramList.entrySet()) {
            request.set((String)entry.getKey(), entry.getValue());
        }
        ProductInfoLoader productInfo = ProductInfoLoader.getInstance();
        ActionProperty actionProperty = productInfo.getAction(Integer.parseInt(productId), Integer.parseInt(modificationType));
        String processCode = actionProperty.getProcessCode();
        return processCode;
    }

    public String getMessageType(String message) {
        int beforeType = message.indexOf("type='") + 6;
        int afterType = message.indexOf("'>");
        String type = message.substring(beforeType, afterType);
        return type;
    }

    public String responseToString(ViettelService response) {
        String error = response.getError();
        Hashtable<String, Object> fields = response.getFields();
        StringBuffer buff = new StringBuffer();
        buff.append("<Message Type='10'");
        buff.append('>');
        buff.append("\r\n\t<TransactionTime>" + response.getTransactionTime() + "</TransactionTime>");
        if (error != null) {
            buff.append("\r\n\t<Error>" + error + "</Error>");
        }
        if (fields.size() > 0) {
            Enumeration<String> e = response.getKeys();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                Object value = response.get(key);
                if (key == null || value == null) continue;
                buff.append("\r\n\t<" + key + ">" + value + "</" + key + ">");
            }
        }
        buff.append("\r\n</Message>");
        return buff.toString();
    }

    public String buildErrorMessage(Exception ex) {
        String errorMessage = "<message type='01'> <responseCode>20</responseCode>";
        StringWriter sw = new StringWriter();
        ex.printStackTrace(new PrintWriter(sw));
        String stacktrace = sw.toString();
        errorMessage = ex instanceof ParserConfigurationException ? errorMessage + " <description>input data format is wrong</description> </message>" : (ex instanceof SQLException ? errorMessage + " <description>Can't connect to database, maybe loader is fail</description> " : errorMessage + " <description>Unknown exception</description> ");
        errorMessage = errorMessage + "<detail>" + stacktrace + "</detail></message>";
        return errorMessage;
    }
}

