/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.ussdfw.webservice;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.log4j.Logger;

public class HttpClientManager {
    private static Logger logger = Logger.getLogger(HttpClientManager.class);
    private List<HttpClient> listHttpclient = new ArrayList<HttpClient>();
    private int channelCount = 0;

    public HttpClientManager(int size, int connectionTimeout) {
        for (int i = 0; i < size; ++i) {
            HttpClient httpclient = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
            httpclient.getParams().setSoTimeout(connectionTimeout);
            httpclient.getParams().setConnectionManagerTimeout((long)connectionTimeout);
            httpclient.getHttpConnectionManager().getParams().setConnectionTimeout(connectionTimeout);
            this.listHttpclient.add(httpclient);
        }
    }

    public synchronized HttpClient getChannel() {
        try {
            if (this.channelCount > this.listHttpclient.size() - 1) {
                this.channelCount = 0;
            }
            HttpClient channel = this.listHttpclient.get(this.channelCount);
            ++this.channelCount;
            return channel;
        }
        catch (Exception ex) {
            logger.error((Object)"Get channel in http channel list fails, return Null:.........", (Throwable)ex);
            return null;
        }
    }
}

