/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.ussdfw.process;

import com.viettel.mmserver.base.ProcessThreadMX;
import com.viettel.ussdfw.log.ProcessTransLog;
import com.viettel.ussdfw.log.ProcessVasgwLog;
import com.viettel.ussdfw.manager.AppManager;
import com.viettel.ussdfw.process.ConnectorProcessThreadAbstract;
import com.viettel.ussdfw.process.Dispatcher;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.openide.util.Exceptions;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ProcessManager
extends ProcessThreadMX {
    private int[] idThread;
    private int[] idLogVasgwThread;
    private int[] idLogTransThread;

    public ProcessManager() throws Exception {
        super(ProcessManager.class.getSimpleName());
        this.registerAgent(AppManager.appId + ":type=" + ProcessManager.class.getSimpleName());
    }

    public void loadConnector(String fileConfig) throws Exception {
        Element vasElm;
        int i;
        DocumentBuilderFactory df = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = df.newDocumentBuilder();
        Document dc = db.parse(fileConfig);
        Element root = dc.getDocumentElement();
        HashMap<Integer, Integer> connectors = new HashMap<Integer, Integer>();
        int index = 0;
        NodeList list = root.getElementsByTagName("vas");
        if (list.getLength() < 1) {
            throw new Exception("No vas config");
        }
        ClassLoader cl = new ClassLoader(){};
        int countThread = 0;
        for (i = 0; i < list.getLength(); ++i) {
            vasElm = (Element)list.item(i);
            countThread += Integer.parseInt(vasElm.getAttribute("instance"));
        }
        this.idThread = new int[countThread];
        for (i = 0; i < list.getLength(); ++i) {
            vasElm = (Element)list.item(i);
            String name = vasElm.getAttribute("name");
            String returnKey = vasElm.getAttribute("return_key");
            String delayTimeResp = vasElm.getAttribute("delay_resp");
            String processClass = vasElm.getAttribute("process_class");
            NodeList listConnector = vasElm.getElementsByTagName("connector");
            if (listConnector.getLength() < 1) {
                throw new Exception("No vas connector");
            }
            HashMap<String, String> listFileConfig = new HashMap<String, String>();
            for (int j = 0; j < listConnector.getLength(); ++j) {
                Element connector = (Element)listConnector.item(j);
                String id = connector.getAttribute("id");
                String file_config = connector.getAttribute("file_config");
                if (connectors.containsKey(id)) {
                    throw new Exception("same connector id: " + id);
                }
                connectors.put(Integer.parseInt(id), 1);
                listFileConfig.put(id, file_config);
            }
            int instance = Integer.parseInt(vasElm.getAttribute("instance"));
            int queueSize = 3000;
            try {
                queueSize = Integer.parseInt(vasElm.getAttribute("queue_size"));
            }
            catch (Exception ex) {
                throw new Exception("not found queue_size attribute in connector.xml");
            }
            for (int j = 0; j < instance; ++j) {
                Class<?> c = cl.loadClass(processClass);
                this.logger.info((Object)("===> Load class: " + c.getName()));
                ConnectorProcessThreadAbstract connectorProcessThreadAbstract = (ConnectorProcessThreadAbstract)((Object)c.newInstance());
                connectorProcessThreadAbstract.config(name, queueSize, name + "-" + j, listFileConfig);
                connectorProcessThreadAbstract.setDelayTimeResp(Long.parseLong(delayTimeResp));
                connectorProcessThreadAbstract.setReturnKey(returnKey);
                this.idThread[index] = connectorProcessThreadAbstract.getId();
                ++index;
            }
        }
    }

    public void loadLogThread() {
        ProcessThreadMX log;
        int i;
        if (AppManager.numThreadLogVasgw > 0) {
            this.idLogVasgwThread = new int[AppManager.numThreadLogVasgw];
            for (i = 0; i < AppManager.numThreadLogVasgw; ++i) {
                log = new ProcessVasgwLog("ProcessVasgwLog" + i, AppManager.logToDatabase, AppManager.logDatabaseConf, AppManager.logToDatabaseId);
                this.idLogVasgwThread[i] = log.getId();
            }
        }
        if (AppManager.numThreadLogTrans > 0) {
            this.idLogTransThread = new int[AppManager.numThreadLogTrans];
            for (i = 0; i < AppManager.numThreadLogTrans; ++i) {
                log = new ProcessTransLog("ProcessTransLog" + i, AppManager.logToDatabase, AppManager.logDatabaseConf, AppManager.logToDatabaseId);
                this.idLogTransThread[i] = log.getId();
            }
        }
    }

    protected void process() {
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void start() {
        int i;
        Dispatcher.start();
        for (i = 0; i < this.idThread.length; ++i) {
            com.viettel.mmserver.base.ProcessManager.getInstance().getMmProcess(Integer.valueOf(this.idThread[i])).start();
        }
        if (this.idLogVasgwThread != null && this.idLogVasgwThread.length > 0) {
            for (i = 0; i < this.idLogVasgwThread.length; ++i) {
                com.viettel.mmserver.base.ProcessManager.getInstance().getMmProcess(Integer.valueOf(this.idLogVasgwThread[i])).start();
            }
        }
        if (this.idLogTransThread != null && this.idLogTransThread.length > 0) {
            for (i = 0; i < this.idLogTransThread.length; ++i) {
                com.viettel.mmserver.base.ProcessManager.getInstance().getMmProcess(Integer.valueOf(this.idLogTransThread[i])).start();
            }
        }
        super.start();
        this.logger.info((Object)"+++ SYSTEM PROCESS STARTED  +++");
    }

    public void stop() {
        int i;
        Dispatcher.stop();
        for (i = 0; i < this.idThread.length; ++i) {
            com.viettel.mmserver.base.ProcessManager.getInstance().getMmProcess(Integer.valueOf(this.idThread[i])).stop();
        }
        for (i = 0; i < this.idLogVasgwThread.length; ++i) {
            com.viettel.mmserver.base.ProcessManager.getInstance().getMmProcess(Integer.valueOf(this.idLogVasgwThread[i])).stop();
        }
        for (i = 0; i < this.idLogTransThread.length; ++i) {
            com.viettel.mmserver.base.ProcessManager.getInstance().getMmProcess(Integer.valueOf(this.idLogTransThread[i])).stop();
        }
        super.stop();
        this.logger.info((Object)"+++ SYSTEM PROCESS STOPPED  +++");
    }
}

