/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.ussdfw.object;

import com.viettel.application.ussdapp.common.VasRequest;
import com.viettel.ussdfw.utils.DateUtils;
import java.util.Date;

public class VasGwRecord {
    private long vasGwLogId;
    private String msisdn;
    private String imsi;
    private long sid;
    private long cpId;
    private long bizid;
    private String request;
    private Date requestTime;
    private String response;
    private Date responseTime;
    private String transactionId;
    private int errorCode;
    private String errorDescription;

    public VasGwRecord(VasRequest req) {
        this.msisdn = req.getMsisdn();
        this.imsi = req.getImsi();
        this.cpId = req.getConnectorId();
        this.bizid = req.getBizId();
        this.transactionId = req.getTransId();
        this.request = req.getParams();
        this.requestTime = new Date();
        this.requestTime.setTime(req.getSendRecvTime());
    }

    public VasGwRecord() {
    }

    public long getBizid() {
        return this.bizid;
    }

    public void setBizid(long bizid) {
        this.bizid = bizid;
    }

    public long getCpId() {
        return this.cpId;
    }

    public void setCpId(long cpId) {
        this.cpId = cpId;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public void setErrorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
    }

    public String getImsi() {
        return this.imsi;
    }

    public void setImsi(String imsi) {
        this.imsi = imsi;
    }

    public String getMsisdn() {
        return this.msisdn;
    }

    public void setMsisdn(String msisdn) {
        this.msisdn = msisdn;
    }

    public Date getRequestTime() {
        return this.requestTime;
    }

    public void setRequestTime(Date requestTime) {
        this.requestTime = requestTime;
    }

    public Date getResponseTime() {
        return this.responseTime;
    }

    public void setResponseTime(Date responseTime) {
        this.responseTime = responseTime;
    }

    public String getRequest() {
        return this.request;
    }

    public void setRequest(String request) {
        this.request = request;
    }

    public String getResponse() {
        return this.response;
    }

    public void setResponse(String response) {
        this.response = response;
    }

    public long getSid() {
        return this.sid;
    }

    public void setSid(long sid) {
        this.sid = sid;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public long getVasGwLogId() {
        return this.vasGwLogId;
    }

    public void setVasGwLogId(long vasGwLogId) {
        this.vasGwLogId = vasGwLogId;
    }

    public String toString() {
        return "VasGwRecord{msisdn=" + this.msisdn + ", imsi=" + this.imsi + ", sid=" + this.sid + ", cpId=" + this.cpId + ", bizid=" + this.bizid + ", request=" + this.request + ", requestTime=" + this.requestTime + ", response=" + this.response + ", responseTime=" + this.responseTime + ", transactionId=" + this.transactionId + ", errorCode=" + this.errorCode + ", errorDescription=" + this.errorDescription + '}';
    }

    public String toLog() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMsisdn() == null ? "" : this.getMsisdn());
        sb.append("|");
        sb.append(this.getImsi() == null ? "" : this.getImsi());
        sb.append("|");
        sb.append(this.getSid());
        sb.append("|");
        sb.append(this.getCpId());
        sb.append("|");
        sb.append(this.getBizid());
        sb.append("|");
        sb.append(this.getRequest() == null ? "" : this.getRequest());
        sb.append("|");
        sb.append(this.getRequestTime() == null ? "" : DateUtils.convertDateToString(this.getRequestTime(), "dd/MM/yyyy HH:mm:ss.FF3"));
        sb.append("|");
        sb.append(this.getResponse() == null ? "" : this.getResponse());
        sb.append("|");
        sb.append(this.getResponseTime() == null ? "" : DateUtils.convertDateToString(this.getResponseTime(), "dd/MM/yyyy HH:mm:ss.FF3"));
        sb.append("|");
        sb.append(this.getTransactionId() == null ? "" : this.getTransactionId());
        sb.append("|");
        sb.append(this.getErrorCode());
        sb.append("|");
        sb.append(this.getErrorDescription() == null ? "" : this.getErrorDescription());
        return sb.toString().replaceAll("\n", "#@n@#");
    }
}

