/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.ussdfw.manager;

import com.viettel.ussdfw.process.ProcessManager;
import com.viettel.utility.PropertiesUtils;
import java.io.File;
import java.io.FileReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import org.apache.log4j.Logger;
import utils.Config;

public class AppManager {
    private static AppManager instance;
    private Logger logger;
    private int moManagerId;
    private ProcessManager processManager;
    public static String appId;
    public static int breakQuery;
    public static int queryDbTimeout;
    public static long[] timesDbLevel;
    public static long minTimeDb;
    public static HashMap loggerDbMap;
    public static boolean logToDatabase;
    public static int numThreadLogVasgw;
    public static int numThreadLogTrans;
    public static String logToDatabaseId;
    public static String logDatabaseConf;
    private static Properties properties;
    private StringBuffer br = new StringBuffer();
    private boolean exception = false;

    public static AppManager getInstance() throws Exception {
        if (instance == null) {
            instance = new AppManager();
        }
        return instance;
    }

    public AppManager() throws Exception {
        this.logger = Logger.getLogger(AppManager.class);
        this.getConfig();
        this.loadLogLevelWarnning();
        this.initProcess();
    }

    private void getConfig() throws Exception {
        String config = Config.configDir + File.separator + "app.conf";
        FileReader fileReader = null;
        fileReader = new FileReader(config);
        Properties pro = new Properties();
        pro.load(fileReader);
        this.br.setLength(0);
        try {
            appId = pro.getProperty("APP_ID").toUpperCase();
        }
        catch (Exception ex) {
            this.br.append("APP_ID not found in app.conf\n");
            this.exception = true;
        }
        try {
            queryDbTimeout = Integer.parseInt(pro.getProperty("QUERY_DB_TIMEOUT"));
        }
        catch (Exception ex) {
            this.br.append("QUERY_DB_TIMEOUT not found in app.conf\n");
            this.exception = true;
        }
        try {
            breakQuery = Integer.parseInt(pro.getProperty("BREAK_QUERY")) * 1000;
        }
        catch (Exception ex) {
            this.br.append("BREAK_QUERY not found in app.conf\n");
            this.exception = true;
        }
        try {
            numThreadLogVasgw = Integer.parseInt(pro.getProperty("NUM_THREAD_LOG_VASGW"));
            if (numThreadLogVasgw <= 0) {
                this.br.append("NUM_THREAD_LOG_VASGW need config in app.conf\n");
                numThreadLogVasgw = 1;
            }
        }
        catch (Exception ex) {
            this.br.append("NUM_THREAD_LOG_VASGW not found in app.conf,default=1\n");
            numThreadLogVasgw = 1;
        }
        try {
            numThreadLogTrans = Integer.parseInt(pro.getProperty("NUM_THREAD_LOG_TRANS"));
            if (numThreadLogTrans <= 0) {
                this.br.append("NUM_THREAD_LOG_TRANS need config in app.conf\n");
                numThreadLogVasgw = 1;
            }
        }
        catch (Exception ex) {
            this.br.append("NUM_THREAD_LOG_TRANS not found in app.conf,default=1\n");
            numThreadLogTrans = 0;
        }
        try {
            logToDatabase = Boolean.parseBoolean(pro.getProperty("LOG_TO_DATABASE"));
        }
        catch (Exception ex) {
            this.br.append("LOG_TO_DATABASE not found in app.conf, default=false \n");
            logToDatabase = false;
        }
        if (logToDatabase) {
            try {
                logToDatabaseId = pro.getProperty("LOG_TO_DATABASE_ID");
                if (logToDatabaseId == null || logToDatabaseId.length() <= 0) {
                    this.br.append("LOG_TO_DATABASE_ID need config in app.conf\n");
                    this.exception = true;
                }
            }
            catch (Exception ex) {
                this.br.append("LOG_TO_DATABASE_ID not found in app.conf\n");
                this.exception = true;
            }
            try {
                logDatabaseConf = pro.getProperty("LOG_DATABASE_CONF");
                if (logDatabaseConf == null || logDatabaseConf.length() <= 0) {
                    this.br.append("LOG_DATABASE_CONF need config in app.conf\n");
                    this.exception = true;
                }
            }
            catch (Exception ex) {
                this.br.append("LOG_DATABASE_CONF not found in app.conf\n");
                this.exception = true;
            }
        }
        properties = pro;
        if (this.exception) {
            throw new Exception(this.br.toString());
        }
        if (this.br.length() > 0) {
            this.logger.warn((Object)this.br);
        }
    }

    public static String getProperty(String propertyName) {
        return properties.getProperty(propertyName);
    }

    private void initProcess() throws Exception {
        this.processManager = new ProcessManager();
        this.processManager.loadConnector("../etc/connector.xml");
        this.processManager.loadLogThread();
    }

    private void loadLogLevelWarnning() throws Exception {
        PropertiesUtils pros = new PropertiesUtils();
        pros.loadProperties("../etc/loglevel.conf", false);
        try {
            String[] dbTimes = pros.getProperty("DB_TIMES").split(",");
            String[] dbKey = pros.getProperty("DB_MESSAGE_KEY").split(",");
            loggerDbMap = new HashMap();
            timesDbLevel = new long[dbTimes.length];
            minTimeDb = Long.parseLong(dbTimes[0].trim());
            for (int i = 0; i < dbTimes.length; ++i) {
                AppManager.timesDbLevel[i] = Long.parseLong(dbTimes[i].trim());
                loggerDbMap.put(i, dbKey[i].trim());
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)"Loi lay thong tin DB_TIMES, DB_MESSAGE_KEY trong loglevel.conf");
            loggerDbMap = null;
            throw ex;
        }
    }

    public static String getTimeLevelDb(long times) {
        if (loggerDbMap != null) {
            String label;
            int key = Arrays.binarySearch(timesDbLevel, times);
            if (key < 0) {
                key = -key - 2;
            }
            return (label = (String)loggerDbMap.get(key)) == null ? "-" : label;
        }
        return null;
    }

    public void start() {
        this.processManager.start();
    }

    public void stop() {
        this.processManager.stop();
    }
}

