/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.ussdfw.log;

import com.viettel.logging.LogWriter;
import com.viettel.mmserver.base.ProcessThreadMX;
import com.viettel.ussdfw.database.DbProcessorFW;
import com.viettel.ussdfw.manager.AppManager;
import com.viettel.ussdfw.object.TransactionLog;
import java.util.ArrayList;
import utils.BlockQueue;

public class ProcessTransLog
extends ProcessThreadMX {
    private static BlockQueue queue = new BlockQueue(0, 5000);
    private boolean logToDb;
    private static LogWriter logTransWriter;
    private String dbId;
    private DbProcessorFW dbProcessor;

    public ProcessTransLog(String name, boolean logToDb, String dbPath, String dbId) {
        super(name);
        try {
            this.logToDb = logToDb;
            this.dbId = dbId;
            this.registerAgent(AppManager.appId + ":type=ProcessTransLog,name=" + name);
            if (logToDb) {
                this.dbProcessor = new DbProcessorFW(this.logger, dbPath);
            } else {
                logTransWriter = new LogWriter("../etc/log_writer.cfg", "/trans", "translog");
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)"ERROR when init ProcessTransLog", (Throwable)ex);
        }
    }

    public static synchronized void enqueue(TransactionLog transLog) {
        try {
            queue.enqueue((Object)transLog);
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
    }

    protected void process() {
        block8: {
            if (!queue.isEmpty()) {
                try {
                    if (this.logToDb) {
                        ArrayList<TransactionLog> listTransLog = new ArrayList<TransactionLog>();
                        for (int i = 0; i < 10 && !queue.isEmpty(); ++i) {
                            listTransLog.add((TransactionLog)queue.dequeue());
                        }
                        this.dbProcessor.iInsertTransLog(listTransLog, this.dbId);
                        break block8;
                    }
                    TransactionLog transLog = null;
                    transLog = (TransactionLog)queue.dequeue();
                    logTransWriter.writeLn(transLog.toLog());
                }
                catch (Exception ex) {
                    this.logger.error((Object)"error when process trans log", (Throwable)ex);
                }
            } else {
                try {
                    this.logger.debug((Object)"Khong co du lieu, sleep: 1s");
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

