/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.ussdfw.exchangeService;

import com.viettel.common.ObjectClientChannel;
import com.viettel.ussdfw.exchangeService.ExchangeChannel;
import com.viettel.utility.PropertiesUtils;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class ExchangeClientChannel {
    private static Logger logger = Logger.getLogger(ExchangeClientChannel.class);
    private static String loggerLabel = "PROCESS-ExchangeClientChannel: ";
    private HashMap listExch;
    private int exchId;
    private static HashMap<String, ExchangeClientChannel> hmInstance = new HashMap();
    private static ExchangeClientChannel instance;
    private int RECEIVER_TIME_OUT = -1;
    private int ERROR_COUNT_WARNING;
    private int SYNTHETIC_MINUTES;
    private String ERROR_LIST_WARNING;
    private int exchCount = 0;

    public ExchangeClientChannel() throws Exception {
        logger.info((Object)(loggerLabel + "Init Exchange: ../etc/exchange_client.cfg"));
        String path = "../etc/exchange_client.cfg";
        this.listExch = new HashMap();
        try {
            PropertiesUtils pro = new PropertiesUtils();
            pro.loadPropertiesEpt(path);
            String[] properties = pro.getProperties();
            this.RECEIVER_TIME_OUT = Integer.parseInt(pro.getProperty("RECEIVER_TIME_OUT", "100000"));
            this.ERROR_COUNT_WARNING = Integer.parseInt(pro.getProperty("ERROR_COUNT_WARNING", "10"));
            this.SYNTHETIC_MINUTES = Integer.parseInt(pro.getProperty("SYNTHETIC_MINUTES", "15"));
            this.ERROR_LIST_WARNING = pro.getProperty("SYNTHETIC_MINUTES", "|91|");
            if (!this.ERROR_LIST_WARNING.startsWith("|")) {
                this.ERROR_LIST_WARNING = "|" + this.ERROR_LIST_WARNING;
            }
            if (!this.ERROR_LIST_WARNING.endsWith("|")) {
                this.ERROR_LIST_WARNING = this.ERROR_LIST_WARNING + "|";
            }
            int index = 0;
            String line = properties[index];
            this.exchId = 0;
            while (index <= properties.length) {
                String host = "";
                int port = -1;
                String user = "";
                String pass = "";
                while (index < properties.length && !line.trim().toUpperCase().equals("[EXCHANGE]")) {
                    line = properties[index++];
                }
                if (index >= properties.length) {
                    return;
                }
                line = properties[index++];
                while (index <= properties.length && line.trim().toUpperCase().indexOf("[EXCHANGE]") < 0) {
                    if (line.trim().length() > 0) {
                        String[] info = line.split("=");
                        if (info[0].trim().toUpperCase().equals("ADDRESS")) {
                            host = info[1].trim();
                        }
                        if (info[0].trim().toUpperCase().equals("PORT")) {
                            port = Integer.parseInt(info[1].trim());
                        }
                        if (info[0].trim().toUpperCase().equals("USER")) {
                            user = info[1].trim();
                        }
                        if (info[0].trim().toUpperCase().equals("PASS")) {
                            pass = info[1].trim();
                        }
                    }
                    if (index >= properties.length) break;
                    line = properties[index++];
                }
                ObjectClientChannel channel = new ObjectClientChannel(host, port, user, pass, true);
                ExchangeChannel exChannel = new ExchangeChannel(channel, this.RECEIVER_TIME_OUT, this.exchId, path);
                exChannel.setStartTimeErrStatistics(new Date());
                exChannel.setEndTimeErrStatistics(new Date(exChannel.getStartTimeErrStatistics().getTime() + (long)(this.SYNTHETIC_MINUTES * 60 * 1000)));
                exChannel.setErrorCount(0);
                exChannel.setUseStatus(0);
                exChannel.setSyntheticMinutes(this.SYNTHETIC_MINUTES);
                exChannel.setErrorCountAlert(this.ERROR_COUNT_WARNING);
                exChannel.setErrorListAlert(this.ERROR_LIST_WARNING);
                this.listExch.put(this.exchId, exChannel);
                ++this.exchId;
                logger.info((Object)(loggerLabel + "Init Exchange: " + exChannel.getInfor() + " success"));
            }
            if (this.RECEIVER_TIME_OUT != -1) {
                logger.info((Object)(loggerLabel + "RECEIVER_TIME_OUT: " + this.RECEIVER_TIME_OUT));
            }
            logger.info((Object)(loggerLabel + "Init All Exchange success"));
        }
        catch (Exception ex) {
            logger.error((Object)"ERROR Init Exchange, please check exchange_client.cfg", (Throwable)ex);
            this.listExch.clear();
        }
    }

    public ExchangeClientChannel(String pathEx) throws Exception {
        logger.info((Object)(loggerLabel + "Init Exchange"));
        String path = pathEx;
        this.listExch = new HashMap();
        try {
            PropertiesUtils pro = new PropertiesUtils();
            pro.loadPropertiesEpt(path);
            String[] properties = pro.getProperties();
            this.RECEIVER_TIME_OUT = Integer.parseInt(pro.getProperty("RECEIVER_TIME_OUT", "100000"));
            this.ERROR_COUNT_WARNING = Integer.parseInt(pro.getProperty("ERROR_COUNT_WARNING", "10"));
            this.SYNTHETIC_MINUTES = Integer.parseInt(pro.getProperty("SYNTHETIC_MINUTES", "15"));
            this.ERROR_LIST_WARNING = pro.getProperty("SYNTHETIC_MINUTES", "|91|");
            if (!this.ERROR_LIST_WARNING.startsWith("|")) {
                this.ERROR_LIST_WARNING = "|" + this.ERROR_LIST_WARNING;
            }
            if (!this.ERROR_LIST_WARNING.endsWith("|")) {
                this.ERROR_LIST_WARNING = this.ERROR_LIST_WARNING + "|";
            }
            int index = 0;
            String line = properties[index];
            this.exchId = 0;
            while (index <= properties.length) {
                String host = "";
                int port = -1;
                String user = "";
                String pass = "";
                while (index < properties.length && !line.trim().toUpperCase().equals("[EXCHANGE]")) {
                    line = properties[index++];
                }
                if (index >= properties.length) {
                    return;
                }
                line = properties[index++];
                while (index <= properties.length && line.trim().toUpperCase().indexOf("[EXCHANGE]") < 0) {
                    if (line.trim().length() > 0) {
                        String[] info = line.split("=");
                        if (info[0].trim().toUpperCase().equals("ADDRESS")) {
                            host = info[1].trim();
                        }
                        if (info[0].trim().toUpperCase().equals("PORT")) {
                            port = Integer.parseInt(info[1].trim());
                        }
                        if (info[0].trim().toUpperCase().equals("USER")) {
                            user = info[1].trim();
                        }
                        if (info[0].trim().toUpperCase().equals("PASS")) {
                            pass = info[1].trim();
                        }
                    }
                    if (index >= properties.length) break;
                    line = properties[index++];
                }
                ObjectClientChannel channel = new ObjectClientChannel(host, port, user, pass, true);
                ExchangeChannel exChannel = new ExchangeChannel(channel, this.RECEIVER_TIME_OUT, this.exchId, pathEx);
                exChannel.setStartTimeErrStatistics(new Date());
                exChannel.setEndTimeErrStatistics(new Date(exChannel.getStartTimeErrStatistics().getTime() + (long)(this.SYNTHETIC_MINUTES * 60 * 1000)));
                exChannel.setErrorCount(0);
                exChannel.setUseStatus(0);
                exChannel.setSyntheticMinutes(this.SYNTHETIC_MINUTES);
                exChannel.setErrorCountAlert(this.ERROR_COUNT_WARNING);
                exChannel.setErrorListAlert(this.ERROR_LIST_WARNING);
                this.listExch.put(this.exchId, exChannel);
                ++this.exchId;
                logger.info((Object)(loggerLabel + "Init Exchange: " + exChannel.getInfor() + " success"));
            }
            if (this.RECEIVER_TIME_OUT != -1) {
                logger.info((Object)(loggerLabel + "RECEIVER_TIME_OUT: " + this.RECEIVER_TIME_OUT));
            }
            logger.info((Object)(loggerLabel + "Init All Exchange success"));
        }
        catch (Exception ex) {
            logger.error((Object)"ERROR Init Exchange, please check exchange_client.cfg", (Throwable)ex);
            this.listExch.clear();
        }
    }

    public static ExchangeClientChannel getInstance() throws Exception {
        if (instance == null) {
            instance = new ExchangeClientChannel();
        }
        return instance;
    }

    public static ExchangeClientChannel getInstance(String pathEx) throws Exception {
        if (!hmInstance.containsKey(pathEx)) {
            hmInstance.put(pathEx, new ExchangeClientChannel(pathEx));
        }
        return hmInstance.get(pathEx);
    }

    public synchronized ExchangeChannel getChannel() {
        int getAcount = 0;
        try {
            while (true) {
                if (getAcount > this.listExch.size() - 1) {
                    logger.info((Object)"All ExchangeChannel is blocked => set active status for all");
                    for (int i = 0; i < this.listExch.size(); ++i) {
                        ((ExchangeChannel)this.listExch.get(i)).setUseStatus(0);
                    }
                    getAcount = 0;
                }
                if (this.exchCount > this.listExch.size() - 1) {
                    this.exchCount = 0;
                }
                if (((ExchangeChannel)this.listExch.get(this.exchCount)).getUseStatus() == 0) {
                    ExchangeChannel channel = (ExchangeChannel)this.listExch.get(this.exchCount);
                    ++this.exchCount;
                    return channel;
                }
                ++getAcount;
                ++this.exchCount;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Get channel in exchange channel list fails, return Null:.........", (Throwable)ex);
            return null;
        }
    }

    public ExchangeChannel getChannel(int moduleId) {
        return (ExchangeChannel)this.listExch.get(moduleId);
    }

    public int getExchId() {
        return this.exchId;
    }

    public void setExchId(int exchId) {
        this.exchId = exchId;
    }

    public HashMap getListExch() {
        return this.listExch;
    }

    public void setListExch(HashMap listExch) {
        this.listExch = listExch;
    }

    public int getRECEIVER_TIME_OUT() {
        return this.RECEIVER_TIME_OUT;
    }

    public void setRECEIVER_TIME_OUT(int RECEIVER_TIME_OUT) {
        this.RECEIVER_TIME_OUT = RECEIVER_TIME_OUT;
    }
}

