/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.ussdfw.exchangeService;

import com.viettel.common.ObjectClientChannel;
import com.viettel.common.ViettelMsg;
import java.io.IOException;
import java.util.Date;
import org.apache.log4j.Logger;

public class ExchangeChannel {
    private String host;
    private int port;
    private String user;
    private String pass;
    private ObjectClientChannel channel;
    private int id;
    private String pathEx;
    private Date startTimeErrStatistics;
    private Date endTimeErrStatistics;
    private int errorCount;
    private int useStatus;
    private int syntheticMinutes;
    private int errorCountAlert;
    private String errorListAlert;
    private Logger logger = Logger.getLogger(ExchangeChannel.class);

    public ExchangeChannel(ObjectClientChannel channel, long receiverTimeOut, int id, String pathEx) {
        this.channel = channel;
        this.channel.setReceiverTimeout(receiverTimeOut);
        this.id = id;
        this.host = channel.getIp();
        this.port = channel.getPort();
        this.user = channel.getUsername();
        this.pass = channel.getPassword();
        this.pathEx = pathEx;
        this.useStatus = 0;
        this.errorCount = 0;
        this.errorCountAlert = 10;
        this.syntheticMinutes = 15;
        this.startTimeErrStatistics = new Date();
        this.endTimeErrStatistics = new Date(this.startTimeErrStatistics.getTime() + (long)(this.syntheticMinutes * 60 * 1000));
        this.errorListAlert = "|91|";
    }

    public String getInfor() {
        return this.host + ":" + this.port;
    }

    public String getFullInfo() {
        return this.host + ":" + this.port + "/" + this.user + "@" + this.pass;
    }

    public ObjectClientChannel getChannel() {
        return this.channel;
    }

    public void setChannel(ObjectClientChannel channel) {
        this.channel = channel;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPass() {
        return this.pass;
    }

    public void setPass(String pass) {
        this.pass = pass;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Date getStartTimeErrStatistics() {
        return this.startTimeErrStatistics;
    }

    public void setStartTimeErrStatistics(Date startTimeErrStatistics) {
        this.startTimeErrStatistics = startTimeErrStatistics;
    }

    public Date getEndTimeErrStatistics() {
        return this.endTimeErrStatistics;
    }

    public void setEndTimeErrStatistics(Date endTimeErrStatistics) {
        this.endTimeErrStatistics = endTimeErrStatistics;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public void setErrorCount(int errorCount) {
        this.errorCount = errorCount;
    }

    public int getUseStatus() {
        return this.useStatus;
    }

    public void setUseStatus(int useStatus) {
        this.useStatus = useStatus;
    }

    public String getErrorListAlert() {
        return this.errorListAlert;
    }

    public void setErrorListAlert(String errorListAlert) {
        this.errorListAlert = errorListAlert;
    }

    public int getSyntheticMinutes() {
        return this.syntheticMinutes;
    }

    public void setSyntheticMinutes(int syntheticMinutes) {
        this.syntheticMinutes = syntheticMinutes;
    }

    public int getErrorCountAlert() {
        return this.errorCountAlert;
    }

    public void setErrorCountAlert(int errorCountAlert) {
        this.errorCountAlert = errorCountAlert;
    }

    public ViettelMsg send(ViettelMsg request) throws IOException {
        try {
            if (this.useStatus == 0) {
                ViettelMsg response = this.channel.send(request);
                if (this.errorListAlert != null && (this.errorListAlert.contains("|" + response.get("responseCode") + "|") || this.errorListAlert.contains("|" + response.getError() + "|"))) {
                    Date processDate = new Date();
                    if (processDate.after(this.startTimeErrStatistics) && processDate.before(this.endTimeErrStatistics)) {
                        ++this.errorCount;
                        if (this.errorCount >= this.errorCountAlert) {
                            this.logger.info((Object)("ExchangeChannel " + this.host + ":" + this.port + " is blocked"));
                            this.useStatus = 1;
                        }
                    } else {
                        this.startTimeErrStatistics = processDate;
                        this.endTimeErrStatistics = new Date(processDate.getTime() + (long)(this.syntheticMinutes * 60 * 1000));
                        this.errorCount = 1;
                    }
                    processDate = null;
                }
                return response;
            }
            throw new IOException("ExchangeChannel is blocked because It has many timeout transactions...");
        }
        catch (IOException ex) {
            Date processDate = new Date();
            if (processDate.after(this.startTimeErrStatistics) && processDate.before(this.endTimeErrStatistics)) {
                ++this.errorCount;
                if (this.errorCount >= this.errorCountAlert) {
                    this.logger.info((Object)("ExchangeChannel " + this.host + ":" + this.port + " is blocked"));
                    this.useStatus = 1;
                }
            } else {
                this.startTimeErrStatistics = processDate;
                this.endTimeErrStatistics = new Date(processDate.getTime() + (long)(this.syntheticMinutes * 60 * 1000));
                this.errorCount = 1;
            }
            throw ex;
        }
    }
}

