/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.ussdfw.database;

import com.viettel.ussdfw.database.ConnectionPoolManager;
import com.viettel.ussdfw.manager.AppManager;
import com.viettel.ussdfw.object.TransactionLog;
import com.viettel.ussdfw.object.VasGwRecord;
import com.viettel.ussdfw.object.WebserviceObject;
import com.viettel.ussdfw.webservice.WebserviceGroup;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class DbProcessorFW {
    protected Logger logger;
    private String loggerLabel = "DbProcessor-FW: ";
    private long timeSt;
    private long timeEx;
    private StringBuffer br = new StringBuffer();
    private static String SQL_INSERT_VAS_GW_LOG = "INSERT INTO vas_gw_log (VAS_GW_LOG_ID,MSISDN,IMSI,SID,CPID,BIZID,REQUEST,REQUEST_TIME,RESPONSE,RESPONSE_TIME,TRANSACTION_ID,ERROR_CODE,ERROR_DESCRIPTION)  VALUES(vas_gw_log_seq.nextval,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static String SQL_INSERT_TRANS_LOG = "INSERT INTO transaction_log (TRANSACTION_ID,TYPE,MSISDN,REQUEST,ERROR_CODE,COMMAND,REQUEST_TIME,RESPONSE_TIME,RESPONSE,CHANNEL) VALUES(transaction_log_seq.nextval,?,?,?,?,?,?,?,?,?)";
    private static String SQL_SELECT_WEBSERVICE = "select * from webservice where status=1 order by ws_code, ws_id";

    public DbProcessorFW(String name) throws Exception {
        this.logger = Logger.getLogger((String)name);
        ConnectionPoolManager.loadConfig("../etc/database.xml");
    }

    public DbProcessorFW(Logger logger) throws Exception {
        this.logger = logger;
        ConnectionPoolManager.loadConfig("../etc/database.xml");
    }

    public DbProcessorFW(String name, String path) throws Exception {
        this.logger = Logger.getLogger((String)name);
        ConnectionPoolManager.loadConfig(path);
    }

    public DbProcessorFW(Logger logger, String path) throws Exception {
        this.logger = logger;
        ConnectionPoolManager.loadConfig(path);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setTimeSt(long timeSt) {
        this.timeSt = timeSt;
    }

    public void logTime(String strLog) {
        this.timeEx = System.currentTimeMillis() - this.timeSt;
        if (this.timeEx >= AppManager.minTimeDb && AppManager.loggerDbMap != null) {
            this.br.setLength(0);
            this.br.append(this.loggerLabel).append(AppManager.getTimeLevelDb(this.timeEx)).append(": ").append(strLog).append(": ").append(this.timeEx).append(" ms");
            this.logger.warn((Object)this.br);
        } else {
            this.br.setLength(0);
            this.br.append(this.loggerLabel).append(strLog).append(": ").append(this.timeEx).append(" ms");
            this.logger.info((Object)this.br);
        }
    }

    public Connection getConnection(String dbId) {
        return ConnectionPoolManager.getConnection(dbId);
    }

    protected void closeResource(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
                rs = null;
            }
        }
        catch (SQLException e) {
            this.logger.warn((Object)e);
            rs = null;
        }
    }

    protected void closeResource(Statement stmt) {
        try {
            if (stmt != null) {
                stmt.close();
                stmt = null;
            }
        }
        catch (SQLException e) {
            this.logger.warn((Object)e);
            stmt = null;
        }
    }

    protected void closeResource(Connection conn) {
        try {
            if (conn != null) {
                conn.close();
                conn = null;
            }
        }
        catch (SQLException e) {
            this.logger.warn((Object)e);
            conn = null;
        }
    }

    public int iInsertVasGwLog(VasGwRecord vasGwLog, String dbId) {
        int result = -1;
        long timeBegin = System.currentTimeMillis();
        int count = 1;
        while (result < 0) {
            try {
                result = this.insertVasGwLog(vasGwLog, dbId);
            }
            catch (SQLException ex) {
                this.br.setLength(0);
                this.br.append(this.loggerLabel).append("ERROR - ").append(count).append("\n").append(SQL_INSERT_VAS_GW_LOG);
                this.logger.error((Object)this.br, (Throwable)ex);
                ++count;
            }
            catch (Exception ex) {
                this.br.setLength(0);
                this.br.append(this.loggerLabel).append(new Date()).append("\nERROR insert VAS_GW_LOG");
                this.logger.error((Object)this.br, (Throwable)ex);
                break;
            }
            if (result >= 0 || System.currentTimeMillis() - timeBegin <= (long)AppManager.breakQuery) continue;
            this.br.setLength(0);
            this.br.append(this.loggerLabel).append(new Date()).append("==> BREAK query insert VAS_GW_LOG\n");
            this.logger.error((Object)this.br);
            break;
        }
        return result;
    }

    private int insertVasGwLog(VasGwRecord vasGwLog, String dbId) throws SQLException {
        int result = -1;
        PreparedStatement ps = null;
        Connection connection = null;
        try {
            connection = ConnectionPoolManager.getConnection(dbId);
            this.setTimeSt(System.currentTimeMillis());
            ps = connection.prepareStatement(SQL_INSERT_VAS_GW_LOG);
            ps.setQueryTimeout(AppManager.queryDbTimeout);
            ps.setString(1, vasGwLog.getMsisdn());
            ps.setString(2, vasGwLog.getImsi());
            ps.setLong(3, vasGwLog.getSid());
            ps.setLong(4, vasGwLog.getCpId());
            ps.setLong(5, vasGwLog.getBizid());
            ps.setString(6, vasGwLog.getRequest());
            ps.setTimestamp(7, new Timestamp(vasGwLog.getRequestTime().getTime()));
            ps.setString(8, vasGwLog.getResponse());
            ps.setTimestamp(9, new Timestamp(vasGwLog.getResponseTime().getTime()));
            ps.setString(10, vasGwLog.getTransactionId());
            ps.setInt(11, vasGwLog.getErrorCode());
            ps.setString(12, vasGwLog.getErrorDescription());
            result = ps.executeUpdate();
            this.closeResource(ps);
            this.closeResource(connection);
            this.logTime(SQL_INSERT_VAS_GW_LOG);
        }
        catch (SQLException ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                this.closeResource(ps);
                this.closeResource(connection);
                this.logTime(SQL_INSERT_VAS_GW_LOG);
                throw throwable;
            }
        }
        return result;
    }

    public int[] iInsertVasGwLog(List<VasGwRecord> listVasGwLog, String dbId) {
        int[] result = null;
        long timeBegin = System.currentTimeMillis();
        int count = 1;
        while (result == null) {
            try {
                result = this.insertVasGwLog(listVasGwLog, dbId);
            }
            catch (SQLException ex) {
                this.br.setLength(0);
                this.br.append(this.loggerLabel).append("ERROR - ").append(count).append("\n").append(SQL_INSERT_VAS_GW_LOG);
                this.logger.error((Object)this.br, (Throwable)ex);
                ++count;
            }
            catch (Exception ex) {
                this.br.setLength(0);
                this.br.append(this.loggerLabel).append(new Date()).append("\nERROR insert VAS_GW_LOG");
                this.logger.error((Object)this.br, (Throwable)ex);
                break;
            }
            if (result != null || System.currentTimeMillis() - timeBegin <= (long)AppManager.breakQuery) continue;
            this.br.setLength(0);
            this.br.append(this.loggerLabel).append(new Date()).append("==> BREAK query insert VAS_GW_LOG\n");
            this.logger.error((Object)this.br);
            break;
        }
        return result;
    }

    private int[] insertVasGwLog(List<VasGwRecord> listVasGwLog, String dbId) throws SQLException {
        int[] result = null;
        PreparedStatement ps = null;
        Connection connection = null;
        try {
            connection = ConnectionPoolManager.getConnection(dbId);
            this.setTimeSt(System.currentTimeMillis());
            ps = connection.prepareStatement(SQL_INSERT_VAS_GW_LOG);
            ps.setQueryTimeout(AppManager.queryDbTimeout);
            this.br.setLength(0);
            this.br.append(" INSERT_VAS_GW_LOG: ");
            for (VasGwRecord vasGwLog : listVasGwLog) {
                this.br.append("[").append(vasGwLog.getMsisdn()).append("|").append(vasGwLog.getRequest()).append("]|");
                ps.setString(1, vasGwLog.getMsisdn());
                ps.setString(2, vasGwLog.getImsi());
                ps.setLong(3, vasGwLog.getSid());
                ps.setLong(4, vasGwLog.getCpId());
                ps.setLong(5, vasGwLog.getBizid());
                ps.setString(6, vasGwLog.getRequest());
                ps.setTimestamp(7, new Timestamp(vasGwLog.getRequestTime().getTime()));
                ps.setString(8, vasGwLog.getResponse());
                ps.setTimestamp(9, new Timestamp(vasGwLog.getResponseTime().getTime()));
                ps.setString(10, vasGwLog.getTransactionId());
                ps.setInt(11, vasGwLog.getErrorCode());
                ps.setString(12, vasGwLog.getErrorDescription());
                ps.addBatch();
            }
            result = ps.executeBatch();
            this.closeResource(ps);
            this.closeResource(connection);
            this.logTime(this.br.toString());
            this.br.setLength(0);
        }
        catch (SQLException ex) {
            try {
                this.br.setLength(0);
                throw ex;
            }
            catch (Throwable throwable) {
                this.closeResource(ps);
                this.closeResource(connection);
                this.logTime(this.br.toString());
                this.br.setLength(0);
                throw throwable;
            }
        }
        return result;
    }

    public int[] iInsertTransLog(List<TransactionLog> listTransLog, String dbId) {
        int[] result = null;
        long timeBegin = System.currentTimeMillis();
        int count = 1;
        while (result == null) {
            try {
                result = this.insertTransLog(listTransLog, dbId);
            }
            catch (SQLException ex) {
                this.br.setLength(0);
                this.br.append(this.loggerLabel).append("ERROR - ").append(count).append("\n").append(SQL_INSERT_TRANS_LOG);
                this.logger.error((Object)this.br, (Throwable)ex);
                ++count;
            }
            catch (Exception ex) {
                this.br.setLength(0);
                this.br.append(this.loggerLabel).append(new Date()).append("\nERROR insert TRANSACTION_LOG");
                this.logger.error((Object)this.br, (Throwable)ex);
                break;
            }
            if (result != null || System.currentTimeMillis() - timeBegin <= (long)AppManager.breakQuery) continue;
            this.br.setLength(0);
            this.br.append(this.loggerLabel).append(new Date()).append("==> BREAK query insert TRANSACTION_LOG\n");
            this.logger.error((Object)this.br);
            break;
        }
        return result;
    }

    private int[] insertTransLog(List<TransactionLog> listTransLog, String dbId) throws SQLException {
        int[] result = null;
        PreparedStatement ps = null;
        Connection connection = null;
        try {
            connection = ConnectionPoolManager.getConnection(dbId);
            this.setTimeSt(System.currentTimeMillis());
            ps = connection.prepareStatement(SQL_INSERT_TRANS_LOG);
            ps.setQueryTimeout(AppManager.queryDbTimeout);
            this.br.setLength(0);
            this.br.append(" INSERT TRANSACTION_LOG: ");
            for (TransactionLog transLog : listTransLog) {
                this.br.append("[").append(transLog.getMsisdn()).append("|").append(transLog.getCommand()).append("]|");
                ps.setInt(1, transLog.getType());
                ps.setString(2, transLog.getMsisdn());
                ps.setString(3, transLog.getRequest());
                ps.setString(4, transLog.getErrorCode());
                ps.setString(5, transLog.getCommand());
                ps.setTimestamp(6, new Timestamp(transLog.getRequestTime().getTime()));
                ps.setTimestamp(7, new Timestamp(transLog.getResponseTime().getTime()));
                ps.setString(8, transLog.getResponse());
                ps.setString(9, transLog.getChannel());
                ps.addBatch();
            }
            result = ps.executeBatch();
            this.closeResource(ps);
            this.closeResource(connection);
            this.logTime(this.br.toString());
            this.br.setLength(0);
        }
        catch (SQLException ex) {
            try {
                this.br.setLength(0);
                throw ex;
            }
            catch (Throwable throwable) {
                this.closeResource(ps);
                this.closeResource(connection);
                this.logTime(this.br.toString());
                this.br.setLength(0);
                throw throwable;
            }
        }
        return result;
    }

    public HashMap<String, WebserviceGroup> iGetWebservice(String dbId) {
        HashMap<String, WebserviceGroup> hashmap = null;
        long timeBegin = System.currentTimeMillis();
        int count = 1;
        while (hashmap == null) {
            try {
                hashmap = this.getWebservice(dbId);
            }
            catch (SQLException ex) {
                this.br.setLength(0);
                this.br.append(this.loggerLabel).append("ERROR - ").append(count).append("\n").append(SQL_SELECT_WEBSERVICE);
                this.logger.error((Object)this.br, (Throwable)ex);
                ++count;
            }
            catch (Exception ex) {
                this.br.setLength(0);
                this.br.append(this.loggerLabel).append(new Date()).append("\nERROR select WEBSERVICE");
                this.logger.error((Object)this.br, (Throwable)ex);
                throw ex;
            }
            if (hashmap != null || System.currentTimeMillis() - timeBegin <= (long)AppManager.breakQuery) continue;
            this.br.setLength(0);
            this.br.append(this.loggerLabel).append(new Date()).append("==> BREAK query select WEBSERVICE \n");
            this.logger.error((Object)this.br);
            break;
        }
        return hashmap;
    }

    private HashMap<String, WebserviceGroup> getWebservice(String dbId) throws SQLException {
        HashMap<String, WebserviceGroup> hashmap = null;
        ResultSet rs = null;
        PreparedStatement ps = null;
        Connection connection = null;
        try {
            connection = ConnectionPoolManager.getConnection(dbId);
            this.setTimeSt(System.currentTimeMillis());
            ps = connection.prepareStatement(SQL_SELECT_WEBSERVICE);
            ps.setQueryTimeout(AppManager.queryDbTimeout);
            rs = ps.executeQuery();
            hashmap = new HashMap<String, WebserviceGroup>();
            String wsCode = "";
            ArrayList<WebserviceObject> listWs = new ArrayList<WebserviceObject>();
            while (rs.next()) {
                String wsCodeTmp = rs.getString("WS_CODE");
                if (!wsCode.equals(wsCodeTmp)) {
                    if (!wsCode.equals("")) {
                        WebserviceGroup wsGroup = new WebserviceGroup();
                        wsGroup.setListWs(listWs);
                        hashmap.put(wsCode, wsGroup);
                        listWs = new ArrayList();
                    }
                    wsCode = wsCodeTmp;
                }
                WebserviceObject obj = new WebserviceObject();
                obj.setWsId(rs.getLong("WS_ID"));
                obj.setWsName(rs.getString("WS_NAME"));
                obj.setWsCode(rs.getString("WS_CODE"));
                obj.setWsdl(rs.getString("WSDL"));
                obj.setMsgTemplate(rs.getString("MSG_TEMPLATE"));
                try {
                    obj.setResponseTag(rs.getString("RESPONSE_TAG"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    obj.setErrorTag(rs.getString("ERROR_TAG"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    obj.setRequestType(rs.getString("REQUEST_TYPE"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    obj.setKeyEncode(rs.getString("KEY_ENCODE"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                obj.setStatus(rs.getInt("STATUS"));
                listWs.add(obj);
            }
            if (!wsCode.equals("")) {
                WebserviceGroup wsGroup = new WebserviceGroup();
                wsGroup.setListWs(listWs);
                hashmap.put(wsCode, wsGroup);
            }
            this.closeResource(rs);
            this.closeResource(ps);
            this.closeResource(connection);
            this.logTime("Time to select WEBSERVICE");
        }
        catch (SQLException ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                this.closeResource(rs);
                this.closeResource(ps);
                this.closeResource(connection);
                this.logTime("Time to select WEBSERVICE");
                throw throwable;
            }
        }
        return hashmap;
    }
}

