/*
 * Decompiled with CFR 0.152.
 */
package vasp.messagelogger;

import java.io.File;
import org.apache.log4j.Logger;
import transport.message.Message;
import utils.Config;
import vasp.messagelogger.ServiceLog;
import vasp.utils.ModuleLoader;

public class ServiceLogImpl {
    ServiceLog[] modules;
    Logger logger;
    Object lock = new Object();
    private static ServiceLogImpl serviceLog;

    private ServiceLogImpl() {
        String configFile = Config.getConfigDir() + File.separator + "module.conf";
        this.logger = Logger.getLogger(ServiceLogImpl.class);
        ModuleLoader loader = new ModuleLoader();
        this.modules = (ServiceLog[])loader.loadConfig(configFile, "msglog", new ServiceLog[0]);
    }

    public static synchronized ServiceLogImpl getServiceLog() {
        if (serviceLog == null) {
            serviceLog = new ServiceLogImpl();
        }
        return serviceLog;
    }

    public ServiceLog getServiceLog(String name) {
        if (this.modules == null) {
            return null;
        }
        for (ServiceLog module : this.modules) {
            if (!module.getName().equals(name)) continue;
            return module;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(Message message) {
        Object object = this.lock;
        synchronized (object) {
            for (ServiceLog module : this.modules) {
                module.log(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        Object object = this.lock;
        synchronized (object) {
            if (this.modules == null) {
                this.modules = new ServiceLog[0];
            }
            String configFile = Config.getConfigDir() + File.separator + "module.conf";
            ModuleLoader loader = new ModuleLoader();
            this.modules = (ServiceLog[])loader.loadConfig(configFile, "msglog", this.modules);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.logger.info((Object)"destroy all message log modules");
        Object object = this.lock;
        synchronized (object) {
            for (ServiceLog module : this.modules) {
                module.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void instance() {
        this.logger.info((Object)"start all message log modules");
        Object object = this.lock;
        synchronized (object) {
            for (ServiceLog module : this.modules) {
                module.instance();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxSessionId() {
        int maxSession = 0;
        Object object = this.lock;
        synchronized (object) {
            for (ServiceLog module : this.modules) {
                int theMaxSession = module.getMaxSessionId();
                if (theMaxSession <= maxSession) continue;
                maxSession = theMaxSession;
            }
        }
        return maxSession;
    }
}

