/*
 * Decompiled with CFR 0.152.
 */
package vasp.messagelogger;

import java.sql.Connection;
import java.sql.SQLException;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import utils.ConnectionException;
import utils.DataStore;
import utils.DataStores;
import utils.QueuingProcessThreadMX;

public abstract class DatabaseLog
extends QueuingProcessThreadMX {
    protected Connection connection;
    protected int maxInsertPerTime = 50;
    protected int maxInsertTimeout = 2000;
    protected String logMsgClassName;
    protected boolean instance;
    protected long lastInserted;
    protected DataStore datastore;

    public DatabaseLog(String threadName) throws Exception {
        super(threadName);
        if (DataStores.isInstanced()) {
            this.datastore = DataStore.getDataStore();
            this.datastore.setLogger(this.logger);
        }
    }

    protected void validate() {
        if (this.connection != null && !DataStores.check((Connection)this.connection)) {
            this.connection = null;
        }
    }

    protected void connect() throws SQLException, ConnectionException {
        this.connection = this.datastore.getConnection();
    }

    public void destroy() {
        try {
            if (this.connection != null) {
                this.logger.info((Object)"close the database connection");
                this.connection.close();
                this.logger.info((Object)"close the database connection sucessfull");
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)("close connection exception:" + e));
        }
        this.stop();
    }

    public String getName() {
        return this.threadName;
    }

    public String getInfor() {
        StringBuffer buff = new StringBuffer(super.getInfor());
        if (this.datastore != null) {
            buff.append("\r\n------------database-----------\r\n");
            buff.append(this.datastore.getInfor());
            buff.append("\r\nmax_insert_time:" + this.maxInsertPerTime);
            buff.append("\r\ninsert_timeout:" + this.maxInsertTimeout);
        }
        return buff.toString();
    }

    public int getMaxInsertPerTime() {
        return this.maxInsertPerTime;
    }

    public void setMaxInsertPerTime(int maxInsertPerTime) {
        this.maxInsertPerTime = maxInsertPerTime;
    }

    public int getMaxInsertTimeout() {
        return this.maxInsertTimeout;
    }

    public void setMaxInsertTimeout(int maxInsertTimeout) {
        this.maxInsertTimeout = maxInsertTimeout;
    }

    protected MBeanAttributeInfo[] buildAttributes() {
        MBeanAttributeInfo[] mInfors = super.buildAttributes();
        MBeanAttributeInfo[] mNewInfors = new MBeanAttributeInfo[mInfors.length + 2];
        System.arraycopy(mInfors, 0, mNewInfors, 0, mInfors.length);
        mNewInfors[mInfors.length] = new MBeanAttributeInfo("MaxInsertRecord", "java.lang.Integer", "max record for a batch insert to database", true, true, false);
        mNewInfors[mInfors.length + 1] = new MBeanAttributeInfo("TimeoutInsert", "java.lang.Integer", "Timeout for insert to database(mili second). When the record in queue is less than MaxInsertRecord. Timeout is used for insert", true, true, false);
        return mNewInfors;
    }

    public Object getAttribute(String attribute_name) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (attribute_name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null"), "Cannot invoke a getter of " + this.dClassName + " with null attribute name");
        }
        if (attribute_name.equals("MaxInsertRecord")) {
            return this.getMaxInsertPerTime();
        }
        if (attribute_name.equals("TimeoutInsert")) {
            return this.getMaxInsertTimeout();
        }
        return super.getAttribute(attribute_name);
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute cannot be null"), "Cannot invoke a setter of " + this.dClassName + " with null attribute");
        }
        String name = attribute.getName();
        Object value = attribute.getValue();
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null"), "Cannot invoke the setter of " + this.dClassName + " with null attribute name");
        }
        if (name.equals("MaxInsertRecord")) {
            try {
                if (!Class.forName("java.lang.Integer").isAssignableFrom(value.getClass())) {
                    throw new InvalidAttributeValueException("Cannot set attribute " + name + " to a " + value.getClass().getName() + " object, String expected");
                }
                this.setMaxInsertPerTime((Integer)value);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        } else if (name.equals("TimeoutInsert")) {
            try {
                if (!Class.forName("java.lang.Integer").isAssignableFrom(value.getClass())) {
                    throw new InvalidAttributeValueException("Cannot set attribute " + name + " to a " + value.getClass().getName() + " object, String expected");
                }
                this.setMaxInsertTimeout((Integer)value);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            super.setAttribute(attribute);
        }
    }
}

