/*
 * Decompiled with CFR 0.152.
 */
package vasp;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import org.apache.log4j.Logger;
import utils.Config;
import vasp.Authenticator;
import vasp.utils.CommandUtils;

public class VaspAuthenticator
implements Authenticator {
    public static final String configFile = "users.conf";
    public static final int SUCCESS = 0;
    public static final int INVALID_USERPASS = 2;
    protected Vector<User> users = new Vector();
    protected Logger logger = Logger.getLogger((String)"Authen");

    public VaspAuthenticator() {
        this.reload();
    }

    @Override
    public boolean authen(String username, String password, String type) {
        for (User user : this.users) {
            if (!user.equals(username, password, type)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        String userconfigFile = Config.getConfigDir() + File.separator + configFile;
        this.logger.info((Object)("load vasp server config from  :" + userconfigFile));
        this.users.clear();
        FileReader f = null;
        BufferedReader r = null;
        try {
            String s;
            f = new FileReader(userconfigFile);
            r = new BufferedReader(f);
            String username = null;
            String password = null;
            String type = null;
            boolean foundUser = false;
            while ((s = r.readLine()) != null) {
                if (s.startsWith("#")) continue;
                if (s.equals("[user]")) {
                    foundUser = true;
                    username = null;
                    password = null;
                    type = null;
                } else if (s.startsWith("username") && foundUser) {
                    username = this.getValue(s);
                } else if (s.startsWith("password") && foundUser) {
                    password = this.getValue(s);
                } else if (s.startsWith("type") && foundUser) {
                    type = this.getValue(s);
                }
                if (username == null || password == null || type == null) continue;
                User user = new User(username, password, type);
                this.users.add(user);
                username = null;
                password = null;
                type = null;
            }
            r.close();
            f.close();
        }
        catch (FileNotFoundException ex) {
            this.logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        catch (IOException ex) {
            this.logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        finally {
            if (f != null) {
                try {
                    f.close();
                }
                catch (IOException ex) {
                    this.logger.error((Object)("fail to close stream:" + ex));
                }
            }
            if (r != null) {
                try {
                    r.close();
                }
                catch (IOException ex) {
                    this.logger.error((Object)("fail to close stream:" + ex));
                }
            }
        }
    }

    public String getValue(String s) {
        int i = s.indexOf(61);
        return i < 0 ? null : s.substring(i + 1).trim();
    }

    public String listUsers() {
        StringBuffer buff = new StringBuffer();
        buff.append(CommandUtils.format("username", 0, 23));
        buff.append(CommandUtils.format("password", 0, 23));
        buff.append(CommandUtils.format("type", 0, 10));
        for (User user : this.users) {
            buff.append("\r\n");
            buff.append(user.toString());
        }
        return buff.toString();
    }

    static class User {
        String user;
        String pass;
        String type;

        public User(String user, String pass, String type) {
            this.user = user;
            this.pass = pass;
            this.type = type;
        }

        boolean equals(String username, String password, String type) {
            return this.user.equals(username) && this.pass.equals(password) && this.type.equals(type);
        }

        public String toString() {
            return CommandUtils.format(this.user, 0, 23) + CommandUtils.format(this.pass, 0, 23) + CommandUtils.format(this.type, 0, 10);
        }
    }
}

