/*
 * Decompiled with CFR 0.152.
 */
package transport;

import java.io.File;
import org.apache.log4j.Logger;
import transport.LoadableTransport;
import transport.ServerTransport;
import transport.Transport;
import transport.message.Message;
import transport.message.ServiceMessage;
import utils.Config;
import utils.Queue;
import vasp.CommandRequest;
import vasp.CommandResponse;
import vasp.Commandable;
import vasp.utils.ModuleLoader;

public class TransportImpl
implements LoadableTransport,
Commandable {
    protected Transport[] transports;
    protected String sysId;
    protected Queue rx;
    protected Logger logger;
    protected Object lock = new Object();

    public TransportImpl(Queue rx) {
        this(null, rx);
    }

    public TransportImpl(String sysId, Queue rx) {
        this.sysId = sysId;
        this.rx = rx;
        this.logger = Logger.getLogger(TransportImpl.class);
        String configFile = Config.getConfigDir() + File.separator + "module.conf";
        ModuleLoader loader = new ModuleLoader();
        this.transports = (Transport[])loader.loadConfig(configFile, "transport", new Transport[0]);
        this.setReceiverQueue(rx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reload() {
        this.logger.info((Object)"load all transports");
        Object object = this.lock;
        synchronized (object) {
            if (this.transports == null) {
                this.transports = new Transport[0];
            }
            String configFile = Config.getConfigDir() + File.separator + "module.conf";
            this.logger.info((Object)("loading transport modules  in file: " + configFile));
            ModuleLoader loader = new ModuleLoader();
            this.transports = (Transport[])loader.loadConfig(configFile, "transport", this.transports);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRegister(ServiceMessage response) {
        Object object = this.lock;
        synchronized (object) {
            for (Transport module : this.transports) {
                if (!module.isRegister(response)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRequestFrom(ServiceMessage response) {
        Object object = this.lock;
        synchronized (object) {
            for (Transport module : this.transports) {
                if (!module.isRequestFrom(response)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSysId(String sysId) {
        this.sysId = sysId;
        Object object = this.lock;
        synchronized (object) {
            for (Transport module : this.transports) {
                module.setSysId(sysId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setReceiverQueue(Queue rx) {
        this.rx = rx;
        Object object = this.lock;
        synchronized (object) {
            for (Transport module : this.transports) {
                module.setReceiverQueue(rx);
            }
        }
    }

    @Override
    public boolean isRegisted() {
        return true;
    }

    @Override
    public String getSysId() {
        return this.sysId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int enTx(Message message) {
        if (!(message instanceof ServiceMessage)) {
            this.logger.info((Object)"message type is not support, transport is dropt message now");
            return 0;
        }
        ServiceMessage svmessage = (ServiceMessage)message;
        String gatewayId = svmessage.getGateway();
        Object object = this.lock;
        synchronized (object) {
            Transport transport;
            if (gatewayId != null) {
                for (Transport module : this.transports) {
                    transport = module;
                    if (!transport.isRequestFrom(svmessage)) continue;
                    return transport.enTx(svmessage);
                }
            }
            this.logger.info((Object)"anonymous source module, routing by config file");
            for (Transport module : this.transports) {
                transport = module;
                if (!transport.isRegister(svmessage)) continue;
                return transport.enTx(svmessage);
            }
            this.logger.info((Object)"routing is failure, message is now dropt");
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        this.logger.info((Object)"starting all transports");
        Object object = this.lock;
        synchronized (object) {
            for (Transport module : this.transports) {
                module.start();
            }
        }
        this.logger.info((Object)"all transports are started");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        this.logger.info((Object)"stop all transports");
        Object object = this.lock;
        synchronized (object) {
            for (Transport module : this.transports) {
                module.stop();
            }
        }
        this.logger.info((Object)"all transports are stopped");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restart() {
        this.logger.info((Object)"restarting all transports");
        Object object = this.lock;
        synchronized (object) {
            for (Transport module : this.transports) {
                module.restart();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        this.logger.info((Object)"destroy all transports");
        Object object = this.lock;
        synchronized (object) {
            for (Transport module : this.transports) {
                module.destroy();
            }
        }
    }

    @Override
    public String getIdString() {
        return "transport";
    }

    @Override
    public CommandResponse exec(CommandRequest cmd) {
        String id = cmd.getIndentify();
        String[] args = cmd.getArgs();
        if ("show".equals(id) && args != null && args.length == 1 && "vasps".equals(args[0])) {
            StringBuffer buff = new StringBuffer();
            for (Transport transport : this.transports) {
                if (!(transport instanceof ServerTransport)) continue;
                buff.append(((ServerTransport)transport).listTransports());
            }
            return cmd.createResponse(buff.toString());
        }
        if (("show".equals(id) || "stop".equals(id)) && args != null && args.length == 2 && "vasp".equals(args[0])) {
            for (Transport module : this.transports) {
                CommandResponse response;
                if (!(module instanceof Commandable) || (response = ((Commandable)((Object)module)).exec(cmd)) == null) continue;
                return response;
            }
            return cmd.createResponse("vasp name not found");
        }
        return cmd.createResponse("invalid command");
    }

    @Override
    public String getInfor() {
        int transportCount = this.transports != null ? this.transports.length : 0;
        StringBuffer buf = new StringBuffer();
        buf.append("SysId=" + this.sysId);
        buf.append("\r\nQueue=" + this.rx.size());
        buf.append("\r\nTransports=" + transportCount);
        return buf.toString();
    }
}

