/*
 * Decompiled with CFR 0.152.
 */
package smi;

import java.io.IOException;
import java.lang.reflect.Field;
import net.wimpi.telnetd.io.BasicTerminalIO;
import net.wimpi.telnetd.io.TelnetIO;
import net.wimpi.telnetd.io.TerminalIO;
import net.wimpi.telnetd.net.Connection;
import net.wimpi.telnetd.net.ConnectionEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ShellIo
implements BasicTerminalIO {
    private static Log trace = LogFactory.getLog(ShellIo.class);
    private final Connection connection;
    private final BasicTerminalIO terminalIo;
    private final TelnetIO telnetIo;
    private final int[] buffer = new int[1024];
    private int bufferPosition = 0;

    public ShellIo(Connection connection) {
        this.connection = connection;
        this.terminalIo = connection.getTerminalIO();
        try {
            Field field = this.terminalIo.getClass().getDeclaredField("m_TelnetIO");
            field.setAccessible(true);
            this.telnetIo = (TelnetIO)field.get(this.terminalIo);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    private void putBuffer(int c) {
        this.buffer[this.bufferPosition++] = c;
    }

    private void putBuffer(int c, int number) {
        for (int i = 0; i < number; ++i) {
            this.putBuffer(c);
        }
    }

    private int bufferedRead() throws IOException {
        int result;
        if (this.bufferPosition > 0) {
            --this.bufferPosition;
            result = this.buffer[this.bufferPosition];
        } else {
            result = this.telnetIo.read();
        }
        if (trace.isDebugEnabled()) {
            trace.debug((Object)("n original read:     " + result));
        }
        return result;
    }

    public int read() throws IOException {
        int i = this.bufferedRead();
        i = ((TerminalIO)this.terminalIo).getTerminal().translateControlCharacter(i);
        if (trace.isDebugEnabled()) {
            trace.debug((Object)("n translate control:      " + i));
        }
        if (i == 1306) {
            this.connection.processConnectionEvent(new ConnectionEvent(this.connection, 102));
            i = 1305;
        } else if (i > 256 && i == 1200) {
            i = this.handleEscapeSequence();
        }
        if (trace.isDebugEnabled()) {
            trace.debug((Object)("n result:      " + i));
        }
        return i;
    }

    private int handleEscapeSequence() throws IOException {
        int c = this.bufferedRead();
        if (c == 91) {
            int number = 0;
            while ((c = this.bufferedRead()) >= 0 && c < 256 && Character.isDigit((char)c)) {
                number = number * 10 + c - 48;
            }
            if (number == 0) {
                number = 1;
            }
            if (trace.isDebugEnabled()) {
                trace.debug((Object)("number=" + number));
            }
            switch (c) {
                case 65: {
                    this.putBuffer(1001, --number);
                    return 1001;
                }
                case 66: {
                    this.putBuffer(1002, --number);
                    return 1002;
                }
                case 67: {
                    this.putBuffer(1003, --number);
                    return 1003;
                }
                case 68: {
                    this.putBuffer(1004, --number);
                    return 1004;
                }
                case 80: {
                    this.putBuffer(1302, --number);
                    return 1302;
                }
                case 126: {
                    if (number != 3) break;
                    this.putBuffer(1302);
                }
            }
        }
        trace.error((Object)("Unrecognized ESC sequence with char " + c + " " + (char)c));
        return 1202;
    }

    public void bell() throws IOException {
        this.terminalIo.bell();
    }

    public void close() throws IOException {
        this.terminalIo.close();
    }

    public boolean defineScrollRegion(int topmargin, int bottommargin) throws IOException {
        return this.terminalIo.defineScrollRegion(topmargin, bottommargin);
    }

    public void eraseLine() throws IOException {
        this.terminalIo.eraseLine();
    }

    public void eraseScreen() throws IOException {
        this.terminalIo.eraseScreen();
    }

    public void eraseToBeginOfLine() throws IOException {
        this.terminalIo.eraseToBeginOfLine();
    }

    public void eraseToBeginOfScreen() throws IOException {
        this.terminalIo.eraseToBeginOfScreen();
    }

    public void eraseToEndOfLine() throws IOException {
        this.terminalIo.eraseToEndOfLine();
    }

    public void eraseToEndOfScreen() throws IOException {
        this.terminalIo.eraseToEndOfScreen();
    }

    public void flush() throws IOException {
        this.terminalIo.flush();
    }

    public void forceBold(boolean b) {
        this.terminalIo.forceBold(b);
    }

    public int getColumns() {
        return this.terminalIo.getColumns();
    }

    public int getRows() {
        return this.terminalIo.getRows();
    }

    public void homeCursor() throws IOException {
        this.terminalIo.homeCursor();
    }

    public boolean isAutoflushing() {
        return this.terminalIo.isAutoflushing();
    }

    public boolean isLineWrapping() throws IOException {
        return this.terminalIo.isLineWrapping();
    }

    public boolean isSignalling() {
        return this.terminalIo.isSignalling();
    }

    public void moveCursor(int direction, int times) throws IOException {
        this.terminalIo.moveCursor(direction, times);
    }

    public void moveDown(int times) throws IOException {
        this.terminalIo.moveDown(times);
    }

    public void moveLeft(int times) throws IOException {
        this.terminalIo.moveLeft(times);
    }

    public void moveRight(int times) throws IOException {
        this.terminalIo.moveRight(times);
    }

    public void moveUp(int times) throws IOException {
        this.terminalIo.moveUp(times);
    }

    public void resetAttributes() throws IOException {
        this.terminalIo.resetAttributes();
    }

    public void resetTerminal() throws IOException {
        this.terminalIo.resetTerminal();
    }

    public void restoreCursor() throws IOException {
        this.terminalIo.restoreCursor();
    }

    public void setAutoflushing(boolean b) {
        this.terminalIo.setAutoflushing(b);
    }

    public void setBackgroundColor(int color) throws IOException {
        this.terminalIo.setBackgroundColor(color);
    }

    public void setBlink(boolean b) throws IOException {
        this.terminalIo.setBlink(b);
    }

    public void setBold(boolean b) throws IOException {
        this.terminalIo.setBold(b);
    }

    public void setCursor(int row, int col) throws IOException {
        this.terminalIo.setCursor(row, col);
    }

    public void setDefaultTerminal() throws IOException {
        this.terminalIo.setDefaultTerminal();
    }

    public void setForegroundColor(int color) throws IOException {
        this.terminalIo.setForegroundColor(color);
    }

    public void setItalic(boolean b) throws IOException {
        this.terminalIo.setItalic(b);
    }

    public void setLinewrapping(boolean b) throws IOException {
        this.terminalIo.setLinewrapping(b);
    }

    public void setSignalling(boolean b) {
        this.terminalIo.setSignalling(b);
    }

    public void setTerminal(String terminalname) throws IOException {
        this.terminalIo.setTerminal(terminalname);
    }

    public void setUnderlined(boolean b) throws IOException {
        this.terminalIo.setUnderlined(b);
    }

    public void storeCursor() throws IOException {
        this.terminalIo.storeCursor();
    }

    public void write(byte b) throws IOException {
        this.terminalIo.write(b);
    }

    public void write(char ch) throws IOException {
        this.terminalIo.write(ch);
    }

    public void write(String str) throws IOException {
        this.terminalIo.write(str);
    }

    public void write(byte[] bytes) throws IOException {
        this.telnetIo.write(bytes);
        if (this.terminalIo.isAutoflushing()) {
            this.terminalIo.flush();
        }
    }
}

