/*
 * Decompiled with CFR 0.152.
 */
package filter;

import filter.ServiceFilter;
import java.io.File;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import org.apache.log4j.Logger;
import transport.message.ServiceMessage;
import utils.AgentMX;
import utils.Config;
import vasp.CommandRequest;
import vasp.CommandResponse;
import vasp.Commandable;
import vasp.utils.CommandUtils;
import vasp.utils.ModuleLoader;

public class ServiceFilterImpl
extends AgentMX
implements ServiceFilter,
Commandable {
    ServiceFilter[] modules;
    Logger logger;
    Object lock = new Object();

    public ServiceFilterImpl() {
        this.logger = Logger.getLogger((String)"Smsgate");
        String configFile = Config.getConfigDir() + File.separator + "module.conf";
        ModuleLoader loader = new ModuleLoader();
        this.modules = (ServiceFilter[])loader.loadConfig(configFile, "filter", new ServiceFilter[0]);
        try {
            this.registerAgent("smsws.gateway:type=Filters");
        }
        catch (MalformedObjectNameException ex) {
            this.logger.error((Object)"register service agent error");
            this.logger.error((Object)("exception:" + ex.toString()));
        }
        catch (InstanceAlreadyExistsException ex) {
            this.logger.error((Object)"register service agent error");
            this.logger.error((Object)("exception:" + ex.toString()));
        }
        catch (MBeanRegistrationException ex) {
            this.logger.error((Object)"register service agent error");
            this.logger.error((Object)("exception:" + ex.toString()));
        }
        catch (NotCompliantMBeanException ex) {
            this.logger.error((Object)"register service agent error");
            this.logger.error((Object)("exception:" + ex.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String filter(ServiceMessage message) {
        Object object = this.lock;
        synchronized (object) {
            for (ServiceFilter module : this.modules) {
                String s = module.filter(message);
                if (s != null && s.equals("Ok")) continue;
                return s;
            }
        }
        return "Ok";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reload() {
        Object object = this.lock;
        synchronized (object) {
            String configFile = Config.getConfigDir() + File.separator + "module.conf";
            ModuleLoader loader = new ModuleLoader();
            this.modules = (ServiceFilter[])loader.loadConfig(configFile, "filter", new ServiceFilter[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        this.logger.info((Object)"destroy all service module modules");
        Object object = this.lock;
        synchronized (object) {
            for (ServiceFilter module : this.modules) {
                module.destroy();
            }
        }
        try {
            this.unregisterAgent("smsws.gateway:type=Filters");
        }
        catch (MalformedObjectNameException ex) {
            this.logger.info((Object)("unregister agent error:" + ex.toString()));
            this.logger.error((Object)("exception:" + ex.toString()));
        }
        catch (InstanceNotFoundException ex) {
            this.logger.info((Object)("unregister agent error:" + ex.toString()));
            this.logger.error((Object)("exception:" + ex.toString()));
        }
        catch (MBeanRegistrationException ex) {
            this.logger.info((Object)("unregister agent error:" + ex.toString()));
            this.logger.error((Object)("exception:" + ex.toString()));
        }
    }

    @Override
    public CommandResponse exec(CommandRequest cmdRequest) {
        String id = cmdRequest.getIndentify();
        String[] args = cmdRequest.getArgs();
        if ("reload".equals(id) && args.length >= 2) {
            if (this.modules != null && this.modules.length > 0) {
                for (int i = 0; i < this.modules.length; ++i) {
                    if (!args[1].equals(this.modules[i].getName())) continue;
                    if (args.length == 2) {
                        this.modules[i].reload();
                        return cmdRequest.createResponse("the filter module " + args[1] + " has been reloaded");
                    }
                    if (!(this.modules[i] instanceof Commandable)) continue;
                    return ((Commandable)((Object)this.modules[i])).exec(cmdRequest);
                }
            }
            return cmdRequest.createResponse("invalid filter module name");
        }
        if ("show".equals(id) && args.length >= 2) {
            if (this.modules != null && this.modules.length > 0) {
                for (int i = 0; i < this.modules.length; ++i) {
                    if (!args[1].equals(this.modules[i].getName())) continue;
                    if (args.length == 2) {
                        return cmdRequest.createResponse(this.modules[i].getInfor());
                    }
                    if (!(this.modules[i] instanceof Commandable)) continue;
                    return ((Commandable)((Object)this.modules[i])).exec(cmdRequest);
                }
            }
            return cmdRequest.createResponse("invalid filter module name");
        }
        if ("clear".equals(id) && args.length >= 2) {
            if (this.modules != null && this.modules.length > 0) {
                for (int i = 0; i < this.modules.length; ++i) {
                    if (!args[1].equals(this.modules[i].getName())) continue;
                    return ((Commandable)((Object)this.modules[i])).exec(cmdRequest);
                }
            }
            return cmdRequest.createResponse("invalid filter module name");
        }
        return cmdRequest.createResponse("invalid command");
    }

    @Override
    public String getInfor() {
        StringBuffer buff = new StringBuffer();
        buff.append(CommandUtils.format("id", 1, 12));
        buff.append(CommandUtils.format("name", 1, 25));
        int id = 1;
        if (this.modules != null && this.modules.length > 0) {
            for (int i = 0; i < this.modules.length; ++i) {
                buff.append("\r\n");
                String idx = String.valueOf(id++);
                buff.append(CommandUtils.format(idx, 1, 12));
                buff.append(CommandUtils.format(this.modules[i].getName(), 1, 25));
            }
        }
        return buff.toString();
    }

    @Override
    public String getName() {
        return "FilterImpl";
    }
}

