/*
 * Decompiled with CFR 0.152.
 */
package event;

import com.sun.mail.smtp.SMTPTransport;
import com.viettel.mmserver.base.ProcessThreadMX;
import event.EventInterface;
import event.EventMessage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import java.util.Vector;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ReflectionException;
import org.apache.log4j.Logger;
import transport.message.Message;
import utils.Config;
import utils.Protocol;
import utils.Queue;
import vasp.utils.CommandUtils;
import vasp.utils.ConfigParser;
import vasp.utils.VaspUtils;

public class SmtpReport
extends ProcessThreadMX
implements EventInterface {
    public static final String SMTP_REPORT = "SmtpReport";
    SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
    Protocol protocol;
    String user;
    String pass;
    String subject;
    String sender;
    String[] receiver;
    int startTime;
    int endTime;
    int frequency;
    Vector<Report> reports;
    int lastMinute;
    int minuteCount;
    String lastReport;
    long reportCount;
    Logger smtpLog = Logger.getLogger((String)"smtp");

    public SmtpReport() {
        super(SMTP_REPORT);
        this.reports = new Vector();
        this.reload();
        try {
            this.registerAgent("smsws.gateway:type=Events,name=SmtpReport");
        }
        catch (MalformedObjectNameException ex) {
            this.logger.error((Object)"register service agent error");
            this.logger.error((Object)("exception:" + ex.toString()));
        }
        catch (InstanceAlreadyExistsException ex) {
            this.logger.error((Object)"register service agent error");
            this.logger.error((Object)("exception:" + ex.toString()));
        }
        catch (MBeanRegistrationException ex) {
            this.logger.error((Object)"register service agent error");
            this.logger.error((Object)("exception:" + ex.toString()));
        }
        catch (NotCompliantMBeanException ex) {
            this.logger.error((Object)"register service agent error");
            this.logger.error((Object)("exception:" + ex.toString()));
        }
        this.start();
    }

    protected void process() {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException ex) {
            this.logger.info((Object)("interrupted:" + ex));
        }
        Calendar c = Calendar.getInstance();
        int currentMinute = c.get(12);
        if (currentMinute == this.lastMinute) {
            return;
        }
        this.lastMinute = currentMinute;
        ++this.minuteCount;
        if (this.minuteCount > this.frequency) {
            int hour = c.get(11);
            if (hour >= this.startTime && hour <= this.endTime) {
                this.report();
            }
            this.minuteCount = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEvent(Message message) {
        if (!(message instanceof EventMessage)) {
            return;
        }
        EventMessage event = (EventMessage)message;
        int type = event.getType();
        String service = event.getService();
        if (service == null) {
            service = "smsws";
        }
        Object object = this.lock;
        synchronized (object) {
            Report report2;
            for (Report report2 : this.reports) {
                if (!service.equals(report2.service)) continue;
                if (type == 0) {
                    report2.addMo();
                } else if (type == 1) {
                    report2.addMt();
                }
                return;
            }
            int index = this.reports.size() + 1;
            report2 = new Report(index, service);
            if (type == 0) {
                report2.addMo();
            } else if (type == 1) {
                report2.addMt();
            }
            this.reports.add(report2);
        }
    }

    @Override
    public void setQueue(Queue queue) {
    }

    @Override
    public void destroy() {
        super.destroy();
        try {
            this.unregisterAgent("smsws.gateway:type=Events,name=SmtpReport");
        }
        catch (MalformedObjectNameException ex) {
            this.logger.info((Object)("unregister agent error:" + ex.toString()));
            this.logger.error((Object)("exception:" + ex.toString()));
        }
        catch (InstanceNotFoundException ex) {
            this.logger.info((Object)("unregister agent error:" + ex.toString()));
            this.logger.error((Object)("exception:" + ex.toString()));
        }
        catch (MBeanRegistrationException ex) {
            this.logger.info((Object)("unregister agent error:" + ex.toString()));
            this.logger.error((Object)("exception:" + ex.toString()));
        }
    }

    @Override
    public void reload() {
        try {
            String configFile = Config.getConfigDir() + File.separator + "smtp-report.conf";
            this.logger.info((Object)("load config file from : " + configFile));
            ReportConfigParser parser = new ReportConfigParser(this.getThreadName());
            parser.parser(configFile);
        }
        catch (FileNotFoundException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void report() {
        StringBuffer buff = new StringBuffer();
        buff.append(CommandUtils.format("IDX", 2, 5));
        buff.append(CommandUtils.format("SERVICE", 0, 30));
        buff.append(CommandUtils.format("MO", 0, 7));
        buff.append(CommandUtils.format("MT", 0, 7));
        Object object = this.lock;
        synchronized (object) {
            for (Report report : this.reports) {
                buff.append("\r\n");
                buff.append(report.debugString());
            }
            this.reports.clear();
        }
        try {
            this.logger.info((Object)"report gateway traffic");
            this.logger.info((Object)("\r\n" + buff.toString()));
            this.smtpLog.info((Object)("\r\n" + buff.toString()));
            this.logger.info((Object)("send smtp mail " + this.protocol.getUrl()));
            Properties props = new Properties();
            props.put("mail.transport.protocol", this.protocol.getProtocol());
            props.put("mail.smtp.host", this.protocol.getIp());
            props.put("mail.smtp.port", (Object)this.protocol.getPort());
            props.put("mail.smtp.auth", "false");
            props.put("mail.smtp.quitwait", "false");
            props.put("mail.smtp.connectiontimeoutt", "60000");
            props.put("mail.smtp.timeout", "600000");
            Session session = Session.getDefaultInstance((Properties)props, null);
            session.setDebug(true);
            MimeMessage message = new MimeMessage(session);
            String mailSubject = this.subject + " " + VaspUtils.getFullTimeDesp();
            message.setSubject(mailSubject);
            message.setText(buff.toString());
            InternetAddress from = new InternetAddress(this.sender);
            message.setFrom((Address)from);
            for (int i = 0; i < this.receiver.length; ++i) {
                InternetAddress to = new InternetAddress(this.receiver[i]);
                if (i < 3) {
                    message.addRecipient(Message.RecipientType.TO, (Address)to);
                    continue;
                }
                message.addRecipient(Message.RecipientType.BCC, (Address)to);
            }
            SMTPTransport transport = (SMTPTransport)session.getTransport(this.protocol.getProtocol());
            long time = System.currentTimeMillis();
            transport.connect();
            message.saveChanges();
            transport.sendMessage((javax.mail.Message)message, message.getAllRecipients());
            this.logger.info((Object)"waiting for server response");
            this.logger.info((Object)transport.getLastServerResponse());
            transport.close();
            long seconds = (System.currentTimeMillis() - time) / 1000L;
            this.logger.info((Object)("sendding time = " + seconds));
        }
        catch (MessagingException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        this.lastReport = this.format.format(new Date());
        this.reportCount = VaspUtils.increase(this.reportCount, 1L);
    }

    protected MBeanOperationInfo[] buildOperations() {
        MBeanOperationInfo[] mbOperations = super.buildOperations();
        MBeanOperationInfo[] mbNewOperations = new MBeanOperationInfo[mbOperations.length + 1];
        System.arraycopy(mbOperations, 0, mbNewOperations, 0, mbOperations.length);
        mbNewOperations[mbOperations.length] = new MBeanOperationInfo("reload", "reload module", null, "java.lang.String", 1);
        return mbNewOperations;
    }

    public Object invoke(String operationName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if ("reload".equals(operationName)) {
            this.reload();
            return null;
        }
        return super.invoke(operationName, params, signature);
    }

    @Override
    public String getInfor() {
        Calendar c = Calendar.getInstance();
        int hour = c.get(11);
        StringBuffer buff = new StringBuffer(super.getInfor());
        buff.append("\r\nMail Url = " + this.protocol.getUrl());
        buff.append("\r\nMail User = " + this.user);
        buff.append("\r\nMail Pass = " + this.pass);
        buff.append("\r\nMail Subject = " + this.subject);
        buff.append("\r\nFrequency = " + this.frequency);
        buff.append("\r\nSender = " + this.sender);
        buff.append("\r\nReceiver = " + VaspUtils.add(this.receiver));
        buff.append("\r\nMin_Hour = " + this.startTime);
        buff.append("\r\nMax_Hour = " + this.endTime);
        buff.append("\r\nLastReport = " + this.lastReport);
        buff.append("\r\nCurrentHour = " + hour);
        buff.append("\r\nMinutes = " + this.minuteCount);
        buff.append("\r\nReports = " + this.reportCount);
        return buff.toString();
    }

    @Override
    public String getName() {
        return SMTP_REPORT;
    }

    class ReportConfigParser
    extends ConfigParser {
        public ReportConfigParser(String name) {
            super(name);
        }

        @Override
        protected void onValue(String name, String value) {
            super.onValue(name, value);
            if ("mailurl".equals(name)) {
                SmtpReport.this.protocol = new Protocol(value);
            } else if ("mailuser".equals(name)) {
                SmtpReport.this.user = value;
            } else if ("mailpass".equals(name)) {
                SmtpReport.this.pass = value;
            } else if ("sender".equals(name)) {
                SmtpReport.this.sender = value;
            } else if ("subject".equals(name)) {
                SmtpReport.this.subject = value;
            } else if ("min_hour".equals(name)) {
                SmtpReport.this.startTime = VaspUtils.getInt(value, 8);
            } else if ("max_hour".equals(name)) {
                SmtpReport.this.endTime = VaspUtils.getInt(value, 8);
            } else if ("frequency".equals(name)) {
                SmtpReport.this.frequency = VaspUtils.getInt(value, 8);
            }
        }

        @Override
        protected void onValue(String name, String[] value) {
            super.onValue(name, value);
            if ("receiver".equals(name)) {
                SmtpReport.this.receiver = value;
            }
        }
    }

    static class Report {
        int index;
        String service;
        int mo;
        int mt;

        public Report(int index, String service) {
            this.index = index;
            this.service = service;
        }

        public String debugString() {
            return CommandUtils.format("" + this.index, 2, 5) + CommandUtils.format(this.service, 0, 30) + CommandUtils.format("" + this.mo, 0, 7) + CommandUtils.format("" + this.mt, 0, 7);
        }

        void addMo() {
            ++this.mo;
            if (this.mo == Integer.MAX_VALUE) {
                this.mo = 0;
            }
        }

        void addMt() {
            ++this.mt;
            if (this.mt == Integer.MAX_VALUE) {
                this.mt = 0;
            }
        }
    }
}

