/*
 * Decompiled with CFR 0.152.
 */
package loader;

import loader.ResourceStore;
import org.apache.log4j.Logger;

public class ResourceStoreClassLoader
extends ClassLoader {
    private Logger log = Logger.getLogger((String)"Loader");
    private ResourceStore stores;

    public ResourceStoreClassLoader(ClassLoader pParent, ResourceStore pStores) {
        super(pParent);
        this.stores = pStores;
    }

    private Class fastFindClass(String name) {
        byte[] clazzBytes;
        if (this.stores != null && (clazzBytes = this.stores.read(ResourceStoreClassLoader.convertClassToResourcePath(name))) != null) {
            this.log.debug((Object)(this.getId() + " found class: " + name + " (" + clazzBytes.length + " bytes)"));
            return this.defineClass(name, clazzBytes, 0, clazzBytes.length);
        }
        return null;
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        this.log.debug((Object)(this.getId() + " looking for: " + name));
        Class<?> clazz = this.findLoadedClass(name);
        if (clazz == null) {
            ClassLoader parent = this.getParent();
            if (parent != null) {
                try {
                    this.log.debug((Object)(this.getId() + " delegating loading to parent"));
                    this.log.debug((Object)(parent.getClass().getName() + " loading class " + name));
                    clazz = parent.loadClass(name);
                    this.log.debug((Object)("loaded class " + name + " from " + parent.getClass().getName()));
                }
                catch (ClassNotFoundException ex) {
                    // empty catch block
                }
            }
            if (clazz == null) {
                clazz = this.fastFindClass(name);
                if (resolve) {
                    this.resolveClass(clazz);
                }
                if (clazz == null) {
                    throw new ClassNotFoundException(name);
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)(this.getId() + " loaded from store: " + name));
                }
            }
        }
        return clazz;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        Class clazz = this.fastFindClass(name);
        if (clazz == null) {
            throw new ClassNotFoundException(name);
        }
        return clazz;
    }

    private String getId() {
        return this.getClass().getName() + "[" + Thread.currentThread().getContextClassLoader().getClass().getName() + "]";
    }

    public static String convertClassToResourcePath(String pName) {
        return pName.replace('.', '/') + ".class";
    }
}

