/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.mmserver.basev1;

public class BooleanLock {
    private boolean value;

    public BooleanLock() {
        this(false);
    }

    public BooleanLock(boolean value) {
        this.value = value;
    }

    public synchronized void setValue(boolean newValue) {
        if (newValue != this.value) {
            this.value = newValue;
            this.notifyAll();
        }
    }

    public synchronized boolean waitToSetTrue(long msTimeOut) throws InterruptedException {
        boolean success = this.waitUntilFalse(msTimeOut);
        if (success) {
            this.setValue(true);
        }
        return success;
    }

    public synchronized boolean waitToSetFalse(long msTimeOut) throws InterruptedException {
        boolean success = this.waitUntilTrue(msTimeOut);
        if (success) {
            this.setValue(false);
        }
        return success;
    }

    public synchronized boolean waitUntilTrue(long msTimeOut) throws InterruptedException {
        return this.waitUntilStateIs(true, msTimeOut);
    }

    public synchronized boolean waitUntilFalse(long msTimeOut) throws InterruptedException {
        return this.waitUntilStateIs(false, msTimeOut);
    }

    public synchronized boolean isTrue() {
        return this.value;
    }

    public synchronized boolean isFalse() {
        return !this.value;
    }

    public synchronized boolean waitUntilStateIs(boolean state, long msTimeOut) throws InterruptedException {
        if (msTimeOut == 0L) {
            while (this.value != state) {
                this.wait();
            }
            return true;
        }
        long endTime = System.currentTimeMillis() + msTimeOut;
        long remainTime = msTimeOut;
        while (this.value != state && remainTime > 0L) {
            this.wait(remainTime);
            remainTime = endTime - System.currentTimeMillis();
        }
        return this.value == state;
    }
}

