/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.mmserver.authenticator;

import com.viettel.mmserver.agent.MMbeanServer;
import com.viettel.mmserver.authenticator.MmAuthenticatorMBean;
import com.viettel.mmserver.authenticator.MmUser;
import com.viettel.mmserver.base.Log;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import javax.management.ObjectName;
import viettel.passport.client.ObjectToken;
import viettel.passport.client.VSAValidate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MmAuthenticator
implements MmAuthenticatorMBean {
    private VSAValidate vsa;
    private static MmAuthenticator mmAuthenticator;
    private final int timeOut = 30000;

    public static MmAuthenticator getInstance() {
        if (mmAuthenticator == null) {
            mmAuthenticator = new MmAuthenticator();
        }
        return mmAuthenticator;
    }

    private MmAuthenticator() {
        try {
            ObjectName name = new ObjectName("Tools:name=MmAuthenticator");
            MMbeanServer.getInstance().registerMBean(this, name);
            Log.info("Registered MmAuthenticator");
        }
        catch (Exception e) {
            Log.error("Can not register Mbean MmAuthenticator");
            Log.error(e);
        }
        Log.info("Creating VSAValidate...");
        this.vsa = new VSAValidate();
        this.vsa.setTimeOutVal(30000);
        Log.info("VSAValidate created!");
    }

    public MmUser validate(String username, String password, String appID) {
        MmUser mmUser = null;
        this.vsa.setDomainCode(appID);
        this.vsa.setUser(username);
        this.vsa.setPassword(password);
        try {
            Log.info("Validating VSA with timeout = " + this.vsa.getTimeOutVal());
            this.vsa.validate();
            Log.info("Validated");
            if (this.vsa.isAuthenticationSuccesful()) {
                Hashtable<String, List<String>> roleMap = new Hashtable<String, List<String>>();
                ArrayList objList = this.vsa.getUserToken().getParentMenu();
                for (Object ob : objList) {
                    if (!(ob instanceof ObjectToken)) continue;
                    LinkedList<String> temp = new LinkedList<String>();
                    ObjectToken element = (ObjectToken)ob;
                    String objectName = element.getObjectName();
                    ArrayList childs = element.getChildObjects();
                    if (childs != null) {
                        for (int i = 0; i < childs.size(); ++i) {
                            ObjectToken child = (ObjectToken)childs.get(i);
                            if (!"C".equalsIgnoreCase(child.getObjectType())) continue;
                            temp.add(child.getObjectName());
                        }
                    }
                    roleMap.put(objectName, temp);
                }
                mmUser = new MmUser(username, password, appID, roleMap);
            }
        }
        catch (Exception e) {
            Log.error("Error in validate with Passport");
            Log.error(e);
        }
        return mmUser;
    }

    private String formatCanonicalName(String name) {
        int index;
        String formatedName = name;
        if (name == null) {
            formatedName = "";
        }
        if ((index = name.indexOf(":")) != -1 && index < name.length()) {
            formatedName = name.substring(0, index + 1);
            String[] names = (name = name.substring(index + 1)).split(",");
            if (names.length > 0) {
                int i;
                for (i = 0; i < names.length - 1; ++i) {
                    for (int j = i + 1; j < names.length; ++j) {
                        if (names[i].compareTo(names[j]) <= 0) continue;
                        String temp = names[i];
                        names[i] = names[j];
                        names[j] = temp;
                    }
                }
                for (i = 0; i < names.length; ++i) {
                    formatedName = formatedName + names[i] + ",";
                }
                formatedName = formatedName.substring(0, formatedName.length() - 1);
            }
        }
        return formatedName;
    }

    public LinkedList<String> getAccessibleMethods(String appId, String userName, String password, String mBeanObjectName) {
        MmUser mmUser = this.validate(userName, password, appId);
        if (mmUser == null) {
            return null;
        }
        LinkedList<String> method = mmUser.getMethods(mBeanObjectName);
        if (method == null) {
            return new LinkedList<String>();
        }
        return method;
    }
}

