/*
 * Decompiled with CFR 0.152.
 */
package vasp.listener;

import java.util.Vector;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import transport.message.ServiceMessage;
import utils.ProcessorMX;
import vasp.MessageProcess;
import vasp.listener.VaspProcess;

public abstract class ServiceProcessImpl
extends ProcessorMX {
    protected MessageProcess responseProcessor;
    protected Vector<VaspProcess> processes = new Vector();

    public ServiceProcessImpl(MessageProcess responseProcessor) {
        super("Services");
        this.responseProcessor = responseProcessor;
        try {
            this.registerAgent("smsws.gateway:type=Services");
        }
        catch (MalformedObjectNameException ex) {
            this.logger.error((Object)"register service agent error");
            this.logger.error((Object)("exception:" + ex.toString()));
        }
        catch (InstanceAlreadyExistsException ex) {
            this.logger.error((Object)"register service agent error");
            this.logger.error((Object)("exception:" + ex.toString()));
        }
        catch (MBeanRegistrationException ex) {
            this.logger.error((Object)"register service agent error");
            this.logger.error((Object)("exception:" + ex.toString()));
        }
        catch (NotCompliantMBeanException ex) {
            this.logger.error((Object)"register service agent error");
            this.logger.error((Object)("exception:" + ex.toString()));
        }
    }

    public void start() {
        this.logger.info((Object)"start service process");
        for (VaspProcess process : this.processes) {
            process.start();
        }
    }

    public void stop() {
        this.logger.info((Object)"stop service process");
        for (VaspProcess process : this.processes) {
            process.stop();
        }
    }

    public void restart() {
        this.logger.info((Object)"restart service process");
        for (VaspProcess process : this.processes) {
            process.restart();
        }
    }

    public void destroy() {
        this.stop();
        try {
            this.unregisterAgent("smsws.gateway:type=Services");
        }
        catch (MalformedObjectNameException ex) {
            this.logger.info((Object)("unregister agent error:" + ex.toString()));
            this.logger.error((Object)("exception:" + ex.toString()));
        }
        catch (InstanceNotFoundException ex) {
            this.logger.info((Object)("unregister agent error:" + ex.toString()));
            this.logger.error((Object)("exception:" + ex.toString()));
        }
        catch (MBeanRegistrationException ex) {
            this.logger.info((Object)("unregister agent error:" + ex.toString()));
            this.logger.error((Object)("exception:" + ex.toString()));
        }
    }

    public VaspProcess getProcess(String name) {
        for (VaspProcess process : this.processes) {
            if (!process.getName().equals(name)) continue;
            return process;
        }
        return null;
    }

    public VaspProcess getProcess(ServiceMessage message) {
        for (VaspProcess process : this.processes) {
            if (!process.isRegister(message)) continue;
            return process;
        }
        return null;
    }

    public String getInfor() {
        StringBuffer buffer = new StringBuffer("Processors:" + this.processes.size());
        for (VaspProcess process : this.processes) {
            buffer.append("\r\n");
            buffer.append(process.getInfor());
        }
        return buffer.toString();
    }

    public static VaspProcess getProcess(String id, VaspProcess[] exchanges) {
        if (exchanges == null) {
            return null;
        }
        for (VaspProcess proxy : exchanges) {
            if (!proxy.getName().equals(id)) continue;
            return proxy;
        }
        return null;
    }

    protected MBeanOperationInfo[] buildOperations() {
        MBeanOperationInfo[] mbInfors = super.buildOperations();
        MBeanOperationInfo[] mbNewInfors = new MBeanOperationInfo[mbInfors.length + 2];
        System.arraycopy(mbInfors, 0, mbNewInfors, 0, mbInfors.length);
        MBeanParameterInfo[] params = new MBeanParameterInfo[]{};
        mbNewInfors[mbInfors.length] = new MBeanOperationInfo("reloadAll", "reload all processors", params, "void", 1);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("module", "java.lang.String", "the module name will be reloaded")};
        mbNewInfors[mbInfors.length + 1] = new MBeanOperationInfo("reload", "reload specific processor", params, "void", 1);
        return mbNewInfors;
    }

    public Object invoke(String operationName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (operationName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Operation name cannot be null"), "Cannot invoke a null operation in " + this.dClassName);
        }
        if (operationName.equals("reload")) {
            this.reload((String)params[0]);
            return null;
        }
        if (operationName.equals("reloadAll")) {
            this.reloadAll();
            return null;
        }
        return super.invoke(operationName, params, signature);
    }

    public abstract void reload(String var1);

    public abstract void reloadAll();
}

