/*
 * Decompiled with CFR 0.152.
 */
package transport;

import transport.AuthenticatedServerTransport;
import transport.ServerTransport;
import transport.Transport;
import transport.TransportImpl;
import utils.Queue;
import vasp.GwAuthenticator;
import vasp.utils.CommandUtils;

public class ServerTransportImpl
extends TransportImpl
implements ServerTransport {
    public ServerTransportImpl(Queue rx) {
        super(rx);
    }

    public ServerTransportImpl(Queue rx, GwAuthenticator authen) {
        super(rx);
        this.setAuthen(authen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAuthen(GwAuthenticator authen) {
        Object object = this.lock;
        synchronized (object) {
            for (Transport module : this.transports) {
                if (!(module instanceof AuthenticatedServerTransport)) continue;
                ((AuthenticatedServerTransport)module).setAuthen(authen);
            }
        }
    }

    @Override
    public String listTransports() {
        StringBuffer buf = new StringBuffer();
        buf.append(CommandUtils.format("id", 1, 12));
        buf.append(CommandUtils.format("sysid", 1, 12));
        buf.append(CommandUtils.format("type", 1, 12));
        if (this.transports == null || this.transports.length == 0) {
            buf.append("no connected vasp");
        } else {
            for (Transport module : this.transports) {
                buf.append(module.getInfor());
            }
        }
        return buf.toString();
    }
}

