/*
 * Decompiled with CFR 0.152.
 */
package filter;

import filter.ServiceFilter;
import filter.SpamModuleMX;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import transport.message.Request;
import transport.message.ServiceMessage;
import utils.Config;
import utils.ConnectionException;
import utils.DataStores;
import vasp.utils.VaspUtils;

public class SpamModule
extends SpamModuleMX
implements ServiceFilter {
    private static final int CLEAR_TIME = 60000;
    private static final int TIMEOUT = 86400000;
    protected final Object lock = new Object();
    private Vector<RequestStore> requests = new Vector();
    private Vector<SpamRule> spamRules = new Vector();
    private HashMap<String, Integer> prices = new HashMap();
    private long lastClearTime;

    public SpamModule(String name) {
        super(name);
        this.reload();
        this.loadOldRequest();
        this.lastClearTime = System.currentTimeMillis();
        this.registerAgent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadOldRequest() {
        InputStreamReader in = null;
        BufferedReader buf = null;
        Object object = this.lock;
        synchronized (object) {
            try {
                String s;
                String spamDir = Config.getLogDir() + File.separator + File.separator + "spamlog.txt";
                File f = new File(spamDir);
                if (!f.exists()) {
                    return;
                }
                in = new FileReader(f);
                buf = new BufferedReader(in);
                while ((s = buf.readLine()) != null) {
                    StringTokenizer token = new StringTokenizer(s, "|");
                    if (token.countTokens() != 3) continue;
                    try {
                        String spamName = token.nextToken();
                        String spamMobile = token.nextToken();
                        String vaspid = token.nextToken();
                        String content = token.nextToken();
                        long time = Long.parseLong(token.nextToken());
                        if (!this.name.equals(spamName)) continue;
                        this.addRequest(spamMobile, vaspid, content, time);
                    }
                    catch (NumberFormatException e) {
                        this.logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                in.close();
            }
            catch (IOException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ex) {
                        this.logger.error((Object)("fail to close stream:" + ex));
                    }
                }
                if (buf != null) {
                    try {
                        buf.close();
                    }
                    catch (IOException ex) {
                        this.logger.error((Object)("fail to close stream:" + ex));
                    }
                }
            }
        }
    }

    private void addRequest(String mobile, String vaspid, String content) {
        long time = System.currentTimeMillis();
        this.addRequest(mobile, vaspid, content, time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRequest(String mobile, String vaspid, String content, long time) {
        mobile = VaspUtils.formatMobile(mobile);
        RequestStore request = new RequestStore(mobile, vaspid, content, time);
        Object object = this.lock;
        synchronized (object) {
            this.requests.addElement(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String filter(ServiceMessage message) {
        if (!(message instanceof Request)) {
            return "Ok";
        }
        Request request = (Request)message;
        String msisdn = request.getSender();
        String shortCode = request.getReceiver();
        String content = request.getContent();
        Object object = this.lock;
        synchronized (object) {
            for (SpamRule spamRule : this.spamRules) {
                int i = this.checkRule(msisdn, shortCode, content, spamRule);
                if (i == -1) continue;
                return i == 0 ? spamRule.spamResponseKey : "Ignore";
            }
        }
        this.addRequest(msisdn, shortCode, content);
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastClearTime > 60000L) {
            this.clearTimeout();
            this.lastClearTime = currentTime;
        }
        return "Ok";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearTimeout() {
        Object object = this.lock;
        synchronized (object) {
            long time = System.currentTimeMillis();
            RequestStore[] resquest = new RequestStore[this.requests.size()];
            this.requests.toArray(resquest);
            for (RequestStore req : resquest) {
                if (time - req.time <= 86400000L) continue;
                this.requests.remove(req);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearRequests() {
        this.logger.info((Object)"clear all request store  in gateway");
        Object object = this.lock;
        synchronized (object) {
            this.requests.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearRequests(String mobile) {
        Object object = this.lock;
        synchronized (object) {
            mobile = VaspUtils.formatMobile(mobile);
            this.logger.info((Object)("clear all request store  in gateway with mobile is " + mobile));
            RequestStore[] _requests = new RequestStore[this.requests.size()];
            this.requests.toArray(_requests);
            for (RequestStore request : _requests) {
                if (!request.mobile.equals(mobile)) continue;
                this.requests.remove(request);
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getInfor() {
        StringBuffer buff = new StringBuffer();
        buff.append(this.name + "\r\n");
        buff.append("Rule:\r\n");
        for (SpamRule spamRule : this.spamRules) {
            buff.append("\r\n[" + spamRule + "]");
        }
        return buff.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showRequests(String mobile) {
        Object object = this.lock;
        synchronized (object) {
            mobile = VaspUtils.formatMobile(mobile);
            this.logger.info((Object)("detail request of " + mobile + " in spamlist "));
            RequestStore[] _requests = new RequestStore[this.requests.size()];
            this.requests.toArray(_requests);
            int count = 0;
            for (RequestStore request : _requests) {
                if (!request.mobile.equals(mobile)) continue;
                this.logger.info((Object)("    " + request.toString()));
                ++count;
            }
            this.logger.info((Object)("Total request :" + count));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reload() {
        ResultSet rs = null;
        try {
            this.prices.clear();
            String sql = "select * from prices";
            this.logger.info((Object)sql);
            rs = DataStores.doQuery((String)sql);
            while (rs.next()) {
                String shortCode = rs.getString("SHORTCODE");
                int price = rs.getInt("PRICE");
                this.prices.put(shortCode, price);
            }
            rs.close();
            this.spamRules.clear();
            sql = "select s.rulename, s.max_request, s.max_money, s.response_sms from spamrule s, antispam a where s.rulename=a.rulename and a.spam_module ='" + this.name + "'";
            this.logger.info((Object)sql);
            rs = DataStores.doQuery((String)sql);
            while (rs.next()) {
                String ruleId = rs.getString("RULENAME");
                int maxRequest = rs.getInt("MAX_REQUEST");
                int maxMoney = rs.getInt("MAX_MONEY");
                String spamResponseKey = rs.getString("RESPONSE_SMS");
                this.spamRules.add(new SpamRule(ruleId, maxRequest, maxMoney, spamResponseKey));
            }
            rs.close();
            for (SpamRule spamRule : this.spamRules) {
                sql = "select * from spamparam where rulename='" + spamRule.id + "'";
                this.logger.info((Object)sql);
                rs = DataStores.doQuery((String)sql);
                while (rs.next()) {
                    String rname = rs.getString("NAME");
                    String rvalue = rs.getString("VALUE");
                    spamRule.addParam(rname, rvalue);
                }
                rs.close();
            }
        }
        catch (ConnectionException ex) {
            this.logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        catch (SQLException ex) {
            this.logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                this.logger.error((Object)("fail to close stream:" + ex));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Object object = this.lock;
        synchronized (object) {
            OutputStreamWriter out = null;
            try {
                String spamDir = Config.getLogDir() + File.separator + "spam";
                File f = new File(spamDir);
                if (!f.exists() && !f.mkdirs()) {
                    this.logger.error((Object)("make directory:" + f.getAbsolutePath() + " failure"));
                    return;
                }
                String spamlog = spamDir + File.separator + "spamlog.txt";
                out = new FileWriter(spamlog);
                for (RequestStore request : this.requests) {
                    out.write(this.name + "|" + request.toString() + "\r\n");
                }
                out.flush();
                out.close();
            }
            catch (IOException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException e) {
                    this.logger.error((Object)("fail to close stream:" + e));
                }
            }
        }
        this.unregisterAgent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int checkRule(String mobile, String shortCode, String content, SpamRule rule) {
        int requestInInterval = 0;
        int moneyInInterval = 0;
        Object object = this.lock;
        synchronized (object) {
            for (RequestStore request : this.requests) {
                if (!rule.checked(mobile, shortCode, content, request)) continue;
                ++requestInInterval;
                if (!this.prices.containsKey(request.vaspid)) continue;
                moneyInInterval += this.prices.get(request.vaspid).intValue();
            }
            if (rule.maxRequest > 0 && requestInInterval >= rule.maxRequest) {
                return requestInInterval - rule.maxRequest;
            }
            int money = this.prices.containsKey(shortCode) ? this.prices.get(shortCode) : 0;
            if (rule.maxMoney > 0 && money > 0 && (moneyInInterval += money) >= rule.maxMoney) {
                return (moneyInInterval - rule.maxMoney) / money;
            }
        }
        return -1;
    }

    class SpamRule {
        static final String CONTENT = "Content";
        static final String SHORT_CODE = "Shortcode";
        static final String TIME = "Time";
        static final String DATE = "Date";
        String[] PARAMS = new String[]{"Content", "Shortcode", "Time", "Date"};
        String id;
        int maxRequest;
        int maxMoney;
        Vector<SpamParam> params;
        String spamResponseKey;

        public SpamRule(String id, int maxRequest, int maxMoney, String spamResponseKey) {
            this.id = id;
            this.maxRequest = maxRequest;
            this.maxMoney = maxMoney;
            this.spamResponseKey = spamResponseKey;
            this.params = new Vector();
        }

        public void addParam(String name, String value) {
            if (this.wrongParam(name)) {
                return;
            }
            for (SpamParam param : this.params) {
                if (!param.name.equals(name)) continue;
                return;
            }
            this.params.add(new SpamParam(name, value));
        }

        public boolean wrongParam(String name) {
            for (String param : this.PARAMS) {
                if (!param.equals(name)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            String str = "rule(" + this.id + ")-> max_request=" + this.maxRequest + ",max_money=" + this.maxMoney + ",response=" + this.spamResponseKey;
            if (this.params.size() > 0) {
                str = str + "\r\n\t(";
                for (int i = 0; i < this.params.size(); ++i) {
                    if (i > 0) {
                        str = str + ",";
                    }
                    str = str + this.params.elementAt(i);
                }
                str = str + ")";
            }
            return str;
        }

        public boolean checked(String msisdn, String vaspid, String content, RequestStore request) {
            if (!request.mobile.equals(msisdn)) {
                return false;
            }
            if (this.params.size() == 0) {
                return false;
            }
            for (SpamParam param : this.params) {
                if (CONTENT.equals(param.getName()) && (content == null || !content.equals(request.content))) {
                    return false;
                }
                if (SHORT_CODE.equals(param.getName()) && !(param.equals(vaspid) & param.equals(request.vaspid))) {
                    return false;
                }
                if (DATE.equals(param.getName()) && !this.checkCurrentDate(request.time)) {
                    return false;
                }
                if (!TIME.equals(param.getName()) || System.currentTimeMillis() - request.time < (long)param.getTime()) continue;
                return false;
            }
            return true;
        }

        private boolean checkCurrentDate(long time) {
            Date d1 = new Date(time);
            Date d2 = new Date();
            return d1.getDate() == d2.getDate();
        }

        class SpamParam {
            String name;
            String value;
            int time;
            Pattern p;

            public SpamParam(String name) {
                this.name = name;
            }

            public SpamParam(String name, String value) {
                this.name = name;
                this.value = value;
                if (SpamRule.SHORT_CODE.equals(name)) {
                    this.p = Pattern.compile(value, 34);
                } else if (SpamRule.TIME.equals(name)) {
                    this.time = Integer.parseInt(value) * 60 * 1000;
                }
            }

            public String getName() {
                return this.name;
            }

            public void setName(String name) {
                this.name = name;
            }

            public String getValue() {
                return this.value;
            }

            public void setValue(String value) {
                this.value = value;
            }

            public int getTime() {
                return this.time;
            }

            public boolean equals(String value) {
                if (this.p != null) {
                    Matcher m = this.p.matcher(value);
                    return m.matches();
                }
                return this.value.equals(value);
            }

            public int compareTo(String value) {
                return this.value.compareTo(value);
            }

            public String toString() {
                return this.name + "=" + this.value;
            }
        }
    }

    static class RequestStore {
        String mobile;
        String vaspid;
        String content;
        long time;

        public RequestStore(String mobile, String vaspid, String content, long time) {
            this.mobile = mobile;
            this.vaspid = vaspid;
            this.content = content;
            this.time = time;
        }

        public boolean equals(String mobile) {
            return this.mobile != null && this.mobile.equalsIgnoreCase(mobile);
        }

        public String toString() {
            String timeDesp = VaspUtils.getFullTimeDesp(new Date(this.time));
            return this.mobile + " | " + timeDesp;
        }
    }
}

