/*
 * Decompiled with CFR 0.152.
 */
package event;

import event.EventInterface;
import java.io.File;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import org.apache.log4j.Logger;
import transport.message.Message;
import utils.AgentMX;
import utils.Config;
import utils.Queue;
import vasp.CommandRequest;
import vasp.CommandResponse;
import vasp.Commandable;
import vasp.utils.CommandUtils;
import vasp.utils.ModuleLoader;

public class EventImpl
extends AgentMX
implements EventInterface,
Commandable {
    EventInterface[] modules;
    Logger logger;
    Object lock = new Object();

    public EventImpl(Queue queue) {
        this.logger = Logger.getLogger(EventImpl.class);
        String configFile = Config.getConfigDir() + File.separator + "module.conf";
        ModuleLoader loader = new ModuleLoader();
        this.modules = (EventInterface[])loader.loadConfig(configFile, "event", new EventInterface[0]);
        this.setQueue(queue);
        try {
            this.registerAgent("smsws.gateway:type=Events");
        }
        catch (MalformedObjectNameException ex) {
            this.logger.error((Object)"register service agent error");
            this.logger.error((Object)("exception:" + ex.toString()));
        }
        catch (InstanceAlreadyExistsException ex) {
            this.logger.error((Object)"register service agent error");
            this.logger.error((Object)("exception:" + ex.toString()));
        }
        catch (MBeanRegistrationException ex) {
            this.logger.error((Object)"register service agent error");
            this.logger.error((Object)("exception:" + ex.toString()));
        }
        catch (NotCompliantMBeanException ex) {
            this.logger.error((Object)"register service agent error");
            this.logger.error((Object)("exception:" + ex.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEvent(Message message) {
        Object object = this.lock;
        synchronized (object) {
            for (EventInterface module : this.modules) {
                module.onEvent(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reload() {
        Object object = this.lock;
        synchronized (object) {
            String configFile = Config.getConfigDir() + File.separator + "module.conf";
            ModuleLoader loader = new ModuleLoader();
            this.modules = (EventInterface[])loader.loadConfig(configFile, "event", this.modules);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        this.logger.info((Object)"destroy all service module modules");
        Object object = this.lock;
        synchronized (object) {
            for (EventInterface module : this.modules) {
                module.destroy();
            }
        }
        try {
            this.unregisterAgent("smsws.gateway:type=Events");
        }
        catch (MalformedObjectNameException ex) {
            this.logger.info((Object)("unregister agent error:" + ex.toString()));
            this.logger.error((Object)("exception:" + ex.toString()));
        }
        catch (InstanceNotFoundException ex) {
            this.logger.info((Object)("unregister agent error:" + ex.toString()));
            this.logger.error((Object)("exception:" + ex.toString()));
        }
        catch (MBeanRegistrationException ex) {
            this.logger.info((Object)("unregister agent error:" + ex.toString()));
            this.logger.error((Object)("exception:" + ex.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setQueue(Queue queue) {
        Object object = this.lock;
        synchronized (object) {
            for (EventInterface module : this.modules) {
                module.setQueue(queue);
            }
        }
    }

    @Override
    public CommandResponse exec(CommandRequest cmdRequest) {
        String id = cmdRequest.getIndentify();
        String[] args = cmdRequest.getArgs();
        if ("reload".equals(id)) {
            this.reload();
            return cmdRequest.createResponse("event module has been reloaded");
        }
        if ("show".equals(id) && args != null && args.length == 1 && "events".equals(args[0])) {
            return cmdRequest.createResponse(this.getInfor());
        }
        if ("show".equals(id) && args != null && args.length == 2 && args[1] != null && "event".equals(args[0])) {
            if (this.modules != null && this.modules.length > 0) {
                for (int i = 0; i < this.modules.length; ++i) {
                    if (!args[1].equals(this.modules[i].getName())) continue;
                    return cmdRequest.createResponse(this.modules[i].getInfor());
                }
            }
            return cmdRequest.createResponse("invalid event module name");
        }
        return cmdRequest.createResponse("invalid command");
    }

    @Override
    public String getInfor() {
        StringBuffer buff = new StringBuffer();
        buff.append(CommandUtils.format("id", 1, 12));
        buff.append(CommandUtils.format("name", 1, 25));
        if (this.modules != null && this.modules.length > 0) {
            for (int i = 0; i < this.modules.length; ++i) {
                buff.append("\r\n");
                String idx = "" + (i + 1);
                buff.append(CommandUtils.format(idx, 1, 12));
                buff.append(CommandUtils.format(this.modules[i].getName(), 1, 25));
            }
        }
        return buff.toString();
    }

    @Override
    public String getName() {
        return "EventImpl";
    }
}

