/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.telnetd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import net.wimpi.telnetd.BootException;
import net.wimpi.telnetd.io.terminal.TerminalManager;
import net.wimpi.telnetd.net.PortListener;
import net.wimpi.telnetd.shell.ShellManager;
import net.wimpi.telnetd.util.PropertiesLoader;
import net.wimpi.telnetd.util.StringUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TelnetD {
    private static Log log;
    public static Log debuglog;
    public static Log syslog;
    private static TelnetD c_Self;
    private List m_Listeners;
    private ShellManager m_ShellManager;
    private static final String VERSION = "2.0";

    private TelnetD() {
        c_Self = this;
        this.m_Listeners = new ArrayList(5);
    }

    public void start() {
        log.debug((Object)"start()");
        for (int i = 0; i < this.m_Listeners.size(); ++i) {
            PortListener plis = (PortListener)this.m_Listeners.get(i);
            plis.start();
        }
    }

    public void stop() {
        for (int i = 0; i < this.m_Listeners.size(); ++i) {
            PortListener plis = (PortListener)this.m_Listeners.get(i);
            plis.stop();
        }
    }

    public String getVersion() {
        return VERSION;
    }

    private void prepareShellManager(Properties settings) throws BootException {
        this.m_ShellManager = ShellManager.createShellManager(settings);
        if (this.m_ShellManager == null) {
            System.exit(1);
        }
    }

    private void prepareListener(String name, Properties settings) throws BootException {
        PortListener listener = PortListener.createPortListener(name, settings);
        try {
            this.m_Listeners.add(listener);
        }
        catch (Exception ex) {
            throw new BootException("Failure while starting PortListener thread: " + ex.getMessage());
        }
    }

    private void prepareTerminals(Properties terminals) throws BootException {
        TerminalManager.createTerminalManager(terminals);
    }

    public PortListener getPortListener(String id) {
        if (id == null || id.length() == 0) {
            return null;
        }
        for (PortListener portListener : this.m_Listeners) {
            if (!portListener.getName().equals(id)) continue;
            return portListener;
        }
        return null;
    }

    public static TelnetD createTelnetD(Properties main) throws BootException {
        if (c_Self == null) {
            TelnetD td = new TelnetD();
            td.prepareShellManager(main);
            td.prepareTerminals(main);
            String[] listnames = StringUtil.split(main.getProperty("listeners"), ",");
            for (int i = 0; i < listnames.length; ++i) {
                td.prepareListener(listnames[i], main);
            }
            return td;
        }
        throw new BootException("Singleton already instantiated.");
    }

    public static TelnetD createTelnetD(String urlprefix) throws BootException {
        try {
            return TelnetD.createTelnetD(PropertiesLoader.loadProperties(urlprefix));
        }
        catch (IOException ex) {
            log.error((Object)ex);
            throw new BootException("Failed to load configuration from given URL.");
        }
    }

    public static TelnetD getReference() {
        if (c_Self != null) {
            return c_Self;
        }
        return null;
    }

    public static void main(String[] args) {
        TelnetD myTD = null;
        try {
            if (args.length == 0) {
                System.out.println("\nUsage: java net.wimpi.telnetd.TelnetD urlprefix\n");
                System.out.println("         java net.wimpi.telnetd.TelnetD url\n");
                System.exit(1);
            } else {
                myTD = TelnetD.createTelnetD(args[0]);
            }
            myTD.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    static {
        debuglog = log = LogFactory.getLog(TelnetD.class);
        syslog = log;
        c_Self = null;
    }
}

