/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jgroups.annotations.Experimental;
import org.jgroups.annotations.Property;
import org.jgroups.annotations.Unsupported;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PropertiesToXML {
    protected static final Log log = LogFactory.getLog(PropertiesToXML.class);

    public static void main(String[] args) {
        String input = "doc/manual/en/modules/protocols.xml";
        String input2 = "doc/manual/en/modules/installation.xml";
        if (args.length != 1) {
            PropertiesToXML.help();
            return;
        }
        input = args[0];
        String temp_file = input + ".tmp";
        String temp_file2 = input2 + ".tmp";
        try {
            File f = new File(temp_file);
            PropertiesToXML.copy(new FileReader(new File(input)), new FileWriter(f));
            String s = PropertiesToXML.fileToString(f);
            Set<Class<?>> classes = PropertiesToXML.findClassesAssignableFrom("org.jgroups.protocols", Protocol.class);
            classes.addAll(PropertiesToXML.findClassesAssignableFrom("org.jgroups.protocols.pbcast", Protocol.class));
            Properties props = new Properties();
            for (Class<?> clazz : classes) {
                PropertiesToXML.convertToDocbookTable(props, clazz);
            }
            String result = Util.replaceProperties(s, props);
            FileWriter fw = new FileWriter(f, false);
            fw.write(result);
            fw.flush();
            fw.close();
            f = new File(temp_file2);
            PropertiesToXML.copy(new FileReader(new File(input2)), new FileWriter(f));
            s = PropertiesToXML.fileToString(f);
            props = new Properties();
            List<Class<?>> unsupportedClasses = PropertiesToXML.findClassesAnnotatedWith("org.jgroups", Unsupported.class);
            PropertiesToXML.convertToDocbookTable(props, unsupportedClasses, "Unsupported");
            List<Class<?>> experimentalClasses = PropertiesToXML.findClassesAnnotatedWith("org.jgroups", Experimental.class);
            PropertiesToXML.convertToDocbookTable(props, experimentalClasses, "Experimental");
            result = Util.replaceProperties(s, props);
            fw = new FileWriter(f, false);
            fw.write(result);
            fw.flush();
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void help() {
        System.out.println("PropertiesToXML <input XML file>");
    }

    private static Set<Class<?>> findClassesAssignableFrom(String packageName, Class<?> assignableFrom) throws IOException, ClassNotFoundException {
        String filePath;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        HashSet classes = new HashSet();
        String path = packageName.replace('.', '/');
        URL resource = loader.getResource(path);
        if (resource != null && (filePath = resource.getFile()) != null && new File(filePath).isDirectory()) {
            for (String file : new File(filePath).list()) {
                String name;
                Class<?> clazz;
                if (!file.endsWith(".class") || !assignableFrom.isAssignableFrom(clazz = Class.forName(name = packageName + '.' + file.substring(0, file.indexOf(".class"))))) continue;
                classes.add(clazz);
            }
        }
        return classes;
    }

    private static List<Class<?>> findClassesAnnotatedWith(String packageName, Class<? extends Annotation> a) throws IOException, ClassNotFoundException {
        ArrayList classes = new ArrayList();
        PropertiesToXML.recurse(classes, packageName, a);
        return classes;
    }

    private static void recurse(List<Class<?>> classes, String packageName, Class<? extends Annotation> a) throws ClassNotFoundException {
        String filePath;
        String path;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL resource = loader.getResource(path = packageName.replace('.', '/'));
        if (resource != null && (filePath = resource.getFile()) != null && new File(filePath).isDirectory()) {
            for (String file : new File(filePath).list()) {
                if (file.endsWith(".class")) {
                    String name = packageName + '.' + file.substring(0, file.indexOf(".class"));
                    Class<?> clazz = Class.forName(name);
                    if (!clazz.isAnnotationPresent(a)) continue;
                    classes.add(clazz);
                    continue;
                }
                if (!new File(filePath, file).isDirectory()) continue;
                PropertiesToXML.recurse(classes, packageName + "." + file, a);
            }
        }
    }

    private static void convertToDocbookTable(Properties props, List<Class<?>> clazzes, String title) throws ParserConfigurationException, TransformerException {
        Document xmldoc = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        DOMImplementation impl = builder.getDOMImplementation();
        xmldoc = impl.createDocument(null, "table", null);
        Element tbody = PropertiesToXML.createXMLTable(xmldoc, title);
        for (Class<?> clazz : clazzes) {
            Element row = xmldoc.createElement("row");
            Element entry = xmldoc.createElement("entry");
            entry.setTextContent(clazz.getPackage().getName());
            row.appendChild(entry);
            entry = xmldoc.createElement("entry");
            entry.setTextContent(clazz.getSimpleName());
            row.appendChild(entry);
            tbody.appendChild(row);
        }
        if (clazzes != null && clazzes.size() > 1) {
            DOMSource domSource = new DOMSource(xmldoc);
            StringWriter sw = new StringWriter();
            StreamResult streamResult = new StreamResult(sw);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer serializer = tf.newTransformer();
            serializer.setOutputProperty("encoding", "ISO-8859-1");
            serializer.setOutputProperty("indent", "yes");
            serializer.transform(domSource, streamResult);
            StringBuffer buffer = sw.getBuffer();
            buffer.delete(0, buffer.indexOf("table") - 1);
            props.put(title, buffer.toString());
        }
    }

    private static void convertToDocbookTable(Properties props, Class<?> clazz) throws ParserConfigurationException, TransformerException {
        boolean isConcreteClass = (clazz.getModifiers() & 0x400) == 0;
        boolean isExperimental = clazz.isAnnotationPresent(Experimental.class);
        boolean isUnsupported = clazz.isAnnotationPresent(Unsupported.class);
        if (isConcreteClass && !isUnsupported) {
            Method[] methods;
            Class<?> protocol = clazz;
            Document xmldoc = null;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            DOMImplementation impl = builder.getDOMImplementation();
            xmldoc = impl.createDocument(null, "table", null);
            Element tbody = PropertiesToXML.createXMLTree(xmldoc, isExperimental);
            TreeMap<String, String> nameToDescription = new TreeMap<String, String>();
            for (Class<?> clazzInLoop = clazz; clazzInLoop != null; clazzInLoop = clazzInLoop.getSuperclass()) {
                Field[] fields;
                for (Field field : fields = clazzInLoop.getDeclaredFields()) {
                    if (!field.isAnnotationPresent(Property.class)) continue;
                    String property = field.getName();
                    Property annotation = field.getAnnotation(Property.class);
                    String desc = annotation.description();
                    nameToDescription.put(property, desc);
                }
            }
            for (Method method : methods = clazz.getMethods()) {
                Property annotation;
                String desc;
                if (!method.isAnnotationPresent(Property.class) || !method.getName().startsWith("set") || (desc = (annotation = method.getAnnotation(Property.class)).description()).length() <= 0) continue;
                String name = annotation.name();
                if (name.length() < 1) {
                    name = Util.methodNameToAttributeName(method.getName());
                }
                nameToDescription.put(name, desc);
            }
            for (Map.Entry e : nameToDescription.entrySet()) {
                Element row = xmldoc.createElement("row");
                Element entry = xmldoc.createElement("entry");
                entry.setTextContent((String)e.getKey());
                row.appendChild(entry);
                entry = xmldoc.createElement("entry");
                entry.setTextContent((String)e.getValue());
                row.appendChild(entry);
                tbody.appendChild(row);
            }
            if (nameToDescription.size() > 1) {
                DOMSource domSource = new DOMSource(xmldoc);
                StringWriter sw = new StringWriter();
                StreamResult streamResult = new StreamResult(sw);
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer serializer = tf.newTransformer();
                serializer.setOutputProperty("encoding", "ISO-8859-1");
                serializer.setOutputProperty("indent", "yes");
                serializer.transform(domSource, streamResult);
                StringBuffer buffer = sw.getBuffer();
                buffer.delete(0, buffer.indexOf("table") - 1);
                props.put(protocol.getSimpleName(), buffer.toString());
            }
        }
    }

    private static String fileToString(File f) throws Exception {
        StringWriter output = new StringWriter();
        FileReader input = new FileReader(f);
        char[] buffer = new char[8192];
        int count = 0;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += n;
        }
        return output.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(Reader input, Writer output) throws IOException {
        char[] buffer = new char[8192];
        int count = 0;
        int n = 0;
        try {
            while (-1 != (n = input.read(buffer))) {
                output.write(buffer, 0, n);
                count += n;
            }
        }
        finally {
            output.flush();
            output.close();
        }
        return count;
    }

    private static Element createXMLTree(Document xmldoc, boolean experimental) throws ParserConfigurationException {
        Element root = xmldoc.getDocumentElement();
        Element title = xmldoc.createElement("title");
        if (experimental) {
            title.setTextContent("Properties (experimental)");
        } else {
            title.setTextContent("Properties");
        }
        root.appendChild(title);
        Element tgroup = xmldoc.createElement("tgroup");
        tgroup.setAttribute("cols", "2");
        root.appendChild(tgroup);
        Element colspec = xmldoc.createElement("colspec");
        colspec.setAttribute("align", "left");
        tgroup.appendChild(colspec);
        Element thead = xmldoc.createElement("thead");
        tgroup.appendChild(thead);
        Element row = xmldoc.createElement("row");
        thead.appendChild(row);
        Element entry = xmldoc.createElement("entry");
        entry.setAttribute("align", "center");
        entry.setTextContent("Name");
        row.appendChild(entry);
        entry = xmldoc.createElement("entry");
        entry.setAttribute("align", "center");
        entry.setTextContent("Description");
        row.appendChild(entry);
        Element tbody = xmldoc.createElement("tbody");
        tgroup.appendChild(tbody);
        return tbody;
    }

    private static Element createXMLTable(Document xmldoc, String titleContent) throws ParserConfigurationException {
        Element root = xmldoc.getDocumentElement();
        Element title = xmldoc.createElement("title");
        title.setTextContent(titleContent);
        root.appendChild(title);
        Element tgroup = xmldoc.createElement("tgroup");
        tgroup.setAttribute("cols", "2");
        root.appendChild(tgroup);
        Element colspec = xmldoc.createElement("colspec");
        colspec.setAttribute("align", "left");
        tgroup.appendChild(colspec);
        Element thead = xmldoc.createElement("thead");
        tgroup.appendChild(thead);
        Element row = xmldoc.createElement("row");
        thead.appendChild(row);
        Element entry = xmldoc.createElement("entry");
        entry.setAttribute("align", "center");
        entry.setTextContent("Package");
        row.appendChild(entry);
        entry = xmldoc.createElement("entry");
        entry.setAttribute("align", "center");
        entry.setTextContent("Class");
        row.appendChild(entry);
        Element tbody = xmldoc.createElement("tbody");
        tgroup.appendChild(tbody);
        return tbody;
    }
}

