/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.jgroups.Message;
import org.jgroups.stack.AckReceiverWindow;
import org.jgroups.util.Tuple;
import org.jgroups.util.Util;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true)
public class AckReceiverWindowTest {
    AckReceiverWindow win;

    @BeforeMethod
    public void setUp() throws Exception {
        this.win = new AckReceiverWindow(1L);
    }

    @AfterMethod
    public void tearDown() throws Exception {
        this.win.reset();
    }

    public void testAdd() {
        this.win.reset();
        this.win = new AckReceiverWindow(10L);
        Assert.assertEquals((int)0, (int)this.win.size());
        this.win.add(9L, AckReceiverWindowTest.msg());
        Assert.assertEquals((int)0, (int)this.win.size());
        this.win.add(10L, AckReceiverWindowTest.msg());
        Assert.assertEquals((int)1, (int)this.win.size());
        this.win.add(13L, AckReceiverWindowTest.msg());
        Assert.assertEquals((int)2, (int)this.win.size());
        Message m = this.win.remove();
        assert (m != null);
        Assert.assertEquals((int)1, (int)this.win.size());
        m = this.win.remove();
        assert (m == null);
        Assert.assertEquals((int)1, (int)this.win.size());
        this.win.add(11L, AckReceiverWindowTest.msg());
        this.win.add(12L, AckReceiverWindowTest.msg());
        Assert.assertEquals((int)3, (int)this.win.size());
        m = this.win.remove();
        assert (m != null);
        m = this.win.remove();
        assert (m != null);
        m = this.win.remove();
        assert (m != null);
        Assert.assertEquals((int)0, (int)this.win.size());
        m = this.win.remove();
        assert (m == null);
    }

    public void testAddExisting() {
        this.win.add(1L, AckReceiverWindowTest.msg());
        assert (this.win.size() == 1);
        this.win.add(1L, AckReceiverWindowTest.msg());
        assert (this.win.size() == 1);
        this.win.add(2L, AckReceiverWindowTest.msg());
        assert (this.win.size() == 2);
    }

    public void testAddLowerThanNextToRemove() {
        this.win.add(1L, AckReceiverWindowTest.msg());
        this.win.add(2L, AckReceiverWindowTest.msg());
        this.win.remove();
        this.win.add(1L, AckReceiverWindowTest.msg());
        assert (this.win.size() == 1);
    }

    public void testRemove() {
        this.win.add(2L, AckReceiverWindowTest.msg());
        Message msg = this.win.remove();
        assert (msg == null);
        assert (this.win.size() == 1);
        this.win.add(1L, AckReceiverWindowTest.msg());
        assert (this.win.size() == 2);
        assert (this.win.remove() != null);
        assert (this.win.size() == 1);
        assert (this.win.remove() != null);
        assert (this.win.size() == 0);
        assert (this.win.remove() == null);
    }

    public void testDuplicates() {
        Assert.assertEquals((int)0, (int)this.win.size());
        assert (this.win.add(9L, AckReceiverWindowTest.msg()));
        assert (this.win.add(1L, AckReceiverWindowTest.msg()));
        assert (this.win.add(2L, AckReceiverWindowTest.msg()));
        assert (!this.win.add(2L, AckReceiverWindowTest.msg()));
        assert (!this.win.add(0L, AckReceiverWindowTest.msg()));
        assert (this.win.add(3L, AckReceiverWindowTest.msg()));
        assert (this.win.add(4L, AckReceiverWindowTest.msg()));
        assert (!this.win.add(4L, AckReceiverWindowTest.msg()));
    }

    public static void testRemoveRegularMessages() {
        AckReceiverWindow win = new AckReceiverWindow(1L);
        win.add(1L, AckReceiverWindowTest.msg());
        System.out.println("win = " + win);
        win.remove();
        System.out.println("win = " + win);
        assert (win.size() == 0);
        win.add(3L, AckReceiverWindowTest.msg());
        win.remove();
        System.out.println("win = " + win);
        assert (win.size() == 1);
        win.add(2L, AckReceiverWindowTest.msg(true));
        win.remove();
        System.out.println("win = " + win);
        assert (win.size() == 1);
    }

    public static void testRemoveMany() {
        AckReceiverWindow win = new AckReceiverWindow(1L);
        Tuple<List<Message>, Long> tuple = win.removeMany(100);
        assert (tuple == null);
        win.add(2L, AckReceiverWindowTest.msg());
        win.add(4L, AckReceiverWindowTest.msg());
        tuple = win.removeMany(100);
        assert (tuple == null);
        win.add(3L, AckReceiverWindowTest.msg());
        win.add(1L, AckReceiverWindowTest.msg());
        tuple = win.removeMany(10);
        List<Message> list = tuple.getVal1();
        assert (list.size() == 4);
        assert (tuple.getVal2() == 4L);
    }

    public static void testRemoveMany2() {
        AckReceiverWindow win = new AckReceiverWindow(1L);
        for (int i = 1; i <= 50; ++i) {
            win.add(i, AckReceiverWindowTest.msg());
        }
        System.out.println("win = " + win);
        List<Message> list = win.removeManyAsList(25);
        System.out.println("win = " + win);
        assert (list != null && list.size() == 25);
        assert (win.size() == 25);
        list = win.removeManyAsList(30);
        System.out.println("win = " + win);
        assert (list != null && list.size() == 25);
        assert (win.size() == 0);
    }

    public static void testSmallerThanNextToRemove() {
        Message msg;
        AckReceiverWindow win = new AckReceiverWindow(1L);
        for (long i = 1L; i <= 5L; ++i) {
            win.add(i, AckReceiverWindowTest.msg());
        }
        System.out.println("win = " + win);
        boolean added = win.add(3L, AckReceiverWindowTest.msg());
        assert (!added);
        while ((msg = win.remove()) != null) {
        }
        added = win.add(3L, AckReceiverWindowTest.msg());
        assert (!added);
    }

    public static void testConcurrentAdds() throws InterruptedException {
        AckReceiverWindow win = new AckReceiverWindow(1L);
        int NUM = 100;
        int NUM_THREADS = 10;
        CountDownLatch latch = new CountDownLatch(1);
        Adder[] adders = new Adder[10];
        for (int i = 0; i < adders.length; ++i) {
            adders[i] = new Adder(1L, 100L, 10L, win, latch);
        }
        for (Adder adder : adders) {
            adder.start();
        }
        latch.countDown();
        for (Adder adder : adders) {
            adder.join();
        }
        System.out.println("win = " + win);
        assert (win.size() == 100);
    }

    @Test(invocationCount=10)
    public static void testConcurrentAddsAndRemoves() throws InterruptedException {
        AckReceiverWindow win = new AckReceiverWindow(1L);
        int NUM = 100;
        int NUM_THREADS = 10;
        CountDownLatch latch = new CountDownLatch(1);
        Adder[] adders = new Adder[10];
        for (int i = 0; i < adders.length; ++i) {
            adders[i] = new Adder(1L, 100L, 10L, win, latch);
            adders[i].start();
        }
        Remover[] removers = new Remover[10];
        for (int i = 0; i < removers.length; ++i) {
            removers[i] = new Remover(win, latch);
            removers[i].start();
        }
        latch.countDown();
        for (Adder adder : adders) {
            adder.join();
        }
        System.out.println("win = " + win);
        int total = 0;
        int index = 0;
        for (Remover remover : removers) {
            remover.join();
            List<Message> list = remover.getList();
            System.out.println("remover #" + index++ + ": " + list.size() + " msgs");
            total += list.size();
        }
        System.out.println("total = " + total);
        if (total != 100) {
            for (Remover remover : removers) {
                System.out.println(remover + ": " + AckReceiverWindowTest.print(remover.getList()));
            }
        }
        assert (total == 100);
    }

    private static String print(List<Message> list) {
        StringBuilder sb = new StringBuilder();
        for (Message msg : list) {
            if (msg == AckReceiverWindow.TOMBSTONE) {
                sb.append("T ");
                continue;
            }
            sb.append(msg.getObject() + " ");
        }
        return sb.toString();
    }

    private static Message msg() {
        return AckReceiverWindowTest.msg(false);
    }

    private static Message msg(long seqno) {
        return AckReceiverWindowTest.msg(false, seqno);
    }

    private static Message msg(boolean oob, long seqno) {
        Message retval = new Message(null, null, Long.valueOf(seqno));
        if (oob) {
            retval.setFlag((byte)1);
        }
        return retval;
    }

    private static Message msg(boolean oob) {
        Message retval = new Message();
        if (oob) {
            retval.setFlag((byte)1);
        }
        return retval;
    }

    private static class Remover
    extends Thread {
        private final AckReceiverWindow win;
        private final CountDownLatch latch;
        private final List<Message> list = new LinkedList<Message>();

        public Remover(AckReceiverWindow win, CountDownLatch latch) {
            this.win = win;
            this.latch = latch;
            this.setName("Remover");
        }

        public List<Message> getList() {
            return this.list;
        }

        @Override
        public void run() {
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            int cnt = 5;
            while (true) {
                Message msg;
                if ((msg = this.win.remove()) != null) {
                    this.list.add(msg);
                    continue;
                }
                if (cnt-- <= 0) break;
                Util.sleep(100L);
            }
        }
    }

    private static class Adder
    extends Thread {
        private final long from;
        private final long to;
        private final long duplicates;
        private final AckReceiverWindow win;
        private final CountDownLatch latch;

        public Adder(long from, long to, long duplicates, AckReceiverWindow win, CountDownLatch latch) {
            this.from = from;
            this.to = to;
            this.duplicates = duplicates;
            this.win = win;
            this.latch = latch;
            this.setName("Adder");
        }

        @Override
        public void run() {
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            for (long i = this.from; i <= this.to; ++i) {
                int j = 0;
                while ((long)j < this.duplicates) {
                    this.win.add(i, AckReceiverWindowTest.msg(true, i));
                    ++j;
                }
            }
        }
    }
}

