/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jeptesting;

import java.util.Enumeration;
import java.util.Random;
import java.util.Stack;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.nfunk.jep.JEP;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.SymbolTable;
import org.nfunk.jep.Variable;
import org.nfunk.jep.function.PostfixMathCommand;

public class BugsTest
extends TestCase {
    private JEP jep;

    public BugsTest(String name) {
        super(name);
    }

    public void setUp() {
        this.jep = new JEP();
        this.jep.setImplicitMul(true);
        this.jep.addStandardFunctions();
        this.jep.addStandardConstants();
        this.jep.addComplex();
        this.jep.setTraverse(false);
    }

    public void testOpSetBug() {
        JEP j = new JEP(false, true, true, null);
        Assert.assertNotNull((Object)j.getOperatorSet());
    }

    public void testHasError() {
        this.jep.addFunction("custFunc", new CustFunc());
        this.jep.parseExpression("custFunc(-1)");
        Assert.assertTrue((!this.jep.hasError() ? 1 : 0) != 0);
        this.jep.getValue();
        Assert.assertTrue((boolean)this.jep.hasError());
        this.jep.parseExpression("custFunc(1, 1)");
        Assert.assertTrue((boolean)this.jep.hasError());
        this.jep.getValue();
        Assert.assertTrue((boolean)this.jep.hasError());
        this.jep.parseExpression("");
        Assert.assertTrue((boolean)this.jep.hasError());
        this.jep.getValue();
        Assert.assertTrue((boolean)this.jep.hasError());
        this.jep.parseExpression("1+");
        Assert.assertTrue((boolean)this.jep.hasError());
        this.jep.getValue();
        Assert.assertTrue((boolean)this.jep.hasError());
        this.jep.parseExpression("sin([1, 1])");
        Assert.assertTrue((!this.jep.hasError() ? 1 : 0) != 0);
        this.jep.getValue();
        Assert.assertTrue((boolean)this.jep.hasError());
    }

    public void testSetAllowUndeclared() {
        this.jep.initSymTab();
        this.jep.setAllowUndeclared(true);
        this.jep.parseExpression("x");
        SymbolTable st = this.jep.getSymbolTable();
        int i = 0;
        Enumeration e = st.elements();
        while (e.hasMoreElements()) {
            Variable var = (Variable)e.nextElement();
            Assert.assertTrue((boolean)var.getName().equals("x"));
            ++i;
        }
        Assert.assertTrue((i == 1 ? 1 : 0) != 0);
    }

    public void testBug1563324() {
        this.jep.initSymTab();
        this.jep.setAllowUndeclared(true);
        this.jep.parseExpression("abs(x)");
        this.jep.addVariable("x", new Random());
        Object result = this.jep.getValueAsObject();
        Assert.assertTrue((boolean)this.jep.hasError());
        this.jep.addVariable("x", -1.0);
        result = this.jep.getValueAsObject();
        Assert.assertTrue((result instanceof Double && (Double)result == 1.0 ? 1 : 0) != 0);
    }

    private class CustFunc
    extends PostfixMathCommand {
        public CustFunc() {
            this.numberOfParameters = 1;
        }

        public void run(Stack inStack) throws ParseException {
            this.checkStack(inStack);
            Object param = inStack.pop();
            if (!(param instanceof Number) || !(((Number)param).doubleValue() > 0.0)) {
                System.out.println("Throwing exception");
                throw new ParseException("Parameter is not a Number or not >0");
            }
            inStack.push(param);
        }
    }
}

