/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.common;

import com.viettel.common.Authenticator;
import com.viettel.common.ChannelGroup;
import com.viettel.common.ObjectServerChannel;
import com.viettel.common.ViettelHandlerAdapter;
import com.viettel.common.ViettelMsg;
import java.io.IOException;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;

public class Server {
    public static void main(String[] args) throws IOException {
        BasicConfigurator.configure();
        Logger logger = Logger.getLogger((String)"Server");
        ObjectServerChannel server = new ObjectServerChannel(8383);
        Authenticator authen = new Authenticator();
        server.setAuthenticator(authen);
        ChannelGroup group = new ChannelGroup();
        group.setLogger(logger);
        group.addChannel(server);
        group.connect();
        group.addHandler(new Handler(server));
        System.out.println("server listening on port 8383");
    }

    static class Handler
    extends ViettelHandlerAdapter {
        ObjectServerChannel channel;

        public Handler(ObjectServerChannel channel) {
            this.channel = channel;
        }

        public void onReceive(ViettelMsg msg) {
            try {
                System.out.println("on Receiver :" + msg);
                ViettelMsg response = msg.getResponse();
                response.setError("0");
                this.channel.sendAsyn(msg);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }

        public void onProcessed(ViettelMsg msg) {
            System.out.println("on Sent :" + msg);
        }
    }
}

