/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.tcttaglib.newtag;

import com.viettel.tcttaglib.newtag.VTScrollTablePagination;
import java.text.MessageFormat;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.displaytag.Messages;
import org.displaytag.pagination.SmartListHelper;
import org.displaytag.properties.TableProperties;
import org.displaytag.util.Href;

public class VTScrollTableSmartListHelper
extends SmartListHelper {
    private static Log log = LogFactory.getLog(VTScrollTableSmartListHelper.class);
    private List fullList;
    private int fullListSize;
    private int pageSize;
    private int pageCount;
    private boolean partialList;
    private int currentPage;
    private TableProperties properties;

    public VTScrollTableSmartListHelper(List list, int fullSize, int itemsInPage, TableProperties tableProperties, boolean partialList) {
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getString((String)"SmartListHelper.debug.instantiated", (Object[])new Object[]{new Integer(list.size()), new Integer(itemsInPage), new Integer(fullSize)}));
        }
        this.properties = tableProperties;
        this.pageSize = itemsInPage;
        this.fullList = list;
        this.fullListSize = fullSize;
        this.pageCount = this.computedPageCount();
        this.currentPage = 1;
        this.partialList = partialList;
    }

    protected VTScrollTableSmartListHelper() {
    }

    protected int computedPageCount() {
        int size = this.fullListSize;
        int div = size / this.pageSize;
        int result = size % this.pageSize == 0 ? div : div + 1;
        return result;
    }

    public int getFirstIndexForCurrentPage() {
        return this.getFirstIndexForPage(this.currentPage);
    }

    protected int getLastIndexForCurrentPage() {
        return this.getLastIndexForPage(this.currentPage);
    }

    protected int getFirstIndexForPage(int pageNumber) {
        int retval = (pageNumber - 1) * this.pageSize;
        return retval >= 0 ? retval : 0;
    }

    protected int getLastIndexForPage(int pageNumber) {
        int firstIndex = this.getFirstIndexForPage(pageNumber);
        int pageIndex = this.pageSize - 1;
        int lastIndex = this.fullListSize - 1;
        return Math.min(firstIndex + pageIndex, lastIndex);
    }

    public List getListForCurrentPage() {
        return this.getListForPage(this.currentPage);
    }

    protected List getListForPage(int pageNumber) {
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getString((String)"SmartListHelper.debug.sublist", (Object[])new Object[]{new Integer(pageNumber)}));
        }
        int firstIndex = this.getFirstIndexForPage(pageNumber);
        int lastIndex = this.getLastIndexForPage(pageNumber);
        if (this.partialList) {
            firstIndex = 0;
            lastIndex = Math.min(this.pageSize - 1, this.fullList.size() - 1);
        }
        return this.fullList.subList(firstIndex, lastIndex + 1);
    }

    public void setCurrentPage(int pageNumber) {
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getString((String)"SmartListHelper.debug.currentpage", (Object[])new Object[]{new Integer(pageNumber), new Integer(this.pageCount)}));
        }
        this.currentPage = pageNumber < 1 ? 1 : (pageNumber != 1 && pageNumber > this.pageCount ? this.pageCount : pageNumber);
    }

    public String getSearchResultsSummary() {
        String message;
        Object[] objs;
        if (this.fullListSize == 0) {
            objs = new Object[]{this.properties.getPagingItemsName()};
            message = this.properties.getPagingFoundNoItems();
        } else if (this.fullListSize == 1) {
            objs = new Object[]{this.properties.getPagingItemName()};
            message = this.properties.getPagingFoundOneItem();
        } else if (this.computedPageCount() == 1) {
            objs = new Object[]{new Integer(this.fullListSize), this.properties.getPagingItemsName(), this.properties.getPagingItemsName()};
            message = this.properties.getPagingFoundAllItems();
        } else {
            objs = new Object[]{new Integer(this.fullListSize), this.properties.getPagingItemsName(), new Integer(this.getFirstIndexForCurrentPage() + 1), new Integer(this.getLastIndexForCurrentPage() + 1), new Integer(this.currentPage), new Integer(this.pageCount)};
            message = this.properties.getPagingFoundSomeItems();
        }
        return MessageFormat.format(message, objs);
    }

    public String getPageNavigationBar(Href baseHref, String pageParameter, String requestUri, String targets) {
        String s1;
        int groupSize = this.properties.getPagingGroupSize();
        String attTagerts = " targets = \"";
        String attDojotype = " dojotype = \"struts:BindAnchor\" executescripts=\"true\" parsecontent=\"true\" ";
        String pageParamater = " pageParamater = \"" + pageParameter + "\" ";
        if (targets == null) {
            attTagerts = "";
            attDojotype = "";
        }
        VTScrollTablePagination pagination = new VTScrollTablePagination(baseHref, pageParameter, this.properties);
        pagination.setCurrent(new Integer(this.currentPage));
        if (this.pageCount == 0) {
            pagination.addPage(1, true);
        }
        int startPage = Math.max(Math.min(this.currentPage - groupSize / 2, this.pageCount - (groupSize - 1)), 1);
        int endPage = Math.min(startPage + groupSize - 1, this.pageCount);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Displaying pages from " + startPage + " to " + endPage));
        }
        if (this.currentPage != 1) {
            pagination.setFirst(new Integer(1));
            pagination.setPrevious(new Integer(this.currentPage - 1));
        }
        for (int j = startPage; j <= endPage; ++j) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("adding page " + j));
            }
            pagination.addPage(j, j == this.currentPage);
        }
        if (this.currentPage != this.pageCount) {
            pagination.setNext(new Integer(this.currentPage + 1));
            pagination.setLast(new Integer(this.pageCount));
        }
        String bannerFormat = pagination.isOnePage() ? this.properties.getPagingBannerOnePage() : (pagination.isFirst() ? this.properties.getPagingBannerFirst() : (pagination.isLast() ? this.properties.getPagingBannerLast() : this.properties.getPagingBannerFull()));
        String temp = bannerFormat;
        int index1 = bannerFormat.indexOf("{1}");
        if (index1 != -1) {
            s1 = temp.substring(0, index1 - 1);
            s1 = s1.substring(0, s1.length() - 6) + attTagerts + targets + "\"" + attDojotype + "href =\"" + requestUri;
            bannerFormat = s1 + bannerFormat.substring(index1, bannerFormat.length());
        }
        temp = bannerFormat;
        index1 = bannerFormat.indexOf("{2}");
        if (index1 != -1) {
            s1 = temp.substring(0, index1 - 1);
            s1 = s1.substring(0, s1.length() - 6) + attTagerts + targets + "\"" + attDojotype + "href =\"" + requestUri;
            bannerFormat = s1 + bannerFormat.substring(index1, bannerFormat.length());
        }
        temp = bannerFormat;
        index1 = bannerFormat.indexOf("{3}");
        if (index1 != -1) {
            s1 = temp.substring(0, index1 - 1);
            s1 = s1.substring(0, s1.length() - 6) + attTagerts + targets + "\"" + attDojotype + "href =\"" + requestUri;
            bannerFormat = s1 + bannerFormat.substring(index1, bannerFormat.length());
        }
        temp = bannerFormat;
        index1 = bannerFormat.indexOf("{4}");
        if (index1 != -1) {
            s1 = temp.substring(0, index1 - 1);
            s1 = s1.substring(0, s1.length() - 6) + attTagerts + targets + "\"" + attDojotype + "href =\"" + requestUri;
            bannerFormat = s1 + bannerFormat.substring(index1, bannerFormat.length());
        }
        String s = this.properties.getPagingPageLink();
        s = s.substring(2, s.length());
        s = ("<a " + attTagerts + targets + "\"" + attDojotype + pageParamater).concat(s);
        return pagination.getFormattedBanner(s, this.properties.getPagingPageSelected(), this.properties.getPagingPageSeparator(), bannerFormat, requestUri);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("fullList", (Object)this.fullList).append("fullListSize", this.fullListSize).append("pageSize", this.pageSize).append("pageCount", this.pageCount).append("properties", (Object)this.properties).append("currentPage", this.currentPage).append("partialList", this.partialList).toString();
    }
}

