/*
 * Decompiled with CFR 0.152.
 */
package vasp.utils;

import java.util.Stack;
import org.nfunk.jep.JEP;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;
import org.nfunk.jep.function.PostfixMathCommandI;
import vasp.utils.VaspUtils;

public class LogicParser {
    public static void main(String[] args) {
        JEP parser = new JEP();
        parser.addVariable("sender", (Object)"84989331689");
        parser.addVariable("receiver", (Object)"8247");
        String expr = "((wcmp(sender , \"8497*\") && !wcmp(sender , \"84978*\")) || wcmp(sender , \"8498*\")) && wcmp(receiver ,\"8?47\")";
        System.out.println("Starting CustFunc...");
        parser.addStandardFunctions();
        parser.addStandardConstants();
        parser.addFunction("wcmp", (PostfixMathCommandI)new WildCardwcmper());
        parser.parseExpression(expr);
        if (parser.hasError()) {
            System.out.println("Error while parsing");
            System.out.println(parser.getErrorInfo());
            return;
        }
        double value = parser.getValue();
        if (parser.hasError()) {
            System.out.println("Error during evaluation");
            System.out.println(parser.getErrorInfo());
            return;
        }
        System.out.println(expr + " = " + value);
    }

    static class WildCardwcmper
    extends PostfixMathCommand {
        public WildCardwcmper() {
            this.numberOfParameters = 2;
        }

        public void run(Stack inStack) throws ParseException {
            this.checkStack(inStack);
            String pattern = (String)inStack.pop();
            String value = (String)inStack.pop();
            boolean r = VaspUtils.matcher(value, pattern);
            inStack.push((double)r);
        }
    }
}

