/*
 * Decompiled with CFR 0.152.
 */
package vasp.listener;

import event.EventMessage;
import java.util.Vector;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import transport.message.Message;
import transport.message.Request;
import transport.message.Response;
import transport.message.ServiceMessage;
import transport.tcp.message.DeliverReport;
import transport.tcp.message.SubmitResponse;
import utils.ProcessorMX;
import vasp.MessageProcess;
import vasp.listener.BusinessProcess;
import vasp.listener.DefaultServiceListener;
import vasp.listener.ServiceListener;
import vasp.utils.ServiceRule;
import vasp.utils.VaspUtils;

public class VaspProcess
extends ProcessorMX
implements MessageProcess {
    private long mo;
    private long mt;
    protected ServiceRule rule = new ServiceRule();
    protected Vector<BusinessProcess> processors = new Vector();
    protected Class c;
    protected MessageProcess responseProcessor;

    public VaspProcess(MessageProcess responseProcessor, String name, Class c, int instances) throws InstantiationException, IllegalAccessException {
        super("smsws.vasp:type=" + name);
        this.responseProcessor = responseProcessor;
        this.c = c;
        for (int i = 0; i < instances; ++i) {
            try {
                String processorId = name + "-" + i;
                ServiceListener listener = (ServiceListener)c.newInstance();
                BusinessProcess process = new BusinessProcess(processorId, name, listener, this);
                this.processors.add(process);
                continue;
            }
            catch (RuntimeException ex) {
                this.logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        try {
            this.registerAgent("smsws.vasp:type=" + name);
        }
        catch (MalformedObjectNameException ex) {
            this.logger.error((Object)"register service agent error");
            this.logger.error((Object)("exception:" + ex.toString()));
        }
        catch (InstanceAlreadyExistsException ex) {
            this.logger.error((Object)"register service agent error");
            this.logger.error((Object)("exception:" + ex.toString()));
        }
        catch (MBeanRegistrationException ex) {
            this.logger.error((Object)"register service agent error");
            this.logger.error((Object)("exception:" + ex.toString()));
        }
        catch (NotCompliantMBeanException ex) {
            this.logger.error((Object)"register service agent error");
            this.logger.error((Object)("exception:" + ex.toString()));
        }
    }

    public int getProcessorCount() {
        return this.processors.size();
    }

    public void start() {
        for (BusinessProcess processor : this.processors) {
            processor.start();
        }
    }

    public void stop() {
        for (BusinessProcess processor : this.processors) {
            processor.stop();
        }
    }

    public void restart() {
        for (BusinessProcess processor : this.processors) {
            processor.restart();
        }
    }

    public void destroy() {
        try {
            this.unregisterAgent(this.logger.getName());
        }
        catch (MalformedObjectNameException ex) {
            this.logger.info((Object)("unregister agent error:" + ex.toString()));
            this.logger.error((Object)("exception:" + ex.toString()));
        }
        catch (InstanceNotFoundException ex) {
            this.logger.info((Object)("unregister agent error:" + ex.toString()));
            this.logger.error((Object)("exception:" + ex.toString()));
        }
        catch (MBeanRegistrationException ex) {
            this.logger.info((Object)("unregister agent error:" + ex.toString()));
            this.logger.error((Object)("exception:" + ex.toString()));
        }
    }

    public void setListener(Class c) throws InstantiationException, IllegalAccessException {
        this.c = c;
        this.logger.info((Object)"class has been loaded");
        for (BusinessProcess p : this.processors) {
            ServiceListener listener = (ServiceListener)c.newInstance();
            if (listener instanceof DefaultServiceListener) {
                ((DefaultServiceListener)listener).setName(this.getName());
                ((DefaultServiceListener)listener).setResponseProcess(this.responseProcessor);
            }
            p.setListener(listener);
        }
    }

    public String getInfor() {
        StringBuffer buff = new StringBuffer();
        buff.append(this.getName());
        buff.append("\r\nClass=" + this.c.getName());
        buff.append("\r\nProcessors:" + this.processors.size());
        buff.append("\r\nMo:" + this.mo);
        buff.append("\r\nMt:" + this.mt);
        buff.append("\r\n" + this.rule.toString());
        return buff.toString();
    }

    @Override
    public void process(Message message) {
        if (message instanceof Response) {
            this.mt = VaspUtils.increase(this.mt, 1L);
            this.responseProcessor.process(message);
            EventMessage eventMessage = new EventMessage(1, this.getName(), message.debugString());
            this.responseProcessor.process(eventMessage);
        }
    }

    public void onRequest(Request request) {
        this.logger.debug((Object)"receive request");
        this.mo = VaspUtils.increase(this.mo, 1L);
        EventMessage eventMessage = new EventMessage(0, this.getName(), request.debugString());
        this.responseProcessor.process(eventMessage);
        BusinessProcess processor = this.getTheBestProcessor();
        if (processor == null) {
            this.logger.warn((Object)"the processor is null");
            if (request instanceof Request) {
                String faultKey = "fault_" + request.getReceiver();
                String content = VaspUtils.getResourceString(faultKey);
                Response response = request.createResponse(content);
                this.process(response);
            }
        } else {
            this.logger.info((Object)("forward request to processor:" + processor.getThreadName()));
            processor.onRequest(request);
        }
    }

    public void onRequest(SubmitResponse response) {
        this.logger.debug((Object)"receive submit response");
        BusinessProcess processor = this.getTheBestProcessor();
        processor.onRequest(response);
    }

    public void onRequest(DeliverReport response) {
        this.logger.debug((Object)"receive deliver report");
        BusinessProcess processor = this.getTheBestProcessor();
        processor.onRequest(response);
    }

    public boolean isRegister(ServiceMessage request) {
        return this.rule.isFilter(request);
    }

    private BusinessProcess getTheBestProcessor() {
        int size = Integer.MAX_VALUE;
        BusinessProcess processor = null;
        for (BusinessProcess p : this.processors) {
            if (p.queueSize() >= size) continue;
            size = p.queueSize();
            processor = p;
        }
        return processor;
    }
}

