/*
 * Decompiled with CFR 0.152.
 */
package transport.tcp.message;

import java.util.Date;
import transport.message.Request;
import transport.message.Response;
import transport.tcp.AdvanceByteBuffer;
import transport.tcp.message.AbServiceMessage;
import transport.tcp.message.ServiceResponse;
import vasp.Command;
import vasp.utils.VaspUtils;

public class ServiceRequest
extends AbServiceMessage
implements Request {
    protected Command command;
    protected String content;
    protected int status;
    protected long time;
    private static int msgId;

    public ServiceRequest() {
    }

    public ServiceRequest(String provider, String gateway, String sessionId, String serviceId, String sender, String receiver, String content) {
        super(4, 449);
        this.type = (byte)4;
        this.provider = provider;
        this.gateway = gateway;
        this.sessionId = sessionId;
        this.serviceId = serviceId;
        this.sender = sender;
        this.receiver = receiver;
        this.content = content != null ? content : "";
        this.status = 0;
        this.time = System.currentTimeMillis();
        this.command = VaspUtils.getCommand(content, 2);
        this.put("Name", "ServiceRequest");
        this.put("SessionId", sessionId);
        this.put("ServiceId", serviceId);
        this.put("Sender", sender);
        this.put("Receiver", receiver);
        this.put("Content", content);
        this.put("Error", this.status);
        this.put("MoTime", this.time);
    }

    public ServiceRequest(byte[] b) throws Exception {
        super(4, 449);
        AdvanceByteBuffer buf = new AdvanceByteBuffer(b);
        this.content = buf.popCString(320);
        this.receiver = buf.popCString(14);
        this.sender = buf.popCString(14);
        this.serviceId = buf.popCString(30);
        this.sessionId = buf.popCString(10);
        this.gateway = buf.popCString(30);
        this.provider = buf.popCString(30);
        this.type = buf.popByte();
        this.time = System.currentTimeMillis();
        this.command = VaspUtils.getCommand(this.content, 2);
        this.put("Name", "ServiceRequest");
        this.put("SessionId", this.sessionId);
        this.put("ServiceId", this.serviceId);
        this.put("Sender", this.sender);
        this.put("Receiver", this.receiver);
        this.put("Content", this.content);
        this.put("Error", this.status);
        this.put("MoTime", this.time);
    }

    @Override
    public byte[] toBytes() throws Exception {
        AdvanceByteBuffer buf = new AdvanceByteBuffer();
        buf.appendByte(this.type);
        buf.appendCString(this.provider, 30);
        buf.appendCString(this.gateway, 30);
        buf.appendCString(this.sessionId, 10);
        buf.appendCString(this.serviceId, 30);
        buf.appendCString(this.sender, 14);
        buf.appendCString(this.receiver, 14);
        buf.appendCString(this.content, 320);
        return buf.array();
    }

    public Command getCommand() {
        return this.command;
    }

    public void setCommand(Command command) {
        this.command = command;
    }

    @Override
    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(int status) {
        this.status = status;
    }

    @Override
    public String debugString() {
        String debug = "";
        if ((this.status & 0x10) == 16) {
            debug = "(Retry) ";
        }
        return debug + "ServiceRequest " + this.sender + "->" + this.receiver + " (SessionId=" + this.sessionId + ",ServiceId=" + this.serviceId + ",VaspId=" + this.getVaspId() + ",Msg=" + this.content + ",Error=" + this.status + ",Time=" + VaspUtils.getFullTimeDesp(new Date(this.time)) + ")";
    }

    @Override
    public Response createFault(String content) {
        byte[] data = content != null ? content.getBytes() : new byte[]{};
        return new ServiceResponse(this.provider, this.gateway, ServiceRequest.getMsgId(), this.sessionId, this.serviceId, this.receiver, this.sender, 0, data.length, data, 1);
    }

    @Override
    public Response createResponse(String content) {
        byte[] data = content != null ? content.getBytes() : new byte[]{};
        return new ServiceResponse(this.provider, this.gateway, ServiceRequest.getMsgId(), this.sessionId, this.serviceId, this.receiver, this.sender, 0, data.length, data, 0);
    }

    @Override
    public Response createResponse(byte[] content) {
        if (content == null) {
            content = new byte[]{};
        }
        return new ServiceResponse(this.provider, this.gateway, ServiceRequest.getMsgId(), this.sessionId, this.serviceId, this.receiver, this.sender, 1, content.length, content, 0);
    }

    @Override
    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    private static String getMsgId() {
        if (++msgId == Integer.MAX_VALUE) {
            msgId = 1;
        }
        return "" + msgId;
    }
}

