/*
 * Decompiled with CFR 0.152.
 */
package transport.soap;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.Vector;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import net.homeip.donaldm.httpdbase4j.FileHttpd;
import net.homeip.donaldm.httpdbase4j.Postable;
import transport.AuthenticatedServerTransport;
import transport.Listener;
import transport.Transport;
import transport.message.Message;
import transport.message.ServiceMessage;
import transport.soap.WsHandler;
import utils.Config;
import utils.ProcessorMX;
import utils.Queue;
import vasp.CommandRequest;
import vasp.CommandResponse;
import vasp.Commandable;
import vasp.GwAuthenticator;
import vasp.utils.CommandUtils;
import vasp.utils.ConfigLoader;

public class SoapTransportImpl
extends ProcessorMX
implements AuthenticatedServerTransport,
Listener,
Commandable {
    protected Vector<Transport> transports;
    protected Vector<WsHandler> handlers = new Vector();
    protected String sysId = "HttpServer";
    protected Vector<FileHttpd> https;
    protected String DIR = "../data";
    protected int[] port;

    public SoapTransportImpl() {
        super("HttpServer");
        this.transports = new Vector();
        this.https = new Vector();
        this.DIR = Config.getCurrentDir() + File.separator + "data";
        try {
            this.registerAgent("smsws.vasp:type=HttpServer");
        }
        catch (MalformedObjectNameException ex) {
            this.logger.error((Object)"register service agent error");
            this.logger.error((Object)("exception:" + ex.toString()));
        }
        catch (InstanceAlreadyExistsException ex) {
            this.logger.error((Object)"register service agent error");
            this.logger.error((Object)("exception:" + ex.toString()));
        }
        catch (MBeanRegistrationException ex) {
            this.logger.error((Object)"register service agent error");
            this.logger.error((Object)("exception:" + ex.toString()));
        }
        catch (NotCompliantMBeanException ex) {
            this.logger.error((Object)"register service agent error");
            this.logger.error((Object)("exception:" + ex.toString()));
        }
        this.reload();
    }

    @Override
    public void setAuthen(GwAuthenticator authen) {
        for (WsHandler module : this.handlers) {
            module.setAuthen(authen);
        }
    }

    public void addWsHandler(WsHandler handle) {
        if (handle.getName() == null) {
            this.logger.warn((Object)"add a handle with null name");
            return;
        }
        for (WsHandler h : this.handlers) {
            if (!((Object)((Object)h)).equals((Object)handle)) continue;
            this.logger.warn((Object)("ws handle " + handle.getName() + " is exist"));
            return;
        }
        this.handlers.add(handle);
        for (FileHttpd http : this.https) {
            http.addPostHandler(handle.getName(), (Postable)handle);
        }
    }

    public void removeWsHandler(WsHandler handle) {
        for (WsHandler h : this.handlers) {
            if (!((Object)((Object)h)).equals((Object)handle)) continue;
            this.logger.warn((Object)("remove wshandle " + handle.getName()));
            this.handlers.remove((Object)h);
            for (FileHttpd http : this.https) {
                http.removePostHandler(handle.getName());
            }
            return;
        }
    }

    public void addTransport(Transport transport) {
        for (Transport h : this.transports) {
            if (!h.getSysId().equals(transport.getSysId())) continue;
            this.logger.warn((Object)("transport " + transport.getSysId() + " is exist"));
            return;
        }
        this.transports.add(transport);
    }

    public void removeTransport(Transport transport) {
        for (Transport t : this.transports) {
            if (!t.getSysId().equals(transport.getSysId())) continue;
            this.logger.warn((Object)("remove wshandle " + transport.getSysId()));
            this.transports.remove(t);
            return;
        }
    }

    @Override
    public void setReceiverQueue(Queue rx) {
        Iterator<WsHandler> i$ = this.handlers.iterator();
        while (i$.hasNext()) {
            WsHandler module;
            WsHandler wsHandler = module = i$.next();
            wsHandler.setReceiverQueue(rx);
        }
    }

    @Override
    public void setSysId(String sysId) {
        this.sysId = sysId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reload() {
        InputStreamReader f = null;
        BufferedReader r = null;
        try {
            String configFile = Config.getConfigDir() + File.separator + "http-listener.conf";
            this.logger.info((Object)("http listener load config from:" + configFile));
            f = new FileReader(configFile);
            r = new BufferedReader(f);
            String s = r.readLine();
            Vector<Integer> v = new Vector<Integer>();
            while (s != null) {
                int p;
                if (s.startsWith("port") && (p = ConfigLoader.getValue(s, 0)) != 0) {
                    v.add(p);
                }
                s = r.readLine();
            }
            this.port = new int[v.size()];
            for (int i = 0; i < v.size(); ++i) {
                this.port[i] = (Integer)v.elementAt(i);
            }
            r.close();
            f.close();
        }
        catch (IOException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            this.port = new int[]{80};
        }
        finally {
            if (f != null) {
                try {
                    f.close();
                }
                catch (IOException ex) {
                    this.logger.error((Object)("fail to close stream:" + ex));
                }
            }
            if (r != null) {
                try {
                    r.close();
                }
                catch (IOException ex) {
                    this.logger.error((Object)("fail to close stream:" + ex));
                }
            }
        }
        FileHttpd[] httpds = this.https.toArray(new FileHttpd[this.https.size()]);
        Vector<FileHttpd> removed = new Vector<FileHttpd>();
        removed.addAll(this.https);
        this.https.clear();
        for (int i = 0; i < this.port.length; ++i) {
            FileHttpd httpd = this.findModule(this.port[i], httpds);
            if (httpd != null) {
                this.https.add(httpd);
                removed.remove(httpd);
                continue;
            }
            httpd = new FileHttpd(new File(this.DIR), 10);
            for (WsHandler handler : this.handlers) {
                httpd.addPostHandler(handler.getName(), (Postable)httpd);
            }
            this.https.add(httpd);
        }
        for (FileHttpd httpd : removed) {
            this.logger.info((Object)("stopping http[" + httpd.getPort() + "] ..."));
            this.logger.info((Object)("result=" + httpd.stop(10)));
        }
    }

    private FileHttpd findModule(int port, FileHttpd[] https) {
        if (https == null) {
            return null;
        }
        for (FileHttpd http : https) {
            if (http.getPort() != port) continue;
            return http;
        }
        return null;
    }

    @Override
    public boolean isRegister(ServiceMessage response) {
        for (Transport transport : this.transports) {
            if (!transport.isRegister(response)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isRequestFrom(ServiceMessage response) {
        for (Transport module : this.transports) {
            if (!module.isRequestFrom(response)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isRegisted() {
        return true;
    }

    @Override
    public String getSysId() {
        return this.sysId;
    }

    @Override
    public String getIdString() {
        return this.sysId;
    }

    @Override
    public int enTx(Message message) {
        if (!(message instanceof ServiceMessage)) {
            this.logger.info((Object)"message type is not support, transport is dropt message now");
            return 0;
        }
        ServiceMessage response = (ServiceMessage)message;
        String gatewayId = response.getGateway();
        if (gatewayId != null) {
            for (Transport transport : this.transports) {
                if (!transport.isRequestFrom(response)) continue;
                return transport.enTx(response);
            }
        }
        this.logger.info((Object)"anonymous source module, routing by config file");
        for (Transport transport : this.transports) {
            if (!transport.isRegister(response)) continue;
            return transport.enTx(response);
        }
        this.logger.warn((Object)"transport can't route this message object");
        return 0;
    }

    @Override
    public void start() {
        this.logger.info((Object)"starting all soap transports");
        for (Transport transport : this.transports) {
            transport.start();
        }
        try {
            for (int i = 0; i < this.https.size(); ++i) {
                if (this.https.get(i).isStarted()) continue;
                this.logger.info((Object)("starting http in port " + this.port[i]));
                this.https.get(i).start(this.port[i], "/");
                this.logger.info((Object)"http is stated");
            }
        }
        catch (NoSuchFieldException ex) {
            this.logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        catch (IOException ex) {
            this.logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        this.logger.info((Object)"all soap transports are started");
    }

    @Override
    public void stop() {
        this.logger.info((Object)"stopping all soap transports");
        for (Transport transport : this.transports) {
            transport.stop();
        }
        for (FileHttpd http : this.https) {
            http.stop(10);
        }
        this.logger.info((Object)"all soap transports are stopped");
    }

    @Override
    public void restart() {
        this.logger.info((Object)"restart all soap transports");
        for (Transport transport : this.transports) {
            transport.restart();
        }
        for (FileHttpd http : this.https) {
            http.stop(10);
        }
        try {
            for (int i = 0; i < this.https.size(); ++i) {
                this.logger.info((Object)("starting http in port " + this.port[i]));
                this.https.get(i).start(this.port[i], "/");
                this.logger.info((Object)"http is stated");
            }
        }
        catch (NoSuchFieldException ex) {
            this.logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        catch (IOException ex) {
            this.logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public void destroy() {
        for (Transport transport : this.transports) {
            transport.destroy();
        }
        this.stop();
        try {
            this.unregisterAgent("smsws.vasp:type=HttpServer");
        }
        catch (MalformedObjectNameException ex) {
            this.logger.info((Object)("unregister agent error:" + ex.toString()));
            this.logger.error((Object)("exception:" + ex.toString()));
        }
        catch (InstanceNotFoundException ex) {
            this.logger.info((Object)("unregister agent error:" + ex.toString()));
            this.logger.error((Object)("exception:" + ex.toString()));
        }
        catch (MBeanRegistrationException ex) {
            this.logger.info((Object)("unregister agent error:" + ex.toString()));
            this.logger.error((Object)("exception:" + ex.toString()));
        }
    }

    @Override
    public CommandResponse exec(CommandRequest cmd) {
        String id = cmd.getIndentify();
        String[] args = cmd.getArgs();
        if (id.startsWith("show") && args.length == 2 && "vasp".equals(args[0]) && args[1] != null) {
            StringBuffer buff = new StringBuffer();
            for (Transport transport : this.transports) {
                Commandable exec;
                CommandResponse cmdResponse;
                if (!(transport instanceof Commandable) || (cmdResponse = (exec = (Commandable)((Object)transport)).exec(cmd)) == null) continue;
                buff.append(cmdResponse.getDescription());
            }
            if (buff.length() > 0) {
                return cmd.createResponse(buff.toString());
            }
        }
        return null;
    }

    @Override
    public String getInfor() {
        StringBuffer buf = new StringBuffer();
        buf.append("SysId=HttpServer");
        if (this.port != null) {
            buf.append("\r\nPort={");
            for (int i = 0; i < this.port.length; ++i) {
                if (i > 0) {
                    buf.append(",");
                }
                buf.append(this.port[i]);
            }
            buf.append("}");
        }
        if (this.transports.size() > 0) {
            buf.append("\r\n-------------------------------------");
            for (Transport transport : this.transports) {
                buf.append("\r\n");
                buf.append(transport.getInfor());
            }
        }
        if (this.handlers.size() > 0) {
            buf.append("\r\n-------------------------------------");
            for (WsHandler wsHandler : this.handlers) {
                buf.append("\r\n");
                buf.append(wsHandler.getInfor());
            }
        }
        return buf.toString();
    }

    @Override
    public String listTransports() {
        StringBuffer buf = new StringBuffer("\r\n----------------Http-----------------\r\n");
        buf.append(CommandUtils.format("idx", 1, 6));
        buf.append(CommandUtils.format("id", 1, 12));
        buf.append(CommandUtils.format("sysid", 1, 12));
        buf.append(CommandUtils.format("bounded", 1, 8));
        if (this.transports == null || this.transports.size() == 0) {
            buf.append("\r\nno connected vasp");
        } else {
            for (int i = 0; i < this.transports.size(); ++i) {
                buf.append("\r\n");
                buf.append(CommandUtils.format("" + (i + 1), 1, 6));
                buf.append(CommandUtils.format(this.transports.get(i).getIdString(), 1, 12));
                buf.append(CommandUtils.format(this.transports.get(i).getSysId(), 1, 12));
                buf.append(CommandUtils.format("" + this.transports.get(i).isRegisted(), 1, 8));
            }
        }
        return buf.toString();
    }

    public Vector<WsHandler> getHandlers() {
        return this.handlers;
    }

    public Vector<FileHttpd> getHttps() {
        return this.https;
    }

    public int[] getPort() {
        if (this.port == null) {
            return new int[0];
        }
        int[] p = new int[this.port.length];
        System.arraycopy(this.port, 0, p, 0, this.port.length);
        return p;
    }

    public Vector<Transport> getTransports() {
        return this.transports;
    }
}

