/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.mmserver.database;

import com.viettel.mmserver.base.Log;
import com.viettel.mmserver.database.ConnectionException;
import com.viettel.mmserver.database.DatabaseConnection;
import com.viettel.mmserver.scheduler.DailyTask;
import com.viettel.mmserver.scheduler.MonthlyTask;
import com.viettel.mmserver.scheduler.OnceTask;
import com.viettel.mmserver.scheduler.RepeatedTask;
import com.viettel.mmserver.scheduler.Scheduler;
import com.viettel.mmserver.scheduler.Task;
import com.viettel.mmserver.scheduler.WeeklyTask;
import com.viettel.mmserver.warnning.ErrorCondition;
import com.viettel.mmserver.warnning.ErrorDefinition;
import com.viettel.mmserver.warnning.TimeoutInfo;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseAccessor {
    private Connection connection;
    private boolean sqlException;
    private Logger log = Logger.getLogger((String)"Tools:mmserver");
    private PreparedStatement insertSchedulingLogPS = null;
    private PreparedStatement selectErrorDefinitionPS = null;
    private PreparedStatement insertErrorDefinitionPS = null;
    private PreparedStatement setErrorDefinitionUseFlagPS = null;
    private PreparedStatement deleteErrorDefinitionPS = null;
    private PreparedStatement selectApplicationTelephone = null;
    private PreparedStatement insertApplicationTelephone = null;
    private PreparedStatement updateApplicationTelephonePS = null;
    private PreparedStatement deleteApplicationReceiverPS = null;
    private PreparedStatement errorIdSeqPS = null;
    private PreparedStatement requestSendSMS = null;
    private PreparedStatement selectThreadTimeoutPS = null;
    private PreparedStatement deleteThreadTimeoutPS = null;
    private PreparedStatement editThreadTimeoutPS = null;
    private PreparedStatement insertThreadTimeoutPS = null;
    private PreparedStatement selectMaxAttemptPS = null;
    private static String selectErrorDefinitionSQL = "";
    private static String insertErrorDefinitionSQL = "";
    private static String setErrorDefinitionUseFlagSQL = "";
    private static String deleteErrorDefinitionSQL = "";
    private static String selectAppTelephoneSQL = "";
    private static String insertAppTelephoneSQL = "";
    private static String updateAppTelephone = "";
    private static String deleteAppTelephone = "";
    private static String selectErrorIDSeqSQL = "";
    private static String selectSMSIdSeqSQL = "";
    private static String insertMMSMSSQL = "";
    private static String requestSendSMSSQL = "";
    private static String selectThreadTimeoutSQL = "";
    private static String deleteThreadTimeoutSQL = "";
    private static String editThreadTimeoutSQL = "";
    private static String insertThreadTimeoutSQL = "";
    private String schema = "";
    private static DatabaseAccessor shareInstance = null;

    private DatabaseAccessor() {
        try {
            this.schema = DatabaseConnection.shareInstance().getSchema();
            selectErrorDefinitionSQL = "SELECT * FROM " + this.schema + ".ERROR_DEFINITION " + "where applicationID = ? AND useFlag = ?";
            insertErrorDefinitionSQL = "INSERT INTO " + this.schema + ".ERROR_DEFINITION(errorId,applicationId,userName,createTime, useFlag,loglevel," + "loggerName,message,threadName,smsFormat,smsContent,sendSMS,error_frequence)  " + " VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
            setErrorDefinitionUseFlagSQL = "UPDATE " + this.schema + ".ERROR_DEFINITION SET useFlag=? where errorId=?";
            deleteErrorDefinitionSQL = "DELETE FROM " + this.schema + ".ERROR_DEFINITION where errorId = ?";
            selectAppTelephoneSQL = "SELECT * FROM " + this.schema + ".APPLICATION_TELEPHONE where application = ?";
            insertAppTelephoneSQL = "INSERT INTO " + this.schema + ".APPLICATION_TELEPHONE(application,phone_number_list) VALUES(?,?)";
            updateAppTelephone = "UPDATE " + this.schema + ".APPLICATION_TELEPHONE set phone_number_list = ? where application = ?";
            deleteAppTelephone = "DELETE " + this.schema + ".APP_RECEIVER WHERE APPLICATION_ID = ?";
            selectErrorIDSeqSQL = "SELECT " + this.schema + ".errorDefId_seq.nextVal from dual";
            selectSMSIdSeqSQL = "SELECT " + this.schema + ".smsId_seq.nextVal from dual";
            insertMMSMSSQL = "INSERT INTO " + this.schema + ".WAIT";
            requestSendSMSSQL = "INSERT INTO " + this.schema + ".wait_msg(msg_id,msg_content,application_id,remain_retry, arrived_time)" + "  VALUES(" + this.schema + ".WAIT_MSG_SEQ.nextval, ?,?,?,sysdate) ";
            selectThreadTimeoutSQL = "SELECT APPLICATION_ID, MBEANNAME, TIMEOUT, SENDSMS FROM " + this.schema + ".THREAD_TIMEOUT where APPLICATION_ID = ?";
            deleteThreadTimeoutSQL = "DELETE FROM " + this.schema + ".THREAD_TIMEOUT WHERE APPLICATION_ID = ? AND MBEANNAME=? ";
            editThreadTimeoutSQL = "UPDATE " + this.schema + ".THREAD_TIMEOUT SET TIMEOUT=?, SENDSMS=? WHERE APPLICATION_ID = ? AND MBEANNAME=? ";
            insertThreadTimeoutSQL = "INSERT INTO " + this.schema + ".THREAD_TIMEOUT(APPLICATION_ID, MBEANNAME,TIMEOUT, SENDSMS) VALUES(?,?,?,?) ";
            this.connection = DatabaseConnection.shareInstance().getConnection();
            this.insertSchedulingLogPS = this.connection.prepareStatement("INSERT INTO " + this.schema + ".Scheduling VALUES(?,?,to_date(?,'yyyy/mm/dd/hh24/mi/ss'),?,?,?)");
            this.selectErrorDefinitionPS = this.connection.prepareStatement(selectErrorDefinitionSQL);
            this.insertErrorDefinitionPS = this.connection.prepareStatement(insertErrorDefinitionSQL);
            this.setErrorDefinitionUseFlagPS = this.connection.prepareStatement(setErrorDefinitionUseFlagSQL);
            this.deleteErrorDefinitionPS = this.connection.prepareStatement(deleteErrorDefinitionSQL);
            this.selectApplicationTelephone = this.connection.prepareStatement(selectAppTelephoneSQL);
            this.insertApplicationTelephone = this.connection.prepareStatement(insertAppTelephoneSQL);
            this.updateApplicationTelephonePS = this.connection.prepareStatement(updateAppTelephone);
            this.errorIdSeqPS = this.connection.prepareStatement(selectErrorIDSeqSQL);
            this.requestSendSMS = this.connection.prepareStatement(requestSendSMSSQL);
            this.selectMaxAttemptPS = this.connection.prepareStatement("SELECT avg(max_attemp) FROM " + this.schema + ".application WHERE application_id=?");
            this.deleteApplicationReceiverPS = this.connection.prepareStatement(deleteAppTelephone);
            this.selectThreadTimeoutPS = this.connection.prepareStatement(selectThreadTimeoutSQL);
            this.deleteThreadTimeoutPS = this.connection.prepareStatement(deleteThreadTimeoutSQL);
            this.editThreadTimeoutPS = this.connection.prepareStatement(editThreadTimeoutSQL);
            this.insertThreadTimeoutPS = this.connection.prepareStatement(insertThreadTimeoutSQL);
            this.connection.setAutoCommit(true);
        }
        catch (Exception ex) {
            this.log.error((Object)selectErrorDefinitionSQL);
            this.sqlException = true;
            this.log.error((Object)ex.toString());
        }
    }

    public static synchronized DatabaseAccessor shareInstance() {
        if (shareInstance == null) {
            shareInstance = new DatabaseAccessor();
        }
        return shareInstance;
    }

    private void updateConnection() {
        try {
            this.connection = DatabaseConnection.shareInstance().updateConnection();
            this.insertSchedulingLogPS = this.connection.prepareStatement("INSERT INTO " + this.schema + ".Scheduling VALUES(?,?,to_date(?,'yyyy/mm/dd/hh24/mi/ss'),?,?,?)");
            this.selectErrorDefinitionPS = this.connection.prepareStatement(selectErrorDefinitionSQL);
            this.insertErrorDefinitionPS = this.connection.prepareStatement(insertErrorDefinitionSQL);
            this.setErrorDefinitionUseFlagPS = this.connection.prepareStatement(setErrorDefinitionUseFlagSQL);
            this.deleteErrorDefinitionPS = this.connection.prepareStatement(deleteErrorDefinitionSQL);
            this.selectApplicationTelephone = this.connection.prepareStatement(selectAppTelephoneSQL);
            this.insertApplicationTelephone = this.connection.prepareStatement(insertAppTelephoneSQL);
            this.updateApplicationTelephonePS = this.connection.prepareStatement(updateAppTelephone);
            this.errorIdSeqPS = this.connection.prepareStatement(selectErrorIDSeqSQL);
            this.requestSendSMS = this.connection.prepareStatement(requestSendSMSSQL);
            this.selectMaxAttemptPS = this.connection.prepareStatement("SELECT avg(max_attemp) FROM " + this.schema + ".application WHERE application_id=?");
            this.deleteApplicationReceiverPS = this.connection.prepareStatement(deleteAppTelephone);
            this.selectThreadTimeoutPS = this.connection.prepareStatement(selectThreadTimeoutSQL);
            this.deleteThreadTimeoutPS = this.connection.prepareStatement(deleteThreadTimeoutSQL);
            this.editThreadTimeoutPS = this.connection.prepareStatement(editThreadTimeoutSQL);
            this.insertThreadTimeoutPS = this.connection.prepareStatement(insertThreadTimeoutSQL);
            this.sqlException = false;
            this.connection.setAutoCommit(true);
        }
        catch (Exception ex) {
            Log.warn(ex);
        }
    }

    private int iRemoveTask(int taskId) throws ConnectionException {
        if (this.sqlException) {
            this.updateConnection();
        }
        Statement ps = null;
        ResultSet rs = null;
        try {
            ps = this.connection.prepareStatement("SELECT taskType, repeatedTaskID FROM " + this.schema + ".task WHERE taskId = ?");
            ps.setInt(1, taskId);
            rs = ps.executeQuery();
            rs.next();
            String taskType = rs.getString("taskType");
            int repeatedTaskId = rs.getInt("repeatedTaskId");
            if (taskType.equalsIgnoreCase("Once")) {
                ps = this.connection.prepareStatement("DELETE FROM " + this.schema + ".task WHERE taskId = ?");
                ps.setInt(1, taskId);
                if (ps.executeUpdate() < 0) {
                    int n = 0;
                    return n;
                }
            } else {
                String tableName = this.schema + "." + taskType + "Task";
                ps = this.connection.prepareStatement("DELETE FROM " + tableName + " WHERE taskId = ?");
                ps.setInt(1, taskId);
                if (ps.executeUpdate() < 0) {
                    int e = 0;
                    return e;
                }
                ps = this.connection.prepareStatement("DELETE FROM " + this.schema + ".task WHERE taskId = ?");
                ps.setInt(1, taskId);
                if (ps.executeUpdate() < 0) {
                    int e = 0;
                    return e;
                }
            }
            if (repeatedTaskId != 0) {
                ps = this.connection.prepareStatement("DELETE FROM " + this.schema + ".repeatedTask WHERE repeatedTaskId = ?");
                ps.setInt(1, repeatedTaskId);
                if (ps.executeUpdate() < 0) {
                    int tableName = 0;
                    return tableName;
                }
            }
            int tableName = 1;
            return tableName;
        }
        catch (SQLException ex) {
            this.log.error((Object)("SQL exception:" + ex));
            if (DatabaseConnection.shareInstance().checkConnection()) {
                int n = -1;
                return n;
            }
            this.sqlException = true;
            throw new ConnectionException(ex.getMessage(), "");
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception e) {
                this.log.debug((Object)e);
            }
        }
    }

    public int removeTask(int taskId) {
        try {
            return this.iRemoveTask(taskId);
        }
        catch (ConnectionException ce) {
            this.log.error((Object)ce.getMessage());
            try {
                return this.iRemoveTask(taskId);
            }
            catch (ConnectionException e) {
                this.log.error((Object)e.getMessage());
                return -1;
            }
        }
    }

    public int iaddOnceTask(String strAppId, String strObjectName, String strMethodName, java.util.Date startTime, java.util.Date startDate, int intStatus, String strUserName) throws ConnectionException {
        if (this.sqlException) {
            this.updateConnection();
        }
        int taskId = -1;
        PreparedStatement taskIdPS = null;
        ResultSet taskIdRS = null;
        Statement ps = null;
        Statement ps2 = null;
        ResultSet rs2 = null;
        try {
            taskIdPS = this.connection.prepareStatement("SELECT " + this.schema + ".taskid_seq.nextVal from dual");
            taskIdRS = taskIdPS.executeQuery();
            taskIdRS.next();
            taskId = taskIdRS.getInt(1);
            ps = this.connection.prepareStatement("INSERT INTO " + this.schema + ".task(taskid, taskType, appId, objectName, methodName, startTime, startDate, status, userName)" + " VALUES (?, 'ONCE', ?, ?, ?, to_date(?,'yyyy/mm/dd/hh24/mi/ss'), " + "to_date(?,'yyyy/mm/dd/hh24/mi/ss'), ?, ?)");
            ps.setInt(1, taskId);
            ps.setString(2, strAppId);
            ps.setString(3, strObjectName);
            ps.setString(4, strMethodName);
            ps.setString(5, new SimpleDateFormat("yyyy/MM/dd/HH/mm/ss").format(startTime));
            ps.setString(6, new SimpleDateFormat("yyyy/MM/dd/HH/mm/ss").format(startDate));
            ps.setString(7, "" + intStatus);
            ps.setString(8, strUserName);
            if (ps.executeUpdate() < 0) {
                int n = 0;
                return n;
            }
            int n = taskId;
            return n;
        }
        catch (SQLException ex) {
            this.log.error((Object)("SQL exception:" + ex));
            if (DatabaseConnection.shareInstance().checkConnection()) {
                int n = -1;
                return n;
            }
            this.sqlException = true;
            throw new ConnectionException(ex.getMessage(), "");
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (rs2 != null) {
                    rs2.close();
                }
                if (ps2 != null) {
                    ps2.close();
                }
            }
            catch (Exception e) {
                this.log.debug((Object)("close ps " + e.getMessage()));
            }
        }
    }

    public int addOnceTask(String strAppId, String strObjectName, String strMethodName, java.util.Date startTime, java.util.Date startDate, int intStatus, String strUserName) {
        try {
            return this.iaddOnceTask(strAppId, strObjectName, strMethodName, startTime, startDate, intStatus, strUserName);
        }
        catch (ConnectionException ce) {
            this.log.error((Object)ce.getMessage());
            try {
                return this.iaddOnceTask(strAppId, strObjectName, strMethodName, startTime, startDate, intStatus, strUserName);
            }
            catch (ConnectionException e) {
                this.log.error((Object)ce.getMessage());
                return -1;
            }
        }
    }

    public int iaddNonRepeatedDailyTask(String strAppId, String strObjectName, String strMethodName, java.util.Date startTime, java.util.Date startDate, java.util.Date endDate, int intStatus, String strUserName, int intRecurrenceTime) throws ConnectionException {
        if (this.sqlException) {
            this.updateConnection();
        }
        int taskId = -1;
        PreparedStatement taskIdPS = null;
        ResultSet taskIdRS = null;
        Statement ps = null;
        try {
            taskIdPS = this.connection.prepareStatement("SELECT " + this.schema + ".taskid_seq.nextVal from dual");
            taskIdRS = taskIdPS.executeQuery();
            taskIdRS.next();
            taskId = taskIdRS.getInt(1);
            ps = this.connection.prepareStatement("INSERT INTO " + this.schema + ".task(taskid, taskType, appId, objectName, methodName," + " startTime, startDate, endDate, status, userName)" + " VALUES (?, 'DAILY', ?, ?, ?, to_date(?,'yyyy/mm/dd/hh24/mi/ss'), " + "to_date(?,'yyyy/mm/dd/hh24/mi/ss'), to_date(?,'yyyy/mm/dd/hh24/mi/ss'), ?, ?)");
            ps.setInt(1, taskId);
            ps.setString(2, strAppId);
            ps.setString(3, strObjectName);
            ps.setString(4, strMethodName);
            ps.setString(5, new SimpleDateFormat("yyyy/MM/dd/HH/mm/ss").format(startTime));
            ps.setString(6, new SimpleDateFormat("yyyy/MM/dd/HH/mm/ss").format(startDate));
            ps.setString(7, new SimpleDateFormat("yyyy/MM/dd/HH/mm/ss").format(endDate));
            ps.setString(8, "" + intStatus);
            ps.setString(9, strUserName);
            if (ps.executeUpdate() < 0) {
                int n = 0;
                return n;
            }
            ps.close();
            ps = this.connection.prepareStatement("INSERT INTO " + this.schema + ".DailyTask(Taskid, RECURRENCETIME) VALUES(?, ?)");
            ps.setInt(1, taskId);
            ps.setInt(2, intRecurrenceTime);
            if (ps.executeUpdate() < 0) {
                int n = 0;
                return n;
            }
            int n = taskId;
            return n;
        }
        catch (SQLException ex) {
            this.log.error((Object)("SQL exception:" + ex));
            if (DatabaseConnection.shareInstance().checkConnection()) {
                int n = -1;
                return n;
            }
            this.sqlException = true;
            throw new ConnectionException(ex.getMessage(), "");
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception e) {
                this.log.debug((Object)("close ps " + e.getMessage()));
            }
        }
    }

    public int addNonRepeatedDailyTask(String strAppId, String strObjectName, String strMethodName, java.util.Date startTime, java.util.Date startDate, java.util.Date endDate, int intStatus, String strUserName, int intRecurrenceTime) {
        try {
            return this.iaddNonRepeatedDailyTask(strAppId, strObjectName, strMethodName, startTime, startDate, endDate, intStatus, strUserName, intRecurrenceTime);
        }
        catch (ConnectionException ce) {
            this.log.error((Object)ce.getMessage());
            try {
                return this.iaddNonRepeatedDailyTask(strAppId, strObjectName, strMethodName, startTime, startDate, endDate, intStatus, strUserName, intRecurrenceTime);
            }
            catch (ConnectionException e) {
                this.log.error((Object)e.getMessage());
                return -1;
            }
        }
    }

    /*
     * Loose catch block
     */
    public int iaddRepeatedDailyTask(String strAppId, String strObjectName, String strMethodName, java.util.Date startTime, java.util.Date startDate, java.util.Date endDate, int intStatus, String strUserName, int intRecurrenceTime, int intRepeatedRecurrenceTime, int intRepeatedTime) throws ConnectionException {
        Statement ps;
        ResultSet taskIdRS;
        Statement taskIdPS;
        ResultSet repeatedTaskIdRS;
        Statement repeatedTaskIdPS;
        int taskId;
        block50: {
            block48: {
                int repeatedTaskId;
                block46: {
                    if (this.sqlException) {
                        this.updateConnection();
                    }
                    taskId = -1;
                    repeatedTaskId = -1;
                    repeatedTaskIdPS = null;
                    repeatedTaskIdRS = null;
                    taskIdPS = null;
                    taskIdRS = null;
                    ps = null;
                    taskIdPS = this.connection.prepareStatement("SELECT " + this.schema + ".taskid_seq.nextVal from dual");
                    taskIdRS = taskIdPS.executeQuery();
                    taskIdRS.next();
                    taskId = taskIdRS.getInt(1);
                    repeatedTaskIdPS = this.connection.prepareStatement("SELECT " + this.schema + ".repeatedTaskid_seq.nextVal from dual");
                    repeatedTaskIdRS = repeatedTaskIdPS.executeQuery();
                    repeatedTaskIdRS.next();
                    repeatedTaskId = repeatedTaskIdRS.getInt(1);
                    ps = this.connection.prepareStatement("INSERT INTO " + this.schema + ".RepeatedTask(REPEATEDTASKID,REPEATEDRECURRENCETIME,REPEATEDTIMES) VALUES(?, ?, ?)");
                    ps.setInt(1, repeatedTaskId);
                    ps.setInt(2, intRepeatedRecurrenceTime);
                    ps.setInt(3, intRepeatedTime);
                    if (ps.executeUpdate() >= 0) break block46;
                    int n = 0;
                    Object var22_24 = null;
                    try {
                        if (ps != null) {
                            ps.close();
                        }
                        if (taskIdRS != null) {
                            taskIdRS.close();
                        }
                        if (taskIdPS != null) {
                            taskIdPS.close();
                        }
                        if (repeatedTaskIdRS != null) {
                            repeatedTaskIdRS.close();
                        }
                        if (repeatedTaskIdPS != null) {
                            repeatedTaskIdPS.close();
                        }
                    }
                    catch (Exception e) {
                        this.log.debug((Object)("close ps " + e.getMessage()));
                    }
                    return n;
                }
                ps = this.connection.prepareStatement("INSERT INTO " + this.schema + ".task(taskid, taskType, appId, objectName, methodName, startTime, " + "startDate, endDate, status, userName, repeatedTaskId)" + " VALUES (?, 'DAILY', ?, ?, ?, to_date(?,'yyyy/mm/dd/hh24/mi/ss')," + " to_date(?,'yyyy/mm/dd/hh24/mi/ss'), to_date(?,'yyyy/mm/dd/hh24/mi/ss'), ?, ?, ?)");
                ps.setInt(1, taskId);
                ps.setString(2, strAppId);
                ps.setString(3, strObjectName);
                ps.setString(4, strMethodName);
                ps.setString(5, new SimpleDateFormat("yyyy/MM/dd/HH/mm/ss").format(startTime));
                ps.setString(6, new SimpleDateFormat("yyyy/MM/dd/HH/mm/ss").format(startDate));
                ps.setString(7, new SimpleDateFormat("yyyy/MM/dd/HH/mm/ss").format(endDate));
                ps.setString(8, "" + intStatus);
                ps.setString(9, strUserName);
                ps.setInt(10, repeatedTaskId);
                if (ps.executeUpdate() >= 0) break block48;
                int n = 0;
                Object var22_25 = null;
                try {
                    if (ps != null) {
                        ps.close();
                    }
                    if (taskIdRS != null) {
                        taskIdRS.close();
                    }
                    if (taskIdPS != null) {
                        taskIdPS.close();
                    }
                    if (repeatedTaskIdRS != null) {
                        repeatedTaskIdRS.close();
                    }
                    if (repeatedTaskIdPS != null) {
                        repeatedTaskIdPS.close();
                    }
                }
                catch (Exception e) {
                    this.log.debug((Object)("close ps " + e.getMessage()));
                }
                return n;
            }
            ps.close();
            ps = this.connection.prepareStatement("INSERT INTO " + this.schema + ".DailyTask(Taskid, RECURRENCETIME) VALUES(?, ?)");
            ps.setInt(1, taskId);
            ps.setInt(2, intRecurrenceTime);
            if (ps.executeUpdate() >= 0) break block50;
            int n = 0;
            Object var22_26 = null;
            try {
                if (ps != null) {
                    ps.close();
                }
                if (taskIdRS != null) {
                    taskIdRS.close();
                }
                if (taskIdPS != null) {
                    taskIdPS.close();
                }
                if (repeatedTaskIdRS != null) {
                    repeatedTaskIdRS.close();
                }
                if (repeatedTaskIdPS != null) {
                    repeatedTaskIdPS.close();
                }
            }
            catch (Exception e) {
                this.log.debug((Object)("close ps " + e.getMessage()));
            }
            return n;
        }
        int n = taskId;
        Object var22_27 = null;
        try {
            if (ps != null) {
                ps.close();
            }
            if (taskIdRS != null) {
                taskIdRS.close();
            }
            if (taskIdPS != null) {
                taskIdPS.close();
            }
            if (repeatedTaskIdRS != null) {
                repeatedTaskIdRS.close();
            }
            if (repeatedTaskIdPS != null) {
                repeatedTaskIdPS.close();
            }
        }
        catch (Exception e) {
            this.log.debug((Object)("close ps " + e.getMessage()));
        }
        return n;
        catch (SQLException ex) {
            block53: {
                int n2;
                try {
                    this.log.error((Object)("SQL exception:" + ex));
                    if (!DatabaseConnection.shareInstance().checkConnection()) break block53;
                    n2 = -1;
                    Object var22_28 = null;
                }
                catch (Throwable throwable) {
                    Object var22_29 = null;
                    try {
                        if (ps != null) {
                            ps.close();
                        }
                        if (taskIdRS != null) {
                            taskIdRS.close();
                        }
                        if (taskIdPS != null) {
                            taskIdPS.close();
                        }
                        if (repeatedTaskIdRS != null) {
                            repeatedTaskIdRS.close();
                        }
                        if (repeatedTaskIdPS != null) {
                            repeatedTaskIdPS.close();
                        }
                    }
                    catch (Exception e) {
                        this.log.debug((Object)("close ps " + e.getMessage()));
                    }
                    throw throwable;
                }
                try {
                    if (ps != null) {
                        ps.close();
                    }
                    if (taskIdRS != null) {
                        taskIdRS.close();
                    }
                    if (taskIdPS != null) {
                        taskIdPS.close();
                    }
                    if (repeatedTaskIdRS != null) {
                        repeatedTaskIdRS.close();
                    }
                    if (repeatedTaskIdPS != null) {
                        repeatedTaskIdPS.close();
                    }
                }
                catch (Exception e) {
                    this.log.debug((Object)("close ps " + e.getMessage()));
                }
                return n2;
            }
            this.sqlException = true;
            throw new ConnectionException(ex.getMessage(), "");
        }
    }

    public int addRepeatedDailyTask(String strAppId, String strObjectName, String strMethodName, java.util.Date startTime, java.util.Date startDate, java.util.Date endDate, int intStatus, String strUserName, int intRecurrenceTime, int intRepeatedRecurrenceTime, int intRepeatedTime) {
        try {
            return this.iaddRepeatedDailyTask(strAppId, strObjectName, strMethodName, startTime, startDate, endDate, intStatus, strUserName, intRecurrenceTime, intRepeatedRecurrenceTime, intRepeatedTime);
        }
        catch (ConnectionException ce) {
            this.log.error((Object)ce.getMessage());
            try {
                return this.iaddRepeatedDailyTask(strAppId, strObjectName, strMethodName, startTime, startDate, endDate, intStatus, strUserName, intRecurrenceTime, intRepeatedRecurrenceTime, intRepeatedTime);
            }
            catch (ConnectionException e) {
                this.log.error((Object)ce.getMessage());
                return -1;
            }
        }
    }

    /*
     * Loose catch block
     */
    public int iaddNonRepeatedWeeklyTask(String strAppId, String strObjectName, String strMethodName, java.util.Date startTime, java.util.Date startDate, java.util.Date endDate, int intStatus, String strUserName, int intRecurrenceTime, String strDays) throws ConnectionException {
        Statement ps;
        int taskId;
        block21: {
            block19: {
                if (this.sqlException) {
                    this.updateConnection();
                }
                taskId = -1;
                PreparedStatement taskIdPS = null;
                ResultSet taskIdRS = null;
                ps = null;
                taskIdPS = this.connection.prepareStatement("SELECT " + this.schema + ".taskid_seq.nextVal from dual");
                taskIdRS = taskIdPS.executeQuery();
                taskIdRS.next();
                taskId = taskIdRS.getInt(1);
                ps = this.connection.prepareStatement("INSERT INTO " + this.schema + ".task(taskid, taskType, appId, objectName, methodName, startTime," + " startDate, endDate, status, userName)" + " VALUES (?, 'WEEKLY', ?, ?, ?, to_date(?,'yyyy/mm/dd/hh24/mi/ss'), " + "to_date(?,'yyyy/mm/dd/hh24/mi/ss'), to_date(?,'yyyy/mm/dd/hh24/mi/ss'), ?, ?)");
                ps.setInt(1, taskId);
                ps.setString(2, strAppId);
                ps.setString(3, strObjectName);
                ps.setString(4, strMethodName);
                ps.setString(5, new SimpleDateFormat("yyyy/MM/dd/HH/mm/ss").format(startTime));
                ps.setString(6, new SimpleDateFormat("yyyy/MM/dd/HH/mm/ss").format(startDate));
                ps.setString(7, new SimpleDateFormat("yyyy/MM/dd/HH/mm/ss").format(endDate));
                ps.setString(8, "" + intStatus);
                ps.setString(9, strUserName);
                if (ps.executeUpdate() >= 0) break block19;
                int n = 0;
                Object var18_19 = null;
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (Exception e) {
                    this.log.debug((Object)("close ps " + e.getMessage()));
                }
                return n;
            }
            ps.close();
            ps = this.connection.prepareStatement("INSERT INTO " + this.schema + ".WeeklyTask(Taskid, RECURRENCETIME, DAYS) VALUES(?, ?, ?)");
            ps.setInt(1, taskId);
            ps.setInt(2, intRecurrenceTime);
            ps.setString(3, strDays);
            if (ps.executeUpdate() >= 0) break block21;
            int n = 0;
            Object var18_20 = null;
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception e) {
                this.log.debug((Object)("close ps " + e.getMessage()));
            }
            return n;
        }
        int n = taskId;
        Object var18_21 = null;
        try {
            if (ps != null) {
                ps.close();
            }
        }
        catch (Exception e) {
            this.log.debug((Object)("close ps " + e.getMessage()));
        }
        return n;
        catch (SQLException ex) {
            block24: {
                int n2;
                try {
                    this.log.error((Object)("SQL exception:" + ex));
                    if (!DatabaseConnection.shareInstance().checkConnection()) break block24;
                    n2 = -1;
                    Object var18_22 = null;
                }
                catch (Throwable throwable) {
                    Object var18_23 = null;
                    try {
                        if (ps != null) {
                            ps.close();
                        }
                    }
                    catch (Exception e) {
                        this.log.debug((Object)("close ps " + e.getMessage()));
                    }
                    throw throwable;
                }
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (Exception e) {
                    this.log.debug((Object)("close ps " + e.getMessage()));
                }
                return n2;
            }
            this.sqlException = true;
            throw new ConnectionException(ex.getMessage(), "");
        }
    }

    public int addNonRepeatedWeeklyTask(String strAppId, String strObjectName, String strMethodName, java.util.Date startTime, java.util.Date startDate, java.util.Date endDate, int intStatus, String strUserName, int intRecurrenceTime, String strDays) {
        try {
            return this.iaddNonRepeatedWeeklyTask(strAppId, strObjectName, strMethodName, startTime, startDate, endDate, intStatus, strUserName, intRecurrenceTime, strDays);
        }
        catch (ConnectionException ce) {
            this.log.error((Object)ce.getMessage());
            try {
                return this.iaddNonRepeatedWeeklyTask(strAppId, strObjectName, strMethodName, startTime, startDate, endDate, intStatus, strUserName, intRecurrenceTime, strDays);
            }
            catch (ConnectionException e) {
                this.log.error((Object)e.getMessage());
                return -1;
            }
        }
    }

    /*
     * Loose catch block
     */
    private int iaddRepeatedWeeklyTask(String strAppId, String strObjectName, String strMethodName, java.util.Date startTime, java.util.Date startDate, java.util.Date endDate, int intStatus, String strUserName, int intRecurrenceTime, String strDays, int intRepeatedRecurrenceTime, int intRepeatedTime) throws ConnectionException {
        Statement ps;
        ResultSet taskIdRS;
        Statement taskIdPS;
        ResultSet repeatedTaskIdRS;
        Statement repeatedTaskIdPS;
        int taskId;
        block50: {
            block48: {
                int repeatedTaskId;
                block46: {
                    if (this.sqlException) {
                        this.updateConnection();
                    }
                    taskId = -1;
                    repeatedTaskId = -1;
                    repeatedTaskIdPS = null;
                    repeatedTaskIdRS = null;
                    taskIdPS = null;
                    taskIdRS = null;
                    ps = null;
                    taskIdPS = this.connection.prepareStatement("SELECT " + this.schema + ".taskid_seq.nextVal from dual");
                    taskIdRS = taskIdPS.executeQuery();
                    taskIdRS.next();
                    taskId = taskIdRS.getInt(1);
                    repeatedTaskIdPS = this.connection.prepareStatement("SELECT " + this.schema + ".repeatedTaskid_seq.nextVal from dual");
                    repeatedTaskIdRS = repeatedTaskIdPS.executeQuery();
                    repeatedTaskIdRS.next();
                    repeatedTaskId = repeatedTaskIdRS.getInt(1);
                    ps = this.connection.prepareStatement("INSERT INTO " + this.schema + ".RepeatedTask(REPEATEDTASKID,RepeatedRECURRENCETIME,REPEATEDTIMES) VALUES(?, ?, ?)");
                    ps.setInt(1, repeatedTaskId);
                    ps.setInt(2, intRepeatedRecurrenceTime);
                    ps.setInt(3, intRepeatedTime);
                    if (ps.executeUpdate() >= 0) break block46;
                    int n = 0;
                    Object var23_25 = null;
                    try {
                        if (ps != null) {
                            ps.close();
                        }
                        if (taskIdRS != null) {
                            taskIdRS.close();
                        }
                        if (taskIdPS != null) {
                            taskIdPS.close();
                        }
                        if (repeatedTaskIdRS != null) {
                            repeatedTaskIdRS.close();
                        }
                        if (repeatedTaskIdPS != null) {
                            repeatedTaskIdPS.close();
                        }
                    }
                    catch (Exception e) {
                        this.log.debug((Object)("close ps " + e.getMessage()));
                    }
                    return n;
                }
                ps = this.connection.prepareStatement("INSERT INTO " + this.schema + ".task(taskid, taskType, appId, objectName, methodName, startTime, startDate, endDate," + " status, userName, repeatedTaskID)" + " VALUES (?, 'WEEKLY', ?, ?, ?, to_date(?,'yyyy/mm/dd/hh24/mi/ss')," + " to_date(?,'yyyy/mm/dd/hh24/mi/ss'), to_date(?,'yyyy/mm/dd/hh24/mi/ss'), ?, ?, ?)");
                ps.setInt(1, taskId);
                ps.setString(2, strAppId);
                ps.setString(3, strObjectName);
                ps.setString(4, strMethodName);
                ps.setString(5, new SimpleDateFormat("yyyy/MM/dd/HH/mm/ss").format(startTime));
                ps.setString(6, new SimpleDateFormat("yyyy/MM/dd/HH/mm/ss").format(startDate));
                ps.setString(7, new SimpleDateFormat("yyyy/MM/dd/HH/mm/ss").format(endDate));
                ps.setString(8, "" + intStatus);
                ps.setString(9, strUserName);
                ps.setInt(10, repeatedTaskId);
                if (ps.executeUpdate() >= 0) break block48;
                int n = 0;
                Object var23_26 = null;
                try {
                    if (ps != null) {
                        ps.close();
                    }
                    if (taskIdRS != null) {
                        taskIdRS.close();
                    }
                    if (taskIdPS != null) {
                        taskIdPS.close();
                    }
                    if (repeatedTaskIdRS != null) {
                        repeatedTaskIdRS.close();
                    }
                    if (repeatedTaskIdPS != null) {
                        repeatedTaskIdPS.close();
                    }
                }
                catch (Exception e) {
                    this.log.debug((Object)("close ps " + e.getMessage()));
                }
                return n;
            }
            ps.close();
            ps = this.connection.prepareStatement("INSERT INTO " + this.schema + ".WeeklyTask(Taskid, RECURRENCETIME, DAYS) VALUES(?, ?, ?)");
            ps.setInt(1, taskId);
            ps.setInt(2, intRecurrenceTime);
            ps.setString(3, strDays);
            if (ps.executeUpdate() >= 0) break block50;
            int n = 0;
            Object var23_27 = null;
            try {
                if (ps != null) {
                    ps.close();
                }
                if (taskIdRS != null) {
                    taskIdRS.close();
                }
                if (taskIdPS != null) {
                    taskIdPS.close();
                }
                if (repeatedTaskIdRS != null) {
                    repeatedTaskIdRS.close();
                }
                if (repeatedTaskIdPS != null) {
                    repeatedTaskIdPS.close();
                }
            }
            catch (Exception e) {
                this.log.debug((Object)("close ps " + e.getMessage()));
            }
            return n;
        }
        int n = taskId;
        Object var23_28 = null;
        try {
            if (ps != null) {
                ps.close();
            }
            if (taskIdRS != null) {
                taskIdRS.close();
            }
            if (taskIdPS != null) {
                taskIdPS.close();
            }
            if (repeatedTaskIdRS != null) {
                repeatedTaskIdRS.close();
            }
            if (repeatedTaskIdPS != null) {
                repeatedTaskIdPS.close();
            }
        }
        catch (Exception e) {
            this.log.debug((Object)("close ps " + e.getMessage()));
        }
        return n;
        catch (SQLException ex) {
            block53: {
                int n2;
                try {
                    this.log.error((Object)("SQL exception:" + ex));
                    if (!DatabaseConnection.shareInstance().checkConnection()) break block53;
                    n2 = -1;
                    Object var23_29 = null;
                }
                catch (Throwable throwable) {
                    Object var23_30 = null;
                    try {
                        if (ps != null) {
                            ps.close();
                        }
                        if (taskIdRS != null) {
                            taskIdRS.close();
                        }
                        if (taskIdPS != null) {
                            taskIdPS.close();
                        }
                        if (repeatedTaskIdRS != null) {
                            repeatedTaskIdRS.close();
                        }
                        if (repeatedTaskIdPS != null) {
                            repeatedTaskIdPS.close();
                        }
                    }
                    catch (Exception e) {
                        this.log.debug((Object)("close ps " + e.getMessage()));
                    }
                    throw throwable;
                }
                try {
                    if (ps != null) {
                        ps.close();
                    }
                    if (taskIdRS != null) {
                        taskIdRS.close();
                    }
                    if (taskIdPS != null) {
                        taskIdPS.close();
                    }
                    if (repeatedTaskIdRS != null) {
                        repeatedTaskIdRS.close();
                    }
                    if (repeatedTaskIdPS != null) {
                        repeatedTaskIdPS.close();
                    }
                }
                catch (Exception e) {
                    this.log.debug((Object)("close ps " + e.getMessage()));
                }
                return n2;
            }
            this.sqlException = true;
            throw new ConnectionException(ex.getMessage(), "");
        }
    }

    public int addRepeatedWeeklyTask(String strAppId, String strObjectName, String strMethodName, java.util.Date startTime, java.util.Date startDate, java.util.Date endDate, int intStatus, String strUserName, int intRecurrenceTime, String strDays, int intRepeatedRecurrenceTime, int intRepeatedTime) {
        try {
            return this.iaddRepeatedWeeklyTask(strAppId, strObjectName, strMethodName, startTime, startDate, endDate, intStatus, strUserName, intRecurrenceTime, strDays, intRepeatedRecurrenceTime, intRepeatedTime);
        }
        catch (ConnectionException ce) {
            this.log.error((Object)ce.getMessage());
            try {
                return this.iaddRepeatedWeeklyTask(strAppId, strObjectName, strMethodName, startTime, startDate, endDate, intStatus, strUserName, intRecurrenceTime, strDays, intRepeatedRecurrenceTime, intRepeatedTime);
            }
            catch (ConnectionException e) {
                this.log.error((Object)e.getMessage());
                return -1;
            }
        }
    }

    /*
     * Loose catch block
     */
    public int iaddNonRepeatedMonthlyTask(String strAppId, String strObjectName, String strMethodName, java.util.Date startTime, java.util.Date startDate, java.util.Date endDate, int intStatus, String strUserName, String strTaskMode, String strDays, String strMonths) throws ConnectionException {
        Statement ps;
        int taskId;
        block21: {
            block19: {
                if (this.sqlException) {
                    this.updateConnection();
                }
                taskId = -1;
                PreparedStatement taskIdPS = null;
                ResultSet taskIdRS = null;
                ps = null;
                taskIdPS = this.connection.prepareStatement("SELECT " + this.schema + ".taskid_seq.nextVal from dual");
                taskIdRS = taskIdPS.executeQuery();
                taskIdRS.next();
                taskId = taskIdRS.getInt(1);
                ps = this.connection.prepareStatement("INSERT INTO " + this.schema + ".task(taskid, taskType, appId, objectName, methodName, " + "startTime, startDate, endDate, status, userName)" + " VALUES (?, 'MONTHLY', ?, ?, ?, to_date(?,'yyyy/mm/dd/hh24/mi/ss')," + " to_date(?,'yyyy/mm/dd/hh24/mi/ss'), to_date(?,'yyyy/mm/dd/hh24/mi/ss'), ?, ?)");
                ps.setInt(1, taskId);
                ps.setString(2, strAppId);
                ps.setString(3, strObjectName);
                ps.setString(4, strMethodName);
                ps.setString(5, new SimpleDateFormat("yyyy/MM/dd/HH/mm/ss").format(startTime));
                ps.setString(6, new SimpleDateFormat("yyyy/MM/dd/HH/mm/ss").format(startDate));
                ps.setString(7, new SimpleDateFormat("yyyy/MM/dd/HH/mm/ss").format(endDate));
                ps.setString(8, "" + intStatus);
                ps.setString(9, strUserName);
                if (ps.executeUpdate() >= 0) break block19;
                int n = 0;
                Object var19_20 = null;
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (Exception e) {
                    this.log.debug((Object)("close ps " + e.getMessage()));
                }
                return n;
            }
            ps.close();
            ps = this.connection.prepareStatement("INSERT INTO " + this.schema + ".MonthlyTask(Taskid,  TASKMODE, DAYS, MONTHS) VALUES(?, ?, ?, ?)");
            ps.setInt(1, taskId);
            ps.setString(2, strTaskMode);
            ps.setString(3, strDays);
            ps.setString(4, strMonths);
            if (ps.executeUpdate() >= 0) break block21;
            int n = 0;
            Object var19_21 = null;
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception e) {
                this.log.debug((Object)("close ps " + e.getMessage()));
            }
            return n;
        }
        int n = taskId;
        Object var19_22 = null;
        try {
            if (ps != null) {
                ps.close();
            }
        }
        catch (Exception e) {
            this.log.debug((Object)("close ps " + e.getMessage()));
        }
        return n;
        catch (SQLException ex) {
            block24: {
                int n2;
                try {
                    this.log.error((Object)("SQL exception:" + ex));
                    if (!DatabaseConnection.shareInstance().checkConnection()) break block24;
                    n2 = -1;
                    Object var19_23 = null;
                }
                catch (Throwable throwable) {
                    Object var19_24 = null;
                    try {
                        if (ps != null) {
                            ps.close();
                        }
                    }
                    catch (Exception e) {
                        this.log.debug((Object)("close ps " + e.getMessage()));
                    }
                    throw throwable;
                }
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (Exception e) {
                    this.log.debug((Object)("close ps " + e.getMessage()));
                }
                return n2;
            }
            this.sqlException = true;
            throw new ConnectionException(ex.getMessage(), "");
        }
    }

    public int addNonRepeatedMonthlyTask(String strAppId, String strObjectName, String strMethodName, java.util.Date startTime, java.util.Date startDate, java.util.Date endDate, int intStatus, String strUserName, String strTaskMode, String strDays, String strMonths) {
        try {
            return this.iaddNonRepeatedMonthlyTask(strAppId, strObjectName, strMethodName, startTime, startDate, endDate, intStatus, strUserName, strTaskMode, strDays, strMonths);
        }
        catch (ConnectionException ce) {
            this.log.error((Object)ce.getMessage());
            try {
                return this.iaddNonRepeatedMonthlyTask(strAppId, strObjectName, strMethodName, startTime, startDate, endDate, intStatus, strUserName, strTaskMode, strDays, strMonths);
            }
            catch (ConnectionException e) {
                this.log.error((Object)e.getMessage());
                return -1;
            }
        }
    }

    /*
     * Loose catch block
     */
    private int iaddRepeatedMonthlyTask(String strAppId, String strObjectName, String strMethodName, java.util.Date startTime, java.util.Date startDate, java.util.Date endDate, int intStatus, String strUserName, String strTaskMode, String strDays, String strMonths, int intRepeatedRecurrenceTime, int intRepeatedTime) throws ConnectionException {
        Statement ps;
        ResultSet taskIdRS;
        Statement taskIdPS;
        ResultSet repeatedTaskIdRS;
        Statement repeatedTaskIdPS;
        int taskId;
        block50: {
            block48: {
                int repeatedTaskId;
                block46: {
                    if (this.sqlException) {
                        this.updateConnection();
                    }
                    taskId = -1;
                    repeatedTaskId = -1;
                    repeatedTaskIdPS = null;
                    repeatedTaskIdRS = null;
                    taskIdPS = null;
                    taskIdRS = null;
                    ps = null;
                    taskIdPS = this.connection.prepareStatement("SELECT " + this.schema + ".taskid_seq.nextVal from dual");
                    taskIdRS = taskIdPS.executeQuery();
                    taskIdRS.next();
                    taskId = taskIdRS.getInt(1);
                    repeatedTaskIdPS = this.connection.prepareStatement("SELECT " + this.schema + ".repeatedTaskid_seq.nextVal from dual");
                    repeatedTaskIdRS = repeatedTaskIdPS.executeQuery();
                    repeatedTaskIdRS.next();
                    repeatedTaskId = repeatedTaskIdRS.getInt(1);
                    ps = this.connection.prepareStatement("INSERT INTO " + this.schema + ".RepeatedTask(REPEATEDTASKID,RepeatedRECURRENCETIME,REPEATEDTIMES) VALUES(?, ?, ?)");
                    ps.setInt(1, repeatedTaskId);
                    ps.setInt(2, intRepeatedRecurrenceTime);
                    ps.setInt(3, intRepeatedTime);
                    if (ps.executeUpdate() >= 0) break block46;
                    int n = 0;
                    Object var24_26 = null;
                    try {
                        if (ps != null) {
                            ps.close();
                        }
                        if (taskIdRS != null) {
                            taskIdRS.close();
                        }
                        if (taskIdPS != null) {
                            taskIdPS.close();
                        }
                        if (repeatedTaskIdRS != null) {
                            repeatedTaskIdRS.close();
                        }
                        if (repeatedTaskIdPS != null) {
                            repeatedTaskIdPS.close();
                        }
                    }
                    catch (Exception e) {
                        this.log.debug((Object)("close ps " + e.getMessage()));
                    }
                    return n;
                }
                ps = this.connection.prepareStatement("INSERT INTO " + this.schema + ".task(taskid, taskType, appId, objectName, methodName, startTime, startDate, endDate," + " status, userName, repeatedTaskId)" + " VALUES (?, 'MONTHLY', ?, ?, ?, to_date(?,'yyyy/mm/dd/hh24/mi/ss')," + " to_date(?,'yyyy/mm/dd/hh24/mi/ss'), to_date(?,'yyyy/mm/dd/hh24/mi/ss'), ?, ?, ?)");
                ps.setInt(1, taskId);
                ps.setString(2, strAppId);
                ps.setString(3, strObjectName);
                ps.setString(4, strMethodName);
                ps.setString(5, new SimpleDateFormat("yyyy/MM/dd/HH/mm/ss").format(startTime));
                ps.setString(6, new SimpleDateFormat("yyyy/MM/dd/HH/mm/ss").format(startDate));
                ps.setString(7, new SimpleDateFormat("yyyy/MM/dd/HH/mm/ss").format(endDate));
                ps.setString(8, "" + intStatus);
                ps.setString(9, strUserName);
                ps.setInt(10, repeatedTaskId);
                if (ps.executeUpdate() >= 0) break block48;
                int n = 0;
                Object var24_27 = null;
                try {
                    if (ps != null) {
                        ps.close();
                    }
                    if (taskIdRS != null) {
                        taskIdRS.close();
                    }
                    if (taskIdPS != null) {
                        taskIdPS.close();
                    }
                    if (repeatedTaskIdRS != null) {
                        repeatedTaskIdRS.close();
                    }
                    if (repeatedTaskIdPS != null) {
                        repeatedTaskIdPS.close();
                    }
                }
                catch (Exception e) {
                    this.log.debug((Object)("close ps " + e.getMessage()));
                }
                return n;
            }
            ps.close();
            ps = this.connection.prepareStatement("INSERT INTO " + this.schema + ".MonthlyTask(Taskid, TASKMODE, DAYS, MONTHS) VALUES(?,  ?, ?, ?)");
            ps.setInt(1, taskId);
            ps.setString(2, strTaskMode);
            ps.setString(3, strDays);
            ps.setString(4, strMonths);
            if (ps.executeUpdate() >= 0) break block50;
            int n = 0;
            Object var24_28 = null;
            try {
                if (ps != null) {
                    ps.close();
                }
                if (taskIdRS != null) {
                    taskIdRS.close();
                }
                if (taskIdPS != null) {
                    taskIdPS.close();
                }
                if (repeatedTaskIdRS != null) {
                    repeatedTaskIdRS.close();
                }
                if (repeatedTaskIdPS != null) {
                    repeatedTaskIdPS.close();
                }
            }
            catch (Exception e) {
                this.log.debug((Object)("close ps " + e.getMessage()));
            }
            return n;
        }
        int n = taskId;
        Object var24_29 = null;
        try {
            if (ps != null) {
                ps.close();
            }
            if (taskIdRS != null) {
                taskIdRS.close();
            }
            if (taskIdPS != null) {
                taskIdPS.close();
            }
            if (repeatedTaskIdRS != null) {
                repeatedTaskIdRS.close();
            }
            if (repeatedTaskIdPS != null) {
                repeatedTaskIdPS.close();
            }
        }
        catch (Exception e) {
            this.log.debug((Object)("close ps " + e.getMessage()));
        }
        return n;
        catch (SQLException ex) {
            block53: {
                int n2;
                try {
                    this.log.error((Object)("SQL exception:" + ex));
                    if (!DatabaseConnection.shareInstance().checkConnection()) break block53;
                    n2 = -1;
                    Object var24_30 = null;
                }
                catch (Throwable throwable) {
                    Object var24_31 = null;
                    try {
                        if (ps != null) {
                            ps.close();
                        }
                        if (taskIdRS != null) {
                            taskIdRS.close();
                        }
                        if (taskIdPS != null) {
                            taskIdPS.close();
                        }
                        if (repeatedTaskIdRS != null) {
                            repeatedTaskIdRS.close();
                        }
                        if (repeatedTaskIdPS != null) {
                            repeatedTaskIdPS.close();
                        }
                    }
                    catch (Exception e) {
                        this.log.debug((Object)("close ps " + e.getMessage()));
                    }
                    throw throwable;
                }
                try {
                    if (ps != null) {
                        ps.close();
                    }
                    if (taskIdRS != null) {
                        taskIdRS.close();
                    }
                    if (taskIdPS != null) {
                        taskIdPS.close();
                    }
                    if (repeatedTaskIdRS != null) {
                        repeatedTaskIdRS.close();
                    }
                    if (repeatedTaskIdPS != null) {
                        repeatedTaskIdPS.close();
                    }
                }
                catch (Exception e) {
                    this.log.debug((Object)("close ps " + e.getMessage()));
                }
                return n2;
            }
            this.sqlException = true;
            throw new ConnectionException(ex.getMessage(), "");
        }
    }

    public int addRepeatedMonthlyTask(String strAppId, String strObjectName, String strMethodName, java.util.Date startTime, java.util.Date startDate, java.util.Date endDate, int intStatus, String strUserName, String strTaskMode, String strDays, String strMonths, int intRepeatedRecurrenceTime, int intRepeatedTime) {
        try {
            return this.iaddRepeatedMonthlyTask(strAppId, strObjectName, strMethodName, startTime, startDate, endDate, intStatus, strUserName, strTaskMode, strDays, strMonths, intRepeatedRecurrenceTime, intRepeatedTime);
        }
        catch (ConnectionException ce) {
            this.log.error((Object)ce.getMessage());
            try {
                return this.iaddRepeatedMonthlyTask(strAppId, strObjectName, strMethodName, startTime, startDate, endDate, intStatus, strUserName, strTaskMode, strDays, strMonths, intRepeatedRecurrenceTime, intRepeatedTime);
            }
            catch (ConnectionException e) {
                this.log.error((Object)e.getMessage());
                return -1;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private int ieditTask(int taskId, String strObjectName, String strMethodName, String strTaskType, java.util.Date startTime, java.util.Date startDate, java.util.Date endDate, int intStatus, String strUserName, int intRecurrenceTime, String strTaskMode, String strDayList, String strMonthList, boolean hasRepeatedTask, int repeatedTaskId, int repeatedRecurrenceTime, int repeatedTimes) throws ConnectionException {
        block77: {
            block75: {
                block73: {
                    block71: {
                        block83: {
                            block69: {
                                block67: {
                                    block65: {
                                        if (this.sqlException) {
                                            this.updateConnection();
                                        }
                                        ps = null;
                                        ps2 = null;
                                        ps3 = null;
                                        oldTaskType = "";
                                        oldRepeatedTaskId = 0;
                                        ps = this.connection.prepareStatement("select TASKTYPE, REPEATEDTASKID from " + this.schema + ".TASK where TASKID=?");
                                        ps.setInt(1, taskId);
                                        rs = ps.executeQuery();
                                        if (rs.next()) {
                                            oldTaskType = rs.getString(1);
                                            oldRepeatedTaskId = rs.getInt(2);
                                            rs.close();
                                            break block65;
                                        }
                                        var24_25 = 0;
                                        var30_32 = null;
                                        try {
                                            if (ps != null) {
                                                ps.close();
                                            }
                                            if (ps2 != null) {
                                                ps2.close();
                                            }
                                            if (ps3 != null) {
                                                ps3.close();
                                            }
                                        }
                                        catch (SQLException e) {
                                            Log.warn(e);
                                        }
                                        return var24_25;
                                    }
                                    ps = this.connection.prepareStatement("UPDATE " + this.schema + ".task " + "SET  objectName = ? , " + " methodName = ? , " + " taskType = ? , " + " startTime = to_date(?,'yyyy/mm/dd/hh24/mi/ss') , " + " startDate = to_date(?,'yyyy/mm/dd/hh24/mi/ss') , " + " endDate = to_date(?,'yyyy/mm/dd/hh24/mi/ss') , " + " status = ? , " + " userName = ?, " + " repeatedTaskId = ?" + " WHERE taskId = ?");
                                    ps.setString(1, strObjectName);
                                    ps.setString(2, strMethodName);
                                    ps.setString(3, strTaskType);
                                    ps.setString(4, new SimpleDateFormat("yyyy/MM/dd/HH/mm/ss").format(startTime));
                                    ps.setString(5, new SimpleDateFormat("yyyy/MM/dd/HH/mm/ss").format(startDate));
                                    ps.setString(6, new SimpleDateFormat("yyyy/MM/dd/HH/mm/ss").format(endDate));
                                    ps.setString(7, "" + intStatus);
                                    ps.setString(8, strUserName);
                                    ps.setInt(10, taskId);
                                    if (!hasRepeatedTask) ** GOTO lbl98
                                    if (oldRepeatedTaskId != 0) ** GOTO lbl92
                                    repeatedTaskIdPS = this.connection.prepareStatement("SELECT " + this.schema + ".repeatedTaskid_seq.nextVal from dual");
                                    repeatedTaskIdRS = repeatedTaskIdPS.executeQuery();
                                    if (repeatedTaskIdRS.next()) {
                                        newRepeatedTaskId = repeatedTaskIdRS.getInt(1);
                                        break block67;
                                    }
                                    var27_55 = 0;
                                    var30_33 = null;
                                    try {
                                        if (ps != null) {
                                            ps.close();
                                        }
                                        if (ps2 != null) {
                                            ps2.close();
                                        }
                                        if (ps3 != null) {
                                            ps3.close();
                                        }
                                    }
                                    catch (SQLException e) {
                                        Log.warn(e);
                                    }
                                    return var27_55;
                                }
                                insertRepeatedTaskPS = this.connection.prepareStatement("INSERT INTO " + this.schema + ".RepeatedTask(REPEATEDTASKID,RepeatedRECURRENCETIME,REPEATEDTIMES) VALUES(?, ?, ?)");
                                insertRepeatedTaskPS.setInt(1, newRepeatedTaskId);
                                insertRepeatedTaskPS.setInt(2, repeatedRecurrenceTime);
                                insertRepeatedTaskPS.setInt(3, repeatedTimes);
                                if (insertRepeatedTaskPS.executeUpdate() >= 0) break block69;
                                var28_57 = 0;
                                var30_34 = null;
                                try {
                                    if (ps != null) {
                                        ps.close();
                                    }
                                    if (ps2 != null) {
                                        ps2.close();
                                    }
                                    if (ps3 != null) {
                                        ps3.close();
                                    }
                                }
                                catch (SQLException e) {
                                    Log.warn(e);
                                }
                                return var28_57;
                            }
                            ps.setInt(9, newRepeatedTaskId);
                            break block83;
lbl92:
                            // 1 sources

                            ps2 = this.connection.prepareStatement("UPDATE " + this.schema + ".repeatedTask " + "SET repeatedRecurrenceTime = ? , " + " repeatedTimes = ? WHERE repeatedTaskId = ? ");
                            ps2.setInt(1, repeatedRecurrenceTime);
                            ps2.setInt(2, repeatedTimes);
                            ps2.setInt(3, oldRepeatedTaskId);
                            ps.setInt(9, oldRepeatedTaskId);
                            break block83;
lbl98:
                            // 1 sources

                            ps.setNull(9, 4);
                            if (oldRepeatedTaskId != 0) {
                                ps2 = this.connection.prepareStatement("DELETE FROM " + this.schema + ".repeatedTask WHERE repeatedTaskId = ? ");
                                ps2.setInt(1, oldRepeatedTaskId);
                            }
                        }
                        if (oldTaskType.equalsIgnoreCase(strTaskType)) {
                            if (strTaskType.equalsIgnoreCase("Daily")) {
                                ps3 = this.connection.prepareStatement("UPDATE " + this.schema + ".dailyTask SET recurrenceTime = ? WHERE taskId = ? ");
                                ps3.setInt(1, intRecurrenceTime);
                                ps3.setInt(2, taskId);
                            }
                            if (strTaskType.equalsIgnoreCase("Weekly")) {
                                ps3 = this.connection.prepareStatement("UPDATE " + this.schema + ".weeklyTask SET recurrenceTime = ? , days = ? WHERE taskId = ? ");
                                ps3.setInt(1, intRecurrenceTime);
                                ps3.setString(2, strDayList);
                                ps3.setInt(3, taskId);
                            }
                            if (strTaskType.equalsIgnoreCase("Monthly")) {
                                ps3 = this.connection.prepareStatement("UPDATE " + this.schema + ".monthlyTask SET taskMode = ? , days = ? , months = ? WHERE taskId = ? ");
                                ps3.setString(1, strTaskMode);
                                ps3.setString(2, strDayList);
                                ps3.setString(3, strMonthList);
                                ps3.setInt(4, taskId);
                            }
                            break block71;
                        }
                        if (!oldTaskType.equalsIgnoreCase("Once")) {
                            deletePS = this.connection.prepareStatement("delete FROM " + this.schema + "." + oldTaskType + "task where taskId = ?");
                            deletePS.setInt(1, taskId);
                            deletePS.executeUpdate();
                        }
                        insertPS = null;
                        if (strTaskType.equalsIgnoreCase("Daily")) {
                            insertPS = this.connection.prepareStatement("INSERT into " + this.schema + ".DAILYTASK(taskID,recurrenceTime) values(?,?)");
                            insertPS.setInt(1, taskId);
                            insertPS.setInt(2, intRecurrenceTime);
                        }
                        if (strTaskType.equalsIgnoreCase("Weekly")) {
                            insertPS = this.connection.prepareStatement("INSERT into " + this.schema + ".WEEKLYTASK(taskID,recurrenceTime,days) values(?,?,?) ");
                            insertPS.setInt(1, taskId);
                            insertPS.setInt(2, intRecurrenceTime);
                            insertPS.setString(3, strDayList);
                        }
                        if (strTaskType.equalsIgnoreCase("Monthly")) {
                            insertPS = this.connection.prepareStatement("INSERT into " + this.schema + ".MONTHLYTASK(taskID,taskMode, days, months) values(?,?,?,?)");
                            insertPS.setInt(1, taskId);
                            insertPS.setString(2, strTaskMode);
                            insertPS.setString(3, strDayList);
                            insertPS.setString(4, strMonthList);
                        }
                        if (insertPS == null || insertPS.executeUpdate() >= 0) break block71;
                        var25_53 = 0;
                        var30_35 = null;
                        try {
                            if (ps != null) {
                                ps.close();
                            }
                            if (ps2 != null) {
                                ps2.close();
                            }
                            if (ps3 != null) {
                                ps3.close();
                            }
                        }
                        catch (SQLException e) {
                            Log.warn(e);
                        }
                        return var25_53;
                    }
                    if (ps.executeUpdate() >= 0) break block73;
                    var24_27 = 0;
                    var30_36 = null;
                    try {
                        if (ps != null) {
                            ps.close();
                        }
                        if (ps2 != null) {
                            ps2.close();
                        }
                        if (ps3 != null) {
                            ps3.close();
                        }
                    }
                    catch (SQLException e) {
                        Log.warn(e);
                    }
                    return var24_27;
                }
                if (ps2 == null || ps2.executeUpdate() >= 0) break block75;
                var24_28 = 0;
                var30_37 = null;
                try {
                    if (ps != null) {
                        ps.close();
                    }
                    if (ps2 != null) {
                        ps2.close();
                    }
                    if (ps3 != null) {
                        ps3.close();
                    }
                }
                catch (SQLException e) {
                    Log.warn(e);
                }
                return var24_28;
            }
            if (ps3 == null || ps3.executeUpdate() >= 0) break block77;
            var24_29 = 0;
            var30_38 = null;
            try {
                if (ps != null) {
                    ps.close();
                }
                if (ps2 != null) {
                    ps2.close();
                }
                if (ps3 != null) {
                    ps3.close();
                }
            }
            catch (SQLException e) {
                Log.warn(e);
            }
            return var24_29;
        }
        var24_30 = taskId;
        var30_39 = null;
        try {
            if (ps != null) {
                ps.close();
            }
            if (ps2 != null) {
                ps2.close();
            }
            if (ps3 != null) {
                ps3.close();
            }
        }
        catch (SQLException e) {
            Log.warn(e);
        }
        return var24_30;
        catch (SQLException ex) {
            block80: {
                try {
                    this.log.error((Object)("SQL exception:" + ex));
                    if (!DatabaseConnection.shareInstance().checkConnection()) break block80;
                    var24_31 = -1;
                    var30_40 = null;
                }
                catch (Throwable var29_58) {
                    var30_41 = null;
                    try {
                        if (ps != null) {
                            ps.close();
                        }
                        if (ps2 != null) {
                            ps2.close();
                        }
                        if (ps3 != null) {
                            ps3.close();
                        }
                    }
                    catch (SQLException e) {
                        Log.warn(e);
                    }
                    throw var29_58;
                }
                try {
                    if (ps != null) {
                        ps.close();
                    }
                    if (ps2 != null) {
                        ps2.close();
                    }
                    if (ps3 != null) {
                        ps3.close();
                    }
                }
                catch (SQLException e) {
                    Log.warn(e);
                }
                return var24_31;
            }
            this.sqlException = true;
            throw new ConnectionException(ex.getMessage(), "");
        }
    }

    public int editTask(int taskId, String strObjectName, String strMethodName, String strTaskType, java.util.Date startTime, java.util.Date startDate, java.util.Date endDate, int intStatus, String strUserName, int intRecurrenceTime, String strTaskMode, String strDayList, String strMonthList, boolean hasRepeatedTask, int repeatedTaskId, int repeatedRecurrenceTime, int repeatedTimes) {
        try {
            return this.ieditTask(taskId, strObjectName, strMethodName, strTaskType, startTime, startDate, endDate, intStatus, strUserName, intRecurrenceTime, strTaskMode, strDayList, strMonthList, hasRepeatedTask, repeatedTaskId, repeatedRecurrenceTime, repeatedTimes);
        }
        catch (ConnectionException ce) {
            this.log.error((Object)ce.getMessage());
            try {
                return this.ieditTask(taskId, strObjectName, strMethodName, strTaskType, startTime, startDate, endDate, intStatus, strUserName, intRecurrenceTime, strTaskMode, strDayList, strMonthList, hasRepeatedTask, repeatedTaskId, repeatedRecurrenceTime, repeatedTimes);
            }
            catch (ConnectionException e) {
                this.log.error((Object)e.getMessage());
                return -1;
            }
        }
    }

    /*
     * Loose catch block
     */
    private int iinverseStatus(int taskId) throws ConnectionException {
        int status;
        ResultSet RS1;
        Statement PS2;
        Statement PS1;
        block26: {
            if (this.sqlException) {
                this.updateConnection();
            }
            PS1 = null;
            PS2 = null;
            RS1 = null;
            PS1 = this.connection.prepareStatement("select STATUS from " + this.schema + ".task where taskId = ? ");
            PS1.setInt(1, taskId);
            RS1 = PS1.executeQuery();
            RS1.next();
            status = Integer.valueOf(RS1.getString("STATUS"));
            if (status == 1) {
                PS2 = this.connection.prepareStatement("update " + this.schema + ".TASK set STATUS = 0 where taskId = ?");
                PS2.setInt(1, taskId);
                break block26;
            }
            if (status == 0) {
                PS2 = this.connection.prepareStatement("update " + this.schema + ".TASK set STATUS = 1 where taskId = ?");
                PS2.setInt(1, taskId);
                break block26;
            }
            int n = -1;
            Object var8_10 = null;
            try {
                if (RS1 != null) {
                    RS1.close();
                }
                if (PS1 != null) {
                    PS1.close();
                }
                if (PS2 != null) {
                    PS2.close();
                }
            }
            catch (SQLException e) {
                // empty catch block
            }
            return n;
        }
        PS2.executeUpdate();
        int n = status == 1 ? 0 : 1;
        Object var8_11 = null;
        try {
            if (RS1 != null) {
                RS1.close();
            }
            if (PS1 != null) {
                PS1.close();
            }
            if (PS2 != null) {
                PS2.close();
            }
        }
        catch (SQLException e) {
            // empty catch block
        }
        return n;
        catch (SQLException ex) {
            block29: {
                int n2;
                try {
                    this.log.error((Object)("SQL exception:" + ex));
                    if (!DatabaseConnection.shareInstance().checkConnection()) break block29;
                    n2 = -1;
                    Object var8_12 = null;
                }
                catch (Throwable throwable) {
                    Object var8_13 = null;
                    try {
                        if (RS1 != null) {
                            RS1.close();
                        }
                        if (PS1 != null) {
                            PS1.close();
                        }
                        if (PS2 != null) {
                            PS2.close();
                        }
                    }
                    catch (SQLException e) {}
                    throw throwable;
                }
                try {
                    if (RS1 != null) {
                        RS1.close();
                    }
                    if (PS1 != null) {
                        PS1.close();
                    }
                    if (PS2 != null) {
                        PS2.close();
                    }
                }
                catch (SQLException e) {
                    // empty catch block
                }
                return n2;
            }
            this.sqlException = true;
            throw new ConnectionException(ex.getMessage(), "");
        }
    }

    public int inverseStatus(int taskId) {
        try {
            return this.iinverseStatus(taskId);
        }
        catch (ConnectionException ce) {
            this.log.error((Object)ce.getMessage());
            try {
                return this.iinverseStatus(taskId);
            }
            catch (ConnectionException e) {
                this.log.error((Object)e.getMessage());
                return -1;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int isetStatus(int taskId, int status) throws ConnectionException {
        int n;
        if (this.sqlException) {
            this.updateConnection();
        }
        Statement PS = null;
        try {
            try {
                PS = this.connection.prepareStatement("update " + this.schema + ".TASK set STATUS = ? where taskId = ?");
                PS.setString(1, "" + status);
                PS.setInt(2, taskId);
                PS.executeUpdate();
                n = status;
                Object var7_6 = null;
            }
            catch (SQLException ex) {
                this.log.error((Object)("SQL exception:" + ex));
                if (!DatabaseConnection.shareInstance().checkConnection()) {
                    this.sqlException = true;
                    throw new ConnectionException(ex.getMessage(), "");
                }
                int n2 = -1;
                Object var7_7 = null;
                try {
                    if (PS == null) return n2;
                    PS.close();
                    return n2;
                }
                catch (SQLException e) {
                    Log.error(e);
                }
                return n2;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {}
            catch (SQLException e) {
                Log.error(e);
                throw throwable;
            }
            if (PS == null) throw throwable;
            PS.close();
            throw throwable;
        }
        try {}
        catch (SQLException e) {
            Log.error(e);
            return n;
        }
        if (PS == null) return n;
        PS.close();
        return n;
    }

    public int setStatus(int taskId, int status) {
        try {
            return this.isetStatus(taskId, status);
        }
        catch (ConnectionException ce) {
            this.log.error((Object)ce.getMessage());
            try {
                return this.isetStatus(taskId, status);
            }
            catch (ConnectionException e) {
                this.log.error((Object)e.getMessage());
                return -1;
            }
        }
    }

    /*
     * Loose catch block
     */
    private ArrayList<Task> iloadTaskList(String appId) throws ConnectionException {
        ArrayList<Task> taskList;
        block43: {
            int recurrenceTime;
            String userName;
            Date endDate;
            Date startDate;
            java.util.Date startTime;
            String strMethod;
            String strObjectName;
            int taskId;
            if (this.sqlException) {
                this.updateConnection();
            }
            Statement onceTaskPS = null;
            ResultSet onceTaskRS = null;
            Statement dailyTaskPS = null;
            ResultSet dailyTaskRS = null;
            Statement weeklyTaskPS = null;
            ResultSet weeklyTaskRS = null;
            Statement monthlyTaskPS = null;
            ResultSet monthlyTaskRS = null;
            taskList = new ArrayList<Task>();
            if (this.connection == null) {
                return null;
            }
            onceTaskPS = this.connection.prepareStatement("SELECT * FROM " + this.schema + ".task, " + this.schema + ".repeatedtask " + "WHERE  ((endDate is NULL) OR (sysdate <= endDate)) AND (" + this.schema + ".task.appId = ? )  AND (" + this.schema + ".task.taskType = 'ONCE') " + "AND " + this.schema + ".task.repeatedTaskId = " + this.schema + ".repeatedTask.repeatedTaskId(+) ");
            dailyTaskPS = this.connection.prepareStatement("SELECT * FROM " + this.schema + ".task," + this.schema + ".dailyTask, " + this.schema + ".repeatedtask " + "WHERE ((endDate is NULL) OR (sysdate <= endDate)) AND (" + this.schema + ".task.appId = ? )  AND (" + this.schema + ".task.taskId = " + this.schema + ".dailyTask.taskId) " + "AND " + this.schema + ".task.repeatedTaskId = " + this.schema + ".repeatedTask.repeatedTaskId(+) ");
            weeklyTaskPS = this.connection.prepareStatement("SELECT * FROM " + this.schema + ".task," + this.schema + ".weeklyTask, " + this.schema + ".repeatedtask " + "WHERE ((endDate is NULL) OR (sysdate <= endDate)) AND (" + this.schema + ".task.appId = ? )  AND (" + this.schema + ".task.taskId = " + this.schema + ".weeklyTask.taskId) " + "AND " + this.schema + ".task.repeatedTaskId = " + this.schema + ".repeatedTask.repeatedTaskId(+) ");
            monthlyTaskPS = this.connection.prepareStatement("SELECT * FROM " + this.schema + ".task," + this.schema + ".monthlyTask, " + this.schema + ".repeatedtask " + "WHERE ((endDate is NULL) OR (sysdate <= endDate)) AND (" + this.schema + ".task.appId = ? )  AND (" + this.schema + ".task.taskId = " + this.schema + ".monthlyTask.taskId) " + "AND " + this.schema + ".task.repeatedTaskId = " + this.schema + ".repeatedTask.repeatedTaskId(+) ");
            onceTaskPS.setString(1, appId);
            dailyTaskPS.setString(1, appId);
            weeklyTaskPS.setString(1, appId);
            monthlyTaskPS.setString(1, appId);
            onceTaskRS = onceTaskPS.executeQuery();
            dailyTaskRS = dailyTaskPS.executeQuery();
            weeklyTaskRS = weeklyTaskPS.executeQuery();
            monthlyTaskRS = monthlyTaskPS.executeQuery();
            while (onceTaskRS.next()) {
                taskId = onceTaskRS.getInt("taskId");
                strObjectName = onceTaskRS.getString("objectName");
                strMethod = onceTaskRS.getString("methodName");
                startTime = new java.util.Date(onceTaskRS.getTimestamp("StartTime").getTime());
                startDate = onceTaskRS.getDate("startDate");
                endDate = onceTaskRS.getDate("EndDate");
                userName = onceTaskRS.getString("userName");
                int intStatus = Integer.valueOf(onceTaskRS.getString("status"));
                taskList.add(new OnceTask(taskId, appId, strObjectName, strMethod, Scheduler.TaskType.ONCE, startTime, startDate, endDate, intStatus, userName));
            }
            while (dailyTaskRS.next()) {
                taskId = dailyTaskRS.getInt("taskId");
                strObjectName = dailyTaskRS.getString("objectName");
                strMethod = dailyTaskRS.getString("methodName");
                startTime = new java.util.Date(dailyTaskRS.getTimestamp("StartTime").getTime());
                startDate = dailyTaskRS.getDate("startDate");
                endDate = dailyTaskRS.getDate("EndDate");
                userName = dailyTaskRS.getString("userName");
                recurrenceTime = dailyTaskRS.getInt("recurrenceTime");
                int intStatus = Integer.valueOf(dailyTaskRS.getString("status"));
                DailyTask dailyTask = new DailyTask(taskId, appId, strObjectName, strMethod, Scheduler.TaskType.DAILY, startTime, startDate, endDate, intStatus, userName, recurrenceTime);
                int repeatedTaskId = dailyTaskRS.getInt("repeatedTaskId");
                if (repeatedTaskId > 0) {
                    dailyTask.setRepeatedTask(new RepeatedTask(dailyTaskRS.getInt("repeatedRecurrenceTime"), dailyTaskRS.getInt("repeatedTimes")));
                }
                taskList.add(dailyTask);
            }
            while (weeklyTaskRS.next()) {
                taskId = weeklyTaskRS.getInt("taskId");
                strObjectName = weeklyTaskRS.getString("objectName");
                strMethod = weeklyTaskRS.getString("methodName");
                startTime = new java.util.Date(weeklyTaskRS.getTimestamp("StartTime").getTime());
                startDate = weeklyTaskRS.getDate("startDate");
                endDate = weeklyTaskRS.getDate("EndDate");
                userName = weeklyTaskRS.getString("userName");
                recurrenceTime = weeklyTaskRS.getInt("recurrenceTime");
                String dayList = weeklyTaskRS.getString("days");
                int intStatus = Integer.valueOf(weeklyTaskRS.getString("status"));
                WeeklyTask weeklyTask = new WeeklyTask(taskId, appId, strObjectName, strMethod, Scheduler.TaskType.WEEKLY, startTime, startDate, endDate, intStatus, userName, recurrenceTime, dayList);
                int repeatedTaskId = weeklyTaskRS.getInt("repeatedTaskId");
                if (repeatedTaskId > 0) {
                    weeklyTask.setRepeatedTask(new RepeatedTask(weeklyTaskRS.getInt("repeatedRecurrenceTime"), weeklyTaskRS.getInt("repeatedTimes")));
                }
                taskList.add(weeklyTask);
            }
            while (monthlyTaskRS.next()) {
                taskId = monthlyTaskRS.getInt("taskId");
                strObjectName = monthlyTaskRS.getString("objectName");
                strMethod = monthlyTaskRS.getString("methodName");
                startTime = new java.util.Date(monthlyTaskRS.getTimestamp("StartTime").getTime());
                startDate = monthlyTaskRS.getDate("startDate");
                endDate = monthlyTaskRS.getDate("EndDate");
                SimpleDateFormat f = new SimpleDateFormat("dd-MM-yy HH:mm:ss");
                String userName2 = monthlyTaskRS.getString("userName");
                String taskMode = monthlyTaskRS.getString("taskMode");
                String dayList = monthlyTaskRS.getString("days");
                String monthList = monthlyTaskRS.getString("months");
                int intStatus = Integer.valueOf(monthlyTaskRS.getString("status"));
                MonthlyTask monthlyTask = new MonthlyTask(taskId, appId, strObjectName, strMethod, Scheduler.TaskType.MONTHLY, startTime, startDate, endDate, intStatus, userName2, taskMode, dayList, monthList);
                int repeatedTaskId = monthlyTaskRS.getInt("repeatedTaskId");
                if (repeatedTaskId > 0) {
                    monthlyTask.setRepeatedTask(new RepeatedTask(monthlyTaskRS.getInt("repeatedRecurrenceTime"), monthlyTaskRS.getInt("repeatedTimes")));
                }
                taskList.add(monthlyTask);
            }
            Object var26_34 = null;
            try {
                if (onceTaskRS != null) {
                    onceTaskRS.close();
                }
                if (onceTaskPS != null) {
                    onceTaskPS.close();
                }
                if (dailyTaskRS != null) {
                    dailyTaskRS.close();
                }
                if (dailyTaskPS != null) {
                    dailyTaskPS.close();
                }
                if (weeklyTaskRS != null) {
                    weeklyTaskRS.close();
                }
                if (weeklyTaskPS != null) {
                    weeklyTaskPS.close();
                }
                if (monthlyTaskRS != null) {
                    monthlyTaskRS.close();
                }
                if (monthlyTaskPS != null) {
                    monthlyTaskPS.close();
                }
                break block43;
            }
            catch (Exception e) {
                this.log.debug((Object)("close ps " + e.getMessage()));
            }
            break block43;
            {
                catch (SQLException ex) {
                    ex.printStackTrace();
                    this.log.error((Object)("SQL exception:" + ex));
                    if (DatabaseConnection.shareInstance().checkConnection()) {
                        ArrayList<Task> arrayList = taskList;
                        Object var26_35 = null;
                        try {
                            if (onceTaskRS != null) {
                                onceTaskRS.close();
                            }
                            if (onceTaskPS != null) {
                                onceTaskPS.close();
                            }
                            if (dailyTaskRS != null) {
                                dailyTaskRS.close();
                            }
                            if (dailyTaskPS != null) {
                                dailyTaskPS.close();
                            }
                            if (weeklyTaskRS != null) {
                                weeklyTaskRS.close();
                            }
                            if (weeklyTaskPS != null) {
                                weeklyTaskPS.close();
                            }
                            if (monthlyTaskRS != null) {
                                monthlyTaskRS.close();
                            }
                            if (monthlyTaskPS != null) {
                                monthlyTaskPS.close();
                            }
                        }
                        catch (Exception e) {
                            this.log.debug((Object)("close ps " + e.getMessage()));
                        }
                        return arrayList;
                    }
                    try {
                        this.sqlException = true;
                        throw new ConnectionException(ex.getMessage(), "");
                    }
                    catch (Throwable throwable) {
                        Object var26_36 = null;
                        try {
                            if (onceTaskRS != null) {
                                onceTaskRS.close();
                            }
                            if (onceTaskPS != null) {
                                onceTaskPS.close();
                            }
                            if (dailyTaskRS != null) {
                                dailyTaskRS.close();
                            }
                            if (dailyTaskPS != null) {
                                dailyTaskPS.close();
                            }
                            if (weeklyTaskRS != null) {
                                weeklyTaskRS.close();
                            }
                            if (weeklyTaskPS != null) {
                                weeklyTaskPS.close();
                            }
                            if (monthlyTaskRS != null) {
                                monthlyTaskRS.close();
                            }
                            if (monthlyTaskPS != null) {
                                monthlyTaskPS.close();
                            }
                        }
                        catch (Exception e) {
                            this.log.debug((Object)("close ps " + e.getMessage()));
                        }
                        throw throwable;
                    }
                }
            }
        }
        return taskList;
    }

    private boolean iinsertSchedulingLog(int taskId, String action, java.util.Date actionTime, String preCondition, String postCondition, String success) throws ConnectionException {
        if (this.sqlException) {
            this.updateConnection();
        }
        if (this.insertSchedulingLogPS != null) {
            try {
                this.insertSchedulingLogPS.setInt(1, taskId);
                this.insertSchedulingLogPS.setString(2, action);
                this.insertSchedulingLogPS.setString(3, new SimpleDateFormat("yyyy/MM/dd/HH/mm/ss").format(actionTime));
                this.insertSchedulingLogPS.setString(4, preCondition);
                this.insertSchedulingLogPS.setString(5, postCondition);
                this.insertSchedulingLogPS.setString(6, success);
                this.insertSchedulingLogPS.executeUpdate();
                return true;
            }
            catch (Exception e) {
                if (!DatabaseConnection.shareInstance().checkConnection()) {
                    this.sqlException = true;
                    this.log.error((Object)"Problem with database. Exception when insert scheduling log ", (Throwable)e);
                    throw new ConnectionException(e.getMessage(), "");
                }
                this.log.error((Object)"Exception when insert scheduling log ", (Throwable)e);
                return false;
            }
        }
        this.log.error((Object)"Problem with database.Could not insert scheduling log into Database.");
        return false;
    }

    public synchronized boolean insertSchedulingLog(int taskId, String action, java.util.Date actionTime, String preCondition, String postCondition, String success) {
        try {
            return this.iinsertSchedulingLog(taskId, action, actionTime, preCondition, postCondition, success);
        }
        catch (ConnectionException ce) {
            this.log.error((Object)("insert Scheduling Log failed." + ce.getMessage()));
            try {
                return this.iinsertSchedulingLog(taskId, action, actionTime, preCondition, postCondition, success);
            }
            catch (ConnectionException e) {
                this.log.error((Object)("insert Scheduling Log failed againt." + e.getMessage()));
                return false;
            }
        }
    }

    public ArrayList<Task> loadTaskList(String appId) {
        try {
            return this.iloadTaskList(appId);
        }
        catch (ConnectionException ce) {
            this.log.error((Object)ce.getMessage());
            try {
                return this.iloadTaskList(appId);
            }
            catch (ConnectionException e) {
                this.log.error((Object)e.getMessage());
                return new ArrayList<Task>();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private HashMap<Integer, ErrorDefinition> igetErrorDefinition(String appId) throws ConnectionException {
        if (this.sqlException) {
            this.updateConnection();
        }
        HashMap<Integer, ErrorDefinition> errorDefList = new HashMap<Integer, ErrorDefinition>();
        ResultSet errorDefRS = null;
        this.selectErrorDefinitionPS.setString(1, appId);
        this.selectErrorDefinitionPS.setInt(2, 1);
        errorDefRS = this.selectErrorDefinitionPS.executeQuery();
        while (errorDefRS.next()) {
            int errorId = errorDefRS.getInt("errorId");
            String userName = errorDefRS.getString("username");
            java.util.Date createTime = null;
            if (errorDefRS.getTimestamp("createTime") != null) {
                createTime = new java.util.Date(errorDefRS.getTimestamp("createTime").getTime());
            }
            boolean useFlag = errorDefRS.getInt("useFlag") != 0;
            String logLevel = errorDefRS.getString("logLevel");
            ArrayList<ErrorCondition> conditions = new ArrayList<ErrorCondition>();
            try {
                String threadName;
                String message;
                String loggerName;
                if (logLevel != null && !logLevel.equals("")) {
                    conditions.add(new ErrorCondition("LOGLEVEL", logLevel));
                }
                if ((loggerName = errorDefRS.getString("loggerName")) != null && !loggerName.equals("")) {
                    conditions.add(new ErrorCondition("LOGGERNAME", loggerName));
                }
                if ((message = errorDefRS.getString("message")) != null && !message.equals("")) {
                    conditions.add(new ErrorCondition("MESSAGE", message));
                }
                if ((threadName = errorDefRS.getString("threadName")) != null && !threadName.equals("")) {
                    conditions.add(new ErrorCondition("THREADNAME", threadName));
                }
                String smsFormat = errorDefRS.getString("smsFormat");
                String smsContent = errorDefRS.getString("smsContent");
                boolean sendSMS = errorDefRS.getBoolean("sendSMS");
                String errorFrequence = errorDefRS.getString("error_frequence");
                ErrorDefinition ed = new ErrorDefinition(errorId, appId, userName, createTime, useFlag, conditions, smsFormat, smsContent, sendSMS);
                if (errorFrequence != null && !errorFrequence.equals("")) {
                    try {
                        String[] temp = errorFrequence.split("-");
                        if (temp.length == 2) {
                            int numOfError_EF = Integer.valueOf(temp[0]);
                            int minute_EF = Integer.valueOf(temp[1]);
                            if (numOfError_EF > 1 && minute_EF > 0) {
                                ed.setNumOfErrorOfErrorFrequence(numOfError_EF);
                            }
                            ed.setMinutesOfErrorFrequence(minute_EF);
                        }
                    }
                    catch (Exception e) {
                        Log.warn("Exception when read error definition" + e);
                    }
                }
                errorDefList.put(errorId, ed);
            }
            catch (IllegalArgumentException iae) {
                Log.warn("Exception " + iae);
            }
        }
        HashMap<Integer, ErrorDefinition> errorId = errorDefList;
        Object var22_28 = null;
        try {
            if (errorDefRS != null) {
                errorDefRS.close();
            }
        }
        catch (Exception e2) {
            Log.warn(e2.toString());
        }
        return errorId;
        catch (SQLException ex) {
            Log.warn("Exception when select error definition:" + ex);
            if (!DatabaseConnection.shareInstance().checkConnection()) {
                this.sqlException = true;
                throw new ConnectionException(ex.getMessage(), "");
            }
            HashMap<Integer, ErrorDefinition> hashMap = null;
            Object var22_29 = null;
            try {
                if (errorDefRS != null) {
                    errorDefRS.close();
                }
            }
            catch (Exception e2) {
                Log.warn(e2.toString());
            }
            return hashMap;
        }
        catch (Exception e) {
            Log.warn(e);
            HashMap<Integer, ErrorDefinition> hashMap = null;
            Object var22_30 = null;
            {
                catch (Throwable throwable) {
                    Object var22_31 = null;
                    try {
                        if (errorDefRS != null) {
                            errorDefRS.close();
                        }
                    }
                    catch (Exception e2) {
                        Log.warn(e2.toString());
                    }
                    throw throwable;
                }
            }
            try {
                if (errorDefRS != null) {
                    errorDefRS.close();
                }
            }
            catch (Exception e2) {
                Log.warn(e2.toString());
            }
            return hashMap;
        }
    }

    public synchronized HashMap<Integer, ErrorDefinition> getErrorDefinition(String appId) {
        try {
            return this.igetErrorDefinition(appId);
        }
        catch (ConnectionException ex) {
            Log.info("connection exception:" + ex);
            Log.info("connection is closed before, retry again");
            try {
                return this.igetErrorDefinition(appId);
            }
            catch (ConnectionException e) {
                Log.info("connection exception:" + e);
                Log.info("can't create connection");
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private int iinsertErrorDefinition(String appId, String userName, java.util.Date createTime, boolean useFlag, String logLevel, String loggerName, String message, String threadName, String smsFormat, String smsContent, boolean sendSMS, String error_Frequence) throws ConnectionException {
        if (this.sqlException) {
            this.updateConnection();
        }
        ResultSet errorIdRS = null;
        int errorId = 0;
        errorIdRS = this.errorIdSeqPS.executeQuery();
        errorIdRS.next();
        errorId = errorIdRS.getInt(1);
        this.insertErrorDefinitionPS.setInt(1, errorId);
        this.insertErrorDefinitionPS.setString(2, appId);
        this.insertErrorDefinitionPS.setString(3, userName);
        this.insertErrorDefinitionPS.setDate(4, new Date(createTime.getTime()));
        if (useFlag) {
            this.insertErrorDefinitionPS.setInt(5, 1);
        } else {
            this.insertErrorDefinitionPS.setInt(5, 0);
        }
        if (logLevel != null && !logLevel.equals("")) {
            this.insertErrorDefinitionPS.setString(6, logLevel);
        } else {
            this.insertErrorDefinitionPS.setString(6, "");
        }
        if (loggerName != null && !loggerName.equals("")) {
            this.insertErrorDefinitionPS.setString(7, loggerName);
        } else {
            this.insertErrorDefinitionPS.setString(7, "");
        }
        if (message != null && !message.equals("")) {
            this.insertErrorDefinitionPS.setString(8, message);
        } else {
            this.insertErrorDefinitionPS.setString(8, "");
        }
        if (threadName != null && !threadName.equals("")) {
            this.insertErrorDefinitionPS.setString(9, threadName);
        } else {
            this.insertErrorDefinitionPS.setString(9, "");
        }
        this.insertErrorDefinitionPS.setString(10, smsFormat);
        this.insertErrorDefinitionPS.setString(11, smsContent);
        this.insertErrorDefinitionPS.setBoolean(12, sendSMS);
        if (error_Frequence != null) {
            this.insertErrorDefinitionPS.setString(13, error_Frequence);
        } else {
            this.insertErrorDefinitionPS.setString(13, "");
        }
        if (this.insertErrorDefinitionPS.executeUpdate() < 0) {
            errorId = 0;
        }
        int n = errorId;
        Object var18_18 = null;
        try {
            if (errorIdRS != null) {
                errorIdRS.close();
            }
        }
        catch (Exception e2) {
            Log.warn(e2.toString());
        }
        return n;
        catch (SQLException ex) {
            Log.warn("Exception when insert definition:" + ex);
            if (!DatabaseConnection.shareInstance().checkConnection()) {
                this.sqlException = true;
                throw new ConnectionException(ex.getMessage(), "");
            }
            int n2 = -1;
            Object var18_19 = null;
            try {
                if (errorIdRS != null) {
                    errorIdRS.close();
                }
            }
            catch (Exception e2) {
                Log.warn(e2.toString());
            }
            return n2;
        }
        catch (Exception e) {
            Log.warn(e);
            int n3 = -1;
            Object var18_20 = null;
            {
                catch (Throwable throwable) {
                    Object var18_21 = null;
                    try {
                        if (errorIdRS != null) {
                            errorIdRS.close();
                        }
                    }
                    catch (Exception e2) {
                        Log.warn(e2.toString());
                    }
                    throw throwable;
                }
            }
            try {
                if (errorIdRS != null) {
                    errorIdRS.close();
                }
            }
            catch (Exception e2) {
                Log.warn(e2.toString());
            }
            return n3;
        }
    }

    public synchronized int insertErrorDefinition(String appId, String userName, java.util.Date createTime, boolean useFlag, String logLevel, String loggerName, String message, String threadName, String smsFormat, String smsContent, boolean sendSMS, String error_Frequence) {
        try {
            return this.iinsertErrorDefinition(appId, userName, createTime, useFlag, logLevel, loggerName, message, threadName, smsFormat, smsContent, sendSMS, error_Frequence);
        }
        catch (ConnectionException ex) {
            Log.info("connection exception:" + ex);
            Log.info("connection is closed before, retry again");
            try {
                return this.iinsertErrorDefinition(appId, userName, createTime, useFlag, logLevel, loggerName, message, threadName, smsFormat, smsContent, sendSMS, error_Frequence);
            }
            catch (ConnectionException e) {
                Log.info("connection exception:" + e);
                Log.info("can't create connection");
                return -1;
            }
        }
    }

    private int ideleteErrorDefinition(int errorId) throws ConnectionException {
        if (this.sqlException) {
            this.updateConnection();
        }
        try {
            this.deleteErrorDefinitionPS.setInt(1, errorId);
            if (this.deleteErrorDefinitionPS.executeUpdate() == 0) {
                return 0;
            }
            return errorId;
        }
        catch (SQLException ex) {
            Log.warn("Exception when delete error definition:" + ex);
            if (!DatabaseConnection.shareInstance().checkConnection()) {
                this.sqlException = true;
                throw new ConnectionException(ex.getMessage(), "");
            }
            return -1;
        }
        catch (Exception e) {
            Log.warn(e);
            return -1;
        }
    }

    public synchronized int deleteErrorDefinition(int errorId) {
        try {
            return this.ideleteErrorDefinition(errorId);
        }
        catch (ConnectionException ex) {
            Log.info("connection exception:" + ex);
            Log.info("connection is closed before, retry again");
            try {
                return this.ideleteErrorDefinition(errorId);
            }
            catch (ConnectionException e) {
                Log.info("connection exception:" + e);
                Log.info("can't create connection");
                return -1;
            }
        }
    }

    private int isetErrorDefinitionUseFlag(int errorId, boolean useFlag) throws ConnectionException {
        if (this.sqlException) {
            this.updateConnection();
        }
        try {
            this.setErrorDefinitionUseFlagPS.setInt(1, errorId);
            this.setErrorDefinitionUseFlagPS.setInt(2, useFlag ? 1 : 0);
            if (this.setErrorDefinitionUseFlagPS.executeUpdate() == 0) {
                return -1;
            }
            return useFlag ? 1 : 0;
        }
        catch (SQLException ex) {
            Log.warn("Exception when set error definition use Flag:" + ex);
            if (!DatabaseConnection.shareInstance().checkConnection()) {
                this.sqlException = true;
                throw new ConnectionException(ex.getMessage(), "");
            }
            return -1;
        }
        catch (Exception e) {
            Log.warn(e);
            return -1;
        }
    }

    public synchronized int setErrorDefinitionUseFlag(int errorId, boolean useFlag) {
        try {
            return this.isetErrorDefinitionUseFlag(errorId, useFlag);
        }
        catch (ConnectionException ex) {
            Log.info("connection exception:" + ex);
            Log.info("connection is closed before, retry again");
            try {
                return this.isetErrorDefinitionUseFlag(errorId, useFlag);
            }
            catch (ConnectionException e) {
                Log.info("connection exception:" + e);
                Log.info("can't create connection");
                return -1;
            }
        }
    }

    private String iselectApplicationTelephone(String appId) throws ConnectionException {
        if (this.sqlException) {
            this.updateConnection();
        }
        ResultSet appTelephoneRS = null;
        String telephoneList = "";
        try {
            this.selectApplicationTelephone.setString(1, appId);
            appTelephoneRS = this.selectApplicationTelephone.executeQuery();
            while (appTelephoneRS.next()) {
                telephoneList = appTelephoneRS.getString("phone_number_list");
            }
            return telephoneList;
        }
        catch (SQLException ex) {
            Log.warn("Exception when select error definition:" + ex);
            if (!DatabaseConnection.shareInstance().checkConnection()) {
                this.sqlException = true;
                throw new ConnectionException(ex.getMessage(), "");
            }
            return "";
        }
        catch (Exception e) {
            Log.warn(e);
            return "";
        }
    }

    public synchronized String selectApplicationTelephone(String appId) {
        try {
            return this.iselectApplicationTelephone(appId);
        }
        catch (ConnectionException ex) {
            Log.info("connection exception:" + ex);
            Log.info("connection is closed before, retry again");
            try {
                return this.iselectApplicationTelephone(appId);
            }
            catch (ConnectionException e) {
                Log.info("connection exception:" + e);
                Log.info("can't create connection");
                return "";
            }
        }
    }

    private int iinsertApplicationTelephone(String appId, String phone_number_list) throws ConnectionException {
        if (this.sqlException) {
            this.updateConnection();
        }
        try {
            this.insertApplicationTelephone.setString(1, appId);
            this.insertApplicationTelephone.setString(2, phone_number_list);
            if (this.insertApplicationTelephone.executeUpdate() == 0) {
                return 0;
            }
            return 1;
        }
        catch (SQLException ex) {
            Log.warn("Exception when insert Telephone:" + ex);
            if (!DatabaseConnection.shareInstance().checkConnection()) {
                this.sqlException = true;
                throw new ConnectionException(ex.getMessage(), "");
            }
            return -1;
        }
        catch (Exception e) {
            Log.warn(e);
            return -1;
        }
    }

    public synchronized int insertApplicationTelephone(String appId, String phone_number_list) {
        try {
            return this.iinsertApplicationTelephone(appId, phone_number_list);
        }
        catch (ConnectionException ex) {
            Log.info("connection exception:" + ex);
            Log.info("connection is closed before, retry again");
            try {
                return this.iinsertApplicationTelephone(appId, phone_number_list);
            }
            catch (ConnectionException e) {
                Log.info("connection exception:" + e);
                Log.info("can't create connection");
                return -1;
            }
        }
    }

    private int iupdateApplicationTelephone(String appId, String phone_number_list) throws ConnectionException {
        if (this.sqlException) {
            this.updateConnection();
        }
        try {
            this.updateApplicationTelephonePS.setString(1, appId);
            this.updateApplicationTelephonePS.setString(2, phone_number_list);
            int i = this.updateApplicationTelephonePS.executeUpdate();
            if (i == 0) {
                return 0;
            }
            return 1;
        }
        catch (SQLException ex) {
            Log.warn("Exception when update telephone:" + ex);
            if (!DatabaseConnection.shareInstance().checkConnection()) {
                this.sqlException = true;
                throw new ConnectionException(ex.getMessage(), "");
            }
            return -1;
        }
        catch (Exception e) {
            Log.warn(e);
            return -1;
        }
    }

    public synchronized int updateApplicationTelephone(String appId, String phone_number_list) {
        try {
            return this.iupdateApplicationTelephone(appId, phone_number_list);
        }
        catch (ConnectionException ex) {
            Log.info("connection exception:" + ex);
            Log.info("connection is closed before, retry again");
            try {
                return this.iupdateApplicationTelephone(appId, phone_number_list);
            }
            catch (ConnectionException e) {
                Log.info("connection exception:" + e);
                Log.info("can't create connection");
                return -1;
            }
        }
    }

    private int irequestSendSMS(String message, String applicationId) throws ConnectionException {
        if (this.sqlException) {
            this.updateConnection();
        }
        try {
            int maxAtempt = 0;
            this.selectMaxAttemptPS.setString(1, applicationId);
            ResultSet rs = this.selectMaxAttemptPS.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    maxAtempt = rs.getInt(1);
                }
                try {
                    rs.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (maxAtempt == 0) {
                maxAtempt = 5;
            }
            this.requestSendSMS.setString(1, message);
            this.requestSendSMS.setString(2, applicationId);
            this.requestSendSMS.setInt(3, maxAtempt);
            int result = this.requestSendSMS.executeUpdate();
            return result;
        }
        catch (SQLException ex) {
            Log.warn("Exception when request send SMS: " + ex);
            if (!DatabaseConnection.shareInstance().checkConnection()) {
                this.sqlException = true;
                throw new ConnectionException(ex.getMessage(), "");
            }
            return -1;
        }
        catch (Exception e) {
            Log.warn(e);
            return -1;
        }
    }

    public synchronized int requestSendSMS(String message, String applicationId) {
        try {
            return this.irequestSendSMS(message, applicationId);
        }
        catch (ConnectionException ex) {
            Log.info("connection exception:" + ex);
            Log.info("connection is closed, retry again");
            try {
                return this.irequestSendSMS(message, applicationId);
            }
            catch (ConnectionException e) {
                Log.info("connection exception:" + e);
                Log.info("can't create connection");
                return -1;
            }
        }
    }

    public synchronized int insertApplication(String appID, int maxAttemp, String desc) {
        try {
            return this.iinsertApplication(appID, maxAttemp, desc);
        }
        catch (ConnectionException ex) {
            Log.info("connection exception:" + ex);
            Log.info("connection is closed, retry again");
            try {
                return this.iinsertApplication(appID, maxAttemp, desc);
            }
            catch (ConnectionException e) {
                Log.info("connection exception:" + e);
                Log.info("can't create connection");
                return -1;
            }
        }
    }

    private int iinsertApplication(String appId, int maxAttempt, String desc) throws ConnectionException {
        if (this.sqlException) {
            this.updateConnection();
        }
        try {
            Statement stm = this.connection.createStatement();
            return stm.executeUpdate("INSERT INTO " + this.schema + ".APPLICATION(APPLICATION_ID,MAX_ATTEMP) VALUES('" + appId + "'," + maxAttempt + ",'" + desc + "')");
        }
        catch (SQLException ex) {
            Log.warn("Exception when insert Application:" + ex);
            if (!DatabaseConnection.shareInstance().checkConnection()) {
                this.sqlException = true;
                throw new ConnectionException(ex.getMessage(), "");
            }
            return -1;
        }
        catch (Exception e) {
            Log.warn(e);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private int ideleteReceiver(String appID) throws ConnectionException {
        int n;
        Statement stm;
        block13: {
            if (this.sqlException) {
                this.updateConnection();
            }
            stm = null;
            stm = this.connection.createStatement();
            n = stm.executeUpdate("DELETE FROM " + this.schema + ".APP_RECEIVER WHERE application_id = '" + appID + "'");
            Object var6_6 = null;
            if (stm == null) break block13;
            try {
                stm.close();
            }
            catch (SQLException ex2) {
                // empty catch block
            }
        }
        return n;
        catch (SQLException ex) {
            int n2;
            block14: {
                Log.warn("Exception when delete Receiver:" + ex);
                if (!DatabaseConnection.shareInstance().checkConnection()) {
                    this.sqlException = true;
                    throw new ConnectionException(ex.getMessage(), "");
                }
                n2 = -1;
                Object var6_7 = null;
                if (stm == null) break block14;
                try {
                    stm.close();
                }
                catch (SQLException ex2) {
                    // empty catch block
                }
            }
            return n2;
        }
        catch (Exception e) {
            int n3;
            block15: {
                Log.warn(e);
                n3 = -1;
                Object var6_8 = null;
                if (stm == null) break block15;
                {
                    catch (Throwable throwable) {
                        block16: {
                            Object var6_9 = null;
                            if (stm == null) break block16;
                            try {
                                stm.close();
                            }
                            catch (SQLException ex2) {}
                        }
                        throw throwable;
                    }
                }
                try {
                    stm.close();
                }
                catch (SQLException ex2) {
                    // empty catch block
                }
            }
            return n3;
        }
    }

    private int ideleteApplicationReceiver(String appID) throws ConnectionException {
        if (this.sqlException) {
            this.updateConnection();
        }
        try {
            this.deleteApplicationReceiverPS.setString(1, appID);
            return this.deleteApplicationReceiverPS.executeUpdate();
        }
        catch (SQLException ex) {
            Log.warn("Exception when delete Application_Receiver:" + ex);
            if (!DatabaseConnection.shareInstance().checkConnection()) {
                this.sqlException = true;
                throw new ConnectionException(ex.getMessage(), "");
            }
            return -1;
        }
        catch (Exception e) {
            Log.warn(e);
            return -1;
        }
    }

    public int deleteApplicationReceiver(String appID) {
        try {
            return this.ideleteApplicationReceiver(appID);
        }
        catch (ConnectionException ex) {
            Log.info("connection exception:" + ex);
            Log.info("connection is closed, retry again");
            try {
                return this.ideleteApplicationReceiver(appID);
            }
            catch (ConnectionException e) {
                Log.info("connection exception:" + e);
                Log.info("can't create connection");
                return -1;
            }
        }
    }

    public int deleleReceiver(String appID) {
        try {
            return this.ideleteReceiver(appID);
        }
        catch (ConnectionException ex) {
            Log.info("connection exception:" + ex);
            Log.info("connection is closed, retry again");
            try {
                return this.ideleteReceiver(appID);
            }
            catch (ConnectionException e) {
                Log.info("connection exception:" + e);
                Log.info("can't create connection");
                return -1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private int iinsertReceiver(String appID, String phone_num_list) throws ConnectionException {
        Statement insertApp_ReceiverPS;
        Statement insertPS;
        Statement receiverIdPS;
        ResultSet rs;
        block36: {
            if (this.sqlException) {
                this.updateConnection();
            }
            rs = null;
            receiverIdPS = null;
            insertPS = null;
            insertApp_ReceiverPS = null;
            receiverIdPS = this.connection.prepareStatement("SELECT " + this.schema + ".Receiver_ID_seq.nextVal from dual");
            insertPS = this.connection.prepareStatement("INSERT INTO " + this.schema + ".RECEIVER(Receiver_ID,Receiver_Name,MSISDN) VALUES(?,?,?)");
            insertApp_ReceiverPS = this.connection.prepareStatement("INSERT INTO " + this.schema + ".APP_RECEIVER(APPLICATION_ID, RECEIVER_ID, RECEIVE_METHOD) VALUES (?,?,?)");
            insertApp_ReceiverPS.setString(1, appID);
            insertApp_ReceiverPS.setInt(3, 1);
            if (phone_num_list != null && !phone_num_list.equals("")) break block36;
            int n = 0;
            Object var15_11 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (receiverIdPS != null) {
                    receiverIdPS.close();
                }
                if (insertPS != null) {
                    insertPS.close();
                }
                if (insertApp_ReceiverPS != null) {
                    insertApp_ReceiverPS.close();
                }
            }
            catch (Exception e2) {
                Log.warn(e2);
            }
            return n;
        }
        String[] phones = phone_num_list.split(" ");
        int result = 0;
        for (String phone : phones) {
            rs = receiverIdPS.executeQuery();
            rs.next();
            int receiverId = rs.getInt(1);
            insertPS.setInt(1, receiverId);
            insertPS.setString(2, "MMClient");
            insertPS.setString(3, phone);
            if (insertPS.executeUpdate() <= 0) continue;
            insertApp_ReceiverPS.setInt(2, receiverId);
            result = insertApp_ReceiverPS.executeUpdate();
        }
        int n = result;
        Object var15_12 = null;
        try {
            if (rs != null) {
                rs.close();
            }
            if (receiverIdPS != null) {
                receiverIdPS.close();
            }
            if (insertPS != null) {
                insertPS.close();
            }
            if (insertApp_ReceiverPS != null) {
                insertApp_ReceiverPS.close();
            }
        }
        catch (Exception e2) {
            Log.warn(e2);
        }
        return n;
        catch (SQLException ex) {
            Log.warn("Exception when insert Reciver:" + ex);
            if (!DatabaseConnection.shareInstance().checkConnection()) {
                this.sqlException = true;
                throw new ConnectionException(ex.getMessage(), "");
            }
            int n2 = -1;
            Object var15_13 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (receiverIdPS != null) {
                    receiverIdPS.close();
                }
                if (insertPS != null) {
                    insertPS.close();
                }
                if (insertApp_ReceiverPS != null) {
                    insertApp_ReceiverPS.close();
                }
            }
            catch (Exception e2) {
                Log.warn(e2);
            }
            return n2;
        }
        catch (Exception e) {
            Log.warn(e);
            int n3 = -1;
            Object var15_14 = null;
            {
                catch (Throwable throwable) {
                    Object var15_15 = null;
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        if (receiverIdPS != null) {
                            receiverIdPS.close();
                        }
                        if (insertPS != null) {
                            insertPS.close();
                        }
                        if (insertApp_ReceiverPS != null) {
                            insertApp_ReceiverPS.close();
                        }
                    }
                    catch (Exception e2) {
                        Log.warn(e2);
                    }
                    throw throwable;
                }
            }
            try {
                if (rs != null) {
                    rs.close();
                }
                if (receiverIdPS != null) {
                    receiverIdPS.close();
                }
                if (insertPS != null) {
                    insertPS.close();
                }
                if (insertApp_ReceiverPS != null) {
                    insertApp_ReceiverPS.close();
                }
            }
            catch (Exception e2) {
                Log.warn(e2);
            }
            return n3;
        }
    }

    public synchronized int insertReceiver(String appID, String phone_num_list) {
        try {
            return this.iinsertReceiver(appID, phone_num_list);
        }
        catch (ConnectionException ex) {
            Log.info("connection exception:" + ex);
            Log.info("connection is closed, retry again");
            try {
                return this.iinsertReceiver(appID, phone_num_list);
            }
            catch (ConnectionException e) {
                Log.info("connection exception:" + e);
                Log.info("can't create connection");
                return -1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String iselectPhoneNumList(String appId) throws ConnectionException {
        if (this.sqlException) {
            this.updateConnection();
        }
        Statement stm = null;
        ResultSet rs = null;
        try {
            try {
                stm = this.connection.createStatement();
                rs = stm.executeQuery("SELECT MSISDN FROM " + this.schema + ".RECEIVER R , " + this.schema + ".APP_RECEIVER A WHERE " + "A.APPLICATION_ID = '" + appId + "'  AND R.RECEIVER_ID = A.RECIVER_ID ");
                StringBuilder str = new StringBuilder();
                if (rs == null) return str.toString().trim();
                while (rs.next()) {
                    str.append(rs.getString("MSISDN"));
                    str.append(" ");
                }
                return str.toString().trim();
            }
            catch (SQLException ex) {
                Log.warn("Exception when update telephone:" + ex);
                if (DatabaseConnection.shareInstance().checkConnection()) return "";
                this.sqlException = true;
                throw new ConnectionException(ex.getMessage(), "");
            }
            catch (Exception e) {
                Log.warn(e);
                return "";
            }
        }
        catch (Throwable throwable) {
            Object var7_13 = null;
            throw throwable;
        }
    }

    public synchronized String selectTelephone(String appID) {
        try {
            return this.iselectPhoneNumList(appID);
        }
        catch (ConnectionException ex) {
            Log.info("connection exception:" + ex);
            Log.info("connection is closed, retry again");
            try {
                return this.iselectPhoneNumList(appID);
            }
            catch (ConnectionException e) {
                Log.info("connection exception:" + e);
                Log.info("can't create connection");
                return "";
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private HashMap<String, TimeoutInfo> iselectThreadTimeout(String applicationID) throws ConnectionException {
        if (this.sqlException) {
            this.updateConnection();
        }
        HashMap<String, TimeoutInfo> result = new HashMap<String, TimeoutInfo>();
        ResultSet rs = null;
        this.selectThreadTimeoutPS.setString(1, applicationID);
        rs = this.selectThreadTimeoutPS.executeQuery();
        while (rs.next()) {
            result.put(rs.getString("MBEANNAME"), new TimeoutInfo(rs.getInt("TIMEOUT"), rs.getBoolean("SENDSMS")));
        }
        HashMap<String, TimeoutInfo> hashMap = result;
        Object var7_7 = null;
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException ex2) {
            Log.warn(ex2);
        }
        return hashMap;
        catch (SQLException ex) {
            Log.warn("Exception when select Thread timeout:" + ex);
            if (!DatabaseConnection.shareInstance().checkConnection()) {
                this.sqlException = true;
                throw new ConnectionException(ex.getMessage(), "");
            }
            HashMap<String, TimeoutInfo> hashMap2 = null;
            Object var7_8 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex2) {
                Log.warn(ex2);
            }
            return hashMap2;
        }
        catch (Exception e) {
            Log.warn(e);
            HashMap<String, TimeoutInfo> hashMap3 = null;
            Object var7_9 = null;
            {
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (SQLException ex2) {
                        Log.warn(ex2);
                    }
                    throw throwable;
                }
            }
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex2) {
                Log.warn(ex2);
            }
            return hashMap3;
        }
    }

    public synchronized HashMap<String, TimeoutInfo> selectThreadTimeout(String applicationID) {
        try {
            return this.iselectThreadTimeout(applicationID);
        }
        catch (ConnectionException ex) {
            Log.info("connection exception:" + ex);
            Log.info("connection is closed before, retry again");
            try {
                return this.iselectThreadTimeout(applicationID);
            }
            catch (ConnectionException e) {
                Log.info("connection exception:" + e);
                Log.info("can't create connection");
                return null;
            }
        }
    }

    private int ideleteThreadTimeout(String appID, String mbeanName) throws ConnectionException {
        if (this.sqlException) {
            this.updateConnection();
        }
        try {
            this.deleteThreadTimeoutPS.setString(1, appID);
            this.deleteThreadTimeoutPS.setString(2, mbeanName);
            return this.deleteThreadTimeoutPS.executeUpdate();
        }
        catch (SQLException ex) {
            Log.warn("Exception when delete Thread timeout:" + ex);
            if (!DatabaseConnection.shareInstance().checkConnection()) {
                this.sqlException = true;
                throw new ConnectionException(ex.getMessage(), "");
            }
            return -1;
        }
        catch (Exception e) {
            Log.warn(e);
            return -1;
        }
    }

    public synchronized int deleteThreadTimeout(String appID, String mbeanName) {
        try {
            return this.ideleteThreadTimeout(appID, mbeanName);
        }
        catch (ConnectionException ex) {
            Log.info("connection exception:" + ex);
            Log.info("connection is closed before, retry again");
            try {
                return this.ideleteThreadTimeout(appID, mbeanName);
            }
            catch (ConnectionException e) {
                Log.info("connection exception:" + e);
                Log.info("can't create connection");
                return -1;
            }
        }
    }

    private int ieditThreadTimeout(String appID, String mbeanName, int timeout, boolean sendSMS) throws ConnectionException {
        if (this.sqlException) {
            this.updateConnection();
        }
        try {
            this.editThreadTimeoutPS.setInt(1, timeout);
            this.editThreadTimeoutPS.setBoolean(2, sendSMS);
            this.editThreadTimeoutPS.setString(3, appID);
            this.editThreadTimeoutPS.setString(4, mbeanName);
            return this.editThreadTimeoutPS.executeUpdate();
        }
        catch (SQLException ex) {
            Log.warn("Exception when edit Thread timeout:" + ex);
            if (!DatabaseConnection.shareInstance().checkConnection()) {
                this.sqlException = true;
                throw new ConnectionException(ex.getMessage(), "");
            }
            return -1;
        }
        catch (Exception e) {
            Log.warn(e);
            return -1;
        }
    }

    public synchronized int editThreadTimeout(String appID, String mbeanName, int timeout, boolean sendSMS) {
        try {
            return this.ieditThreadTimeout(appID, mbeanName, timeout, sendSMS);
        }
        catch (ConnectionException ex) {
            Log.info("connection exception:" + ex);
            Log.info("connection is closed before, retry again");
            try {
                return this.ieditThreadTimeout(appID, mbeanName, timeout, sendSMS);
            }
            catch (ConnectionException e) {
                Log.info("connection exception:" + e);
                Log.info("can't create connection");
                return -1;
            }
        }
    }

    private int iinsertThreadTimeout(String appID, String mbeanName, int timeout, boolean sendSMS) throws ConnectionException {
        if (this.sqlException) {
            this.updateConnection();
        }
        try {
            this.insertThreadTimeoutPS.setString(1, appID);
            this.insertThreadTimeoutPS.setString(2, mbeanName);
            this.insertThreadTimeoutPS.setInt(3, timeout);
            this.insertThreadTimeoutPS.setBoolean(4, sendSMS);
            return this.insertThreadTimeoutPS.executeUpdate();
        }
        catch (SQLException ex) {
            Log.warn("Exception when insert Thread timeout:" + ex);
            if (!DatabaseConnection.shareInstance().checkConnection()) {
                this.sqlException = true;
                throw new ConnectionException(ex.getMessage(), "");
            }
            return -1;
        }
        catch (Exception e) {
            Log.warn(e);
            return -1;
        }
    }

    public synchronized int insertThreadTimeout(String appID, String mbeanName, int timeout, boolean sendSMS) {
        try {
            return this.iinsertThreadTimeout(appID, mbeanName, timeout, sendSMS);
        }
        catch (ConnectionException ex) {
            Log.info("connection exception:" + ex);
            Log.info("connection is closed before, retry again");
            try {
                return this.iinsertThreadTimeout(appID, mbeanName, timeout, sendSMS);
            }
            catch (ConnectionException e) {
                Log.info("connection exception:" + e);
                Log.info("can't create connection");
                return -1;
            }
        }
    }

    public synchronized void close() {
        try {
            this.connection.close();
        }
        catch (SQLException ex) {
            Log.warn(ex);
        }
    }
}

