/*
 * Decompiled with CFR 0.152.
 */
package vasp.utils;

import java.io.BufferedReader;
import java.io.IOException;
import org.apache.log4j.Logger;

public class ConfigLoader {
    protected Logger logger;

    public ConfigLoader(String name) {
        this.logger = Logger.getLogger((String)name);
    }

    public static int getValue(String s, int defaultValue) {
        String value = ConfigLoader.getValue(s, "=");
        return ConfigLoader.getInt(value, defaultValue);
    }

    public static String getValue(String s, String matcher) {
        int i = s.indexOf(matcher);
        if (i < 0) {
            return null;
        }
        s = s.substring(i + 1).trim();
        return ConfigLoader.format(s);
    }

    public static String format(String s) {
        s = s.trim();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                if (i < s.length() - 1 && s.charAt(i + 1) == 't' && (i == 0 || i > 0 && s.charAt(i - 1) != '\\')) {
                    buf.append('\t');
                    ++i;
                    continue;
                }
                if (i < s.length() - 1 && s.charAt(i + 1) == 'r' && (i == 0 || i > 0 && s.charAt(i - 1) != '\\')) {
                    buf.append('\r');
                    ++i;
                    continue;
                }
                if (i < s.length() - 1 && s.charAt(i + 1) == 'n' && (i == 0 || i > 0 && s.charAt(i - 1) != '\\')) {
                    buf.append('\n');
                    ++i;
                    continue;
                }
                buf.append(c);
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static boolean getBoolean(String str, boolean defaultValue) {
        boolean b = str == null || str.length() == 0 ? defaultValue : str.equalsIgnoreCase("true");
        return b;
    }

    public static String getValue(String input, String key, String defaultValue) {
        String output = defaultValue;
        if (input == null || input.length() == 0) {
            return output;
        }
        int inputLen = input.length();
        int keyLen = key.length();
        String iKey = key + " ";
        int from = input.indexOf(iKey);
        if (from < 0) {
            return output;
        }
        int to = input.indexOf("-", from + 1);
        int dest = to < 0 ? inputLen : to;
        if (from + keyLen > dest) {
            return output;
        }
        String value1 = input.substring(from + keyLen, dest);
        String value2 = value1.trim();
        if (value2 == null || value2.length() == 0) {
            return output;
        }
        output = value2;
        return output.trim();
    }

    public static int getInt(String key, int defaultValue) {
        int i;
        try {
            i = Integer.decode(key);
        }
        catch (NumberFormatException ex) {
            Logger.getLogger(ConfigLoader.class).error((Object)("format exception:" + ex));
            i = defaultValue;
        }
        return i;
    }

    public static byte getByte(String s, byte defaultValue) {
        byte i;
        try {
            i = Byte.decode(s);
        }
        catch (NumberFormatException ex) {
            Logger.getLogger(ConfigLoader.class).error((Object)("format exception:" + ex));
            i = defaultValue;
        }
        return i;
    }

    public static String read(BufferedReader r) throws IOException {
        String str = r.readLine();
        if (str != null) {
            str = str.trim();
        }
        return str;
    }
}

