/*
 * Decompiled with CFR 0.152.
 */
package transport.tcp.message;

import transport.tcp.AdvanceByteBuffer;
import transport.tcp.message.AbServiceMessage;

public class ServiceForward
extends AbServiceMessage {
    protected String orgService;
    private String content;

    public ServiceForward(String provider, String gateway, String orgService, String terService, String sender, String receiver, String content) {
        super(6, 269);
        this.type = (byte)6;
        this.provider = provider;
        this.gateway = gateway;
        this.orgService = orgService;
        this.serviceId = terService;
        this.sender = sender;
        this.receiver = receiver;
        this.content = content;
        this.put("Name", "SubmitResponse");
        this.put("OrgServiceId", orgService);
        this.put("ServiceId", this.serviceId);
        this.put("Sender", sender);
        this.put("Receiver", receiver);
        this.put("Content", content);
    }

    public ServiceForward(byte[] b) throws Exception {
        super(6, 269);
        AdvanceByteBuffer buf = new AdvanceByteBuffer(b);
        this.content = buf.popCString(160);
        this.receiver = buf.popCString(14);
        this.sender = buf.popCString(14);
        this.serviceId = buf.popCString(10);
        this.orgService = buf.popCString(10);
        this.gateway = buf.popCString(30);
        this.provider = buf.popCString(30);
        this.type = buf.popByte();
        this.put("Name", "SubmitResponse");
        this.put("OrgServiceId", this.orgService);
        this.put("ServiceId", this.serviceId);
        this.put("Sender", this.sender);
        this.put("Receiver", this.receiver);
        this.put("Content", this.content);
    }

    @Override
    public byte[] toBytes() throws Exception {
        AdvanceByteBuffer buf = new AdvanceByteBuffer();
        buf.appendByte(this.type);
        buf.appendCString(this.provider, 30);
        buf.appendCString(this.gateway, 30);
        buf.appendCString(this.orgService, 10);
        buf.appendCString(this.serviceId, 10);
        buf.appendCString(this.sender, 14);
        buf.appendCString(this.receiver, 14);
        buf.appendCString(this.content, 160);
        return buf.array();
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getOrgService() {
        return this.orgService;
    }

    public void setOrgService(String orgService) {
        this.orgService = orgService;
    }

    @Override
    public String debugString() {
        return "ServiceForward " + this.orgService + "->" + this.serviceId + " (Sender=" + this.sender + ", Receiver=" + this.receiver + ", Content=" + this.content + ")";
    }
}

