/*
 * Decompiled with CFR 0.152.
 */
package transport.tcp.message;

import transport.tcp.AdvanceByteBuffer;
import transport.tcp.message.TcpMessage;

public class BoundRequest
extends TcpMessage {
    protected String serviceId;
    protected String username;
    protected String password;

    public BoundRequest(String serviceId, String username, String password) {
        super(1, 31);
        this.serviceId = serviceId;
        this.username = username;
        this.password = password;
    }

    public BoundRequest(byte[] b) throws Exception {
        super(1, 31);
        try {
            AdvanceByteBuffer buf = new AdvanceByteBuffer(b);
            this.password = buf.popCString(10);
            this.username = buf.popCString(10);
            this.serviceId = buf.popCString(10);
            this.type = buf.popByte();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public byte[] toBytes() throws Exception {
        AdvanceByteBuffer buf = new AdvanceByteBuffer();
        try {
            buf.appendByte(this.type);
            buf.appendCString(this.serviceId, 10);
            buf.appendCString(this.username, 10);
            buf.appendCString(this.password, 10);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return buf.array();
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public String debugString() {
        return "BoundRequest (ServiceId=" + this.serviceId + ", Username=" + this.username + ", Password=" + this.password + ")";
    }
}

