/*
 * Decompiled with CFR 0.152.
 */
package transport.tcp;

public class AdvanceByteBuffer {
    protected int capacity = 0;
    protected int size = 0;
    protected byte[] data = null;
    protected static final String ASCII = "ASCII";

    public AdvanceByteBuffer() {
        byte[] d = new byte[16];
        this.init0(d, 16, 0);
    }

    public AdvanceByteBuffer(int capacity) {
        byte[] d = new byte[capacity];
        this.init0(d, capacity, 0);
    }

    public AdvanceByteBuffer(byte[] data) {
        byte[] newdata = new byte[data.length];
        System.arraycopy(data, 0, newdata, 0, data.length);
        this.init0(newdata, newdata.length, newdata.length);
    }

    protected void init0(byte[] data, int capacity, int size) {
        this.data = data;
        this.size = size;
        this.capacity = capacity;
    }

    protected void span0(int numbyte) {
        int newcapacity;
        for (newcapacity = 2 * this.capacity + 1; newcapacity < this.capacity + numbyte; newcapacity *= 2) {
        }
        byte[] newdata = new byte[newcapacity];
        System.arraycopy(this.data, 0, newdata, 0, this.capacity);
        this.capacity = newcapacity;
        this.data = newdata;
    }

    public byte[] array() {
        byte[] res = new byte[this.size];
        System.arraycopy(this.data, 0, res, 0, this.size);
        return res;
    }

    public void appendInt(int i) {
        if (this.size + 4 > this.capacity) {
            this.span0(4);
        }
        this.data[this.size + 3] = (byte)(i & 0xFF);
        this.data[this.size + 2] = (byte)(i >>> 8 & 0xFF);
        this.data[this.size + 1] = (byte)(i >>> 16 & 0xFF);
        this.data[this.size + 0] = (byte)(i >>> 24 & 0xFF);
        this.size += 4;
    }

    public int popInt() {
        int res = 0;
        if (this.size < 4) {
            throw new IndexOutOfBoundsException("Size less than 4 bytes");
        }
        res |= this.data[this.size - 4] & 0xFF;
        res <<= 8;
        res |= this.data[this.size - 3] & 0xFF;
        res <<= 8;
        res |= this.data[this.size - 2] & 0xFF;
        res <<= 8;
        this.size -= 4;
        return res |= this.data[this.size - 1] & 0xFF;
    }

    public void appendShort(short i) {
        if (this.size + 2 > this.capacity) {
            this.span0(2);
        }
        this.data[this.size + 1] = (byte)(i & 0xFF);
        this.data[this.size + 0] = (byte)(i >>> 8 & 0xFF);
        this.size += 2;
    }

    public short popShort() {
        short res = 0;
        if (this.size < 2) {
            throw new IndexOutOfBoundsException("Size less than 2 bytes");
        }
        res = (short)(res | this.data[this.size - 2] & 0xFF);
        res = (short)(res << 8);
        res = (short)(res | this.data[this.size - 1] & 0xFF);
        this.size -= 2;
        return res;
    }

    public void appendByte(byte b) {
        if (this.size + 1 > this.capacity) {
            this.span0(1);
        }
        this.data[this.size++] = b;
    }

    public byte popByte() {
        if (this.size < 1) {
            throw new IndexOutOfBoundsException("Size less than 1 byte");
        }
        return this.data[--this.size];
    }

    public void appendBytes(byte[] b) {
        if (this.size + b.length > this.capacity) {
            this.span0(b.length);
        }
        System.arraycopy(b, 0, this.data, this.size, b.length);
        this.size += b.length;
    }

    public byte[] popBytes(int length) {
        if (length > this.size) {
            throw new IndexOutOfBoundsException("Size less than " + length + " bytes");
        }
        byte[] res = new byte[length];
        System.arraycopy(this.data, this.size - length, res, 0, length);
        this.size -= length;
        return res;
    }

    public void appendCString(String str, int length) {
        byte[] buf = new byte[length];
        try {
            byte[] bufstr = str.getBytes();
            System.arraycopy(bufstr, 0, buf, 0, length - 1 > bufstr.length ? bufstr.length : length - 1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.appendBytes(buf);
    }

    public String popCString(int length) {
        String res = null;
        byte[] buf = this.popBytes(length);
        int realSize = 0;
        for (realSize = length - 2; realSize >= 0 && buf[realSize] == 0; --realSize) {
        }
        byte[] bufReal = new byte[realSize + 1];
        System.arraycopy(buf, 0, bufReal, 0, realSize + 1);
        try {
            res = new String(bufReal);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return res;
    }

    public String debugString() {
        StringBuilder buf = new StringBuilder(" ");
        for (int i = 0; i < this.size; ++i) {
            buf.append((this.data[i] & 0xFF) < 16 ? "0" : "").append(Integer.toString(this.data[i] & 0xFF, 16)).append(' ');
        }
        return buf.toString();
    }

    public int getCapacitySize() {
        return this.capacity;
    }

    public int getInt(int pos) {
        if (pos + 4 > this.size) {
            throw new IndexOutOfBoundsException("Access out of range!");
        }
        int res = 0;
        res |= this.data[pos] & 0xFF;
        res <<= 8;
        res |= this.data[pos + 1] & 0xFF;
        res <<= 8;
        res |= this.data[pos + 2] & 0xFF;
        res <<= 8;
        return res |= this.data[pos + 3] & 0xFF;
    }

    public static void main(String[] args) throws Exception {
        AdvanceByteBuffer buf = new AdvanceByteBuffer();
        for (int i = 0; i < 50000; ++i) {
            buf.appendInt(i);
        }
        System.out.println(buf.size);
        System.out.println(buf.capacity);
    }
}

