/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import utils.ConfigLoader;

public class ConfigParser
extends ConfigLoader {
    public ConfigParser(String name) {
        super(name);
    }

    protected void onTag(String name) {
        this.logger.debug((Object)("onTag[" + name + "]"));
    }

    protected void onValue(String name, String value) {
        this.logger.debug((Object)("onValue[" + name + "=" + value + "]"));
    }

    protected void onValue(String name, String[] value) {
        this.logger.debug((Object)("onValues[" + name + "={" + ConfigParser.join(value, ",") + "}]"));
    }

    protected void onEndFile() {
        this.logger.debug((Object)"on EOF");
    }

    public void parser(String configFile) throws FileNotFoundException, IOException {
        FileReader f = null;
        BufferedReader r = null;
        try {
            f = new FileReader(configFile);
            r = new BufferedReader(f);
            while (true) {
                String str;
                if ((str = r.readLine()) == null) {
                    this.onEndFile();
                    return;
                }
                if (str.startsWith("#") || str.startsWith("//")) continue;
                if (str.startsWith("[") && str.endsWith("]")) {
                    int length = str.length() - 1;
                    if (length <= 1) continue;
                    this.onTag(str.substring(1, length));
                    continue;
                }
                if (str.indexOf("=", 0) <= 0 || str.indexOf("=", 0) >= str.length() - 1) continue;
                int i = str.indexOf(61);
                String name = str.substring(0, i).trim();
                String value = str.substring(i + 1).trim();
                if (value.startsWith("{") && value.endsWith("}")) {
                    value = ConfigParser.format(value.substring(1, value.length() - 1));
                    StringTokenizer token = new StringTokenizer(value, ",");
                    String[] values = new String[token.countTokens()];
                    i = 0;
                    while (token.hasMoreTokens()) {
                        values[i++] = token.nextToken();
                    }
                    this.onValue(name, values);
                    continue;
                }
                this.onValue(name, ConfigParser.format(value));
            }
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (IOException ex) {
                    this.logger.error((Object)("close buffer reader exception:" + ex));
                }
            }
            if (f != null) {
                try {
                    f.close();
                }
                catch (IOException ex) {
                    this.logger.error((Object)("close file reader exception:" + ex));
                }
            }
        }
    }
}

