/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import utils.ProcessThread;

public abstract class ProcessThreadMX
extends ProcessThread
implements DynamicMBean,
NotificationEmitter {
    public static final String TYPE = "process.status";
    protected String dClassName = this.getClass().getName();
    protected String dDescription;
    protected MBeanAttributeInfo[] dAttributes;
    protected MBeanConstructorInfo[] dConstructors;
    protected MBeanOperationInfo[] dOperations;
    protected MBeanNotificationInfo[] dNotifications;
    protected MBeanInfo dMBeanInfo;
    protected NotificationBroadcasterSupport notificationHandler;

    public ProcessThreadMX(String threadName) {
        super(threadName);
        this.buildDynamicMBeanInfo();
        this.notificationHandler = new NotificationBroadcasterSupport();
    }

    public void start() {
        super.start();
        Notification notification = new Notification(TYPE, (Object)this.getProcessStatus(), 0L, this.getThreadName() + " started");
        this.notificationHandler.sendNotification(notification);
    }

    public void stop() {
        super.stop();
        Notification notification = new Notification(TYPE, (Object)this.getProcessStatus(), 0L, this.getThreadName() + " stopped");
        this.notificationHandler.sendNotification(notification);
    }

    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.notificationHandler.removeNotificationListener(listener, filter, handback);
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        this.notificationHandler.addNotificationListener(listener, filter, handback);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return this.dNotifications;
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.notificationHandler.removeNotificationListener(listener);
    }

    protected void registerAgent(String objName) throws MalformedObjectNameException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        this.logger.info((Object)("register MBeanServer:" + objName));
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        ObjectName mbeanName = new ObjectName(objName);
        mbs.registerMBean(this, mbeanName);
    }

    protected void unregisterAgent(String objName) throws MalformedObjectNameException, InstanceNotFoundException, MBeanRegistrationException {
        this.logger.info((Object)("unregister MBeanServer:" + objName));
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        ObjectName mbeanName = new ObjectName(objName);
        mbs.unregisterMBean(mbeanName);
    }

    public Object getAttribute(String attribute_name) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (attribute_name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null"), "Cannot invoke a getter of " + this.dClassName + " with null attribute name");
        }
        if (attribute_name.equals("ThreadName")) {
            return this.getThreadName();
        }
        if (attribute_name.equals("Running")) {
            return this.isRunning();
        }
        if (attribute_name.equals("Status")) {
            return this.getProcessStatus();
        }
        if (attribute_name.equals("Priority")) {
            return this.getPriority();
        }
        throw new AttributeNotFoundException("Cannot find " + attribute_name + " attribute in " + this.dClassName);
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute cannot be null"), "Cannot invoke a setter of " + this.dClassName + " with null attribute");
        }
        String name = attribute.getName();
        Object value = attribute.getValue();
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null"), "Cannot invoke the setter of " + this.dClassName + " with null attribute name");
        }
        if (name.equals("Priority")) {
            try {
                if (!Class.forName("java.lang.Integer").isAssignableFrom(value.getClass())) {
                    throw new InvalidAttributeValueException("Cannot set attribute " + name + " to a " + value.getClass().getName() + " object, String expected");
                }
                this.setPriority((Integer)value);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        } else if (name.equals("ThreadName")) {
            try {
                if (!Class.forName("java.lang.String").isAssignableFrom(value.getClass())) {
                    throw new InvalidAttributeValueException("Cannot set attribute " + name + " to a " + value.getClass().getName() + " object, String expected");
                }
                this.setThreadName((String)value);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            if (name.equals("Running")) {
                throw new AttributeNotFoundException("Cannot set attribute " + name + " because it is read-only");
            }
            if (name.equals("Status")) {
                throw new AttributeNotFoundException("Cannot set attribute " + name + " because it is read-only");
            }
            throw new AttributeNotFoundException("Attribute " + name + " not found in " + this.getClass().getName());
        }
    }

    public AttributeList getAttributes(String[] attributeNames) {
        if (attributeNames == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("attributeNames[] cannot be null"), "Cannot invoke a getter of " + this.dClassName);
        }
        AttributeList resultList = new AttributeList();
        if (attributeNames.length == 0) {
            return resultList;
        }
        for (int i = 0; i < attributeNames.length; ++i) {
            try {
                Object value = this.getAttribute(attributeNames[i]);
                resultList.add(new Attribute(attributeNames[i], value));
                continue;
            }
            catch (AttributeNotFoundException e) {
                e.printStackTrace();
                continue;
            }
            catch (MBeanException e) {
                e.printStackTrace();
                continue;
            }
            catch (ReflectionException e) {
                e.printStackTrace();
            }
        }
        return resultList;
    }

    public AttributeList setAttributes(AttributeList attributes) {
        if (attributes == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("AttributeList attributes cannot be null"), "Cannot invoke a setter of " + this.dClassName);
        }
        AttributeList resultList = new AttributeList();
        if (attributes.isEmpty()) {
            return resultList;
        }
        for (Attribute attr : attributes) {
            try {
                this.setAttribute(attr);
                String name = attr.getName();
                Object value = this.getAttribute(name);
                resultList.add(new Attribute(name, value));
            }
            catch (AttributeNotFoundException e) {
                e.printStackTrace();
            }
            catch (InvalidAttributeValueException e) {
                e.printStackTrace();
            }
            catch (MBeanException e) {
                e.printStackTrace();
            }
            catch (ReflectionException e) {
                e.printStackTrace();
            }
        }
        return resultList;
    }

    public Object invoke(String operationName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (operationName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Operation name cannot be null"), "Cannot invoke a null operation in " + this.dClassName);
        }
        if (operationName.equals("start")) {
            this.start();
            return null;
        }
        if (operationName.equals("stop")) {
            this.stop();
            return null;
        }
        if (operationName.equals("restart")) {
            this.restart();
            return null;
        }
        if (operationName.equals("getInfor")) {
            return this.getInfor();
        }
        if (operationName.equals("setDump")) {
            Boolean b = (Boolean)params[0];
            this.setDumpThread(b);
            return null;
        }
        throw new ReflectionException(new NoSuchMethodException(operationName), "Cannot find the operation " + operationName + " in " + this.dClassName);
    }

    public MBeanInfo getMBeanInfo() {
        return this.dMBeanInfo;
    }

    protected MBeanAttributeInfo[] buildAttributes() {
        ArrayList<MBeanAttributeInfo> v = new ArrayList<MBeanAttributeInfo>();
        v.add(new MBeanAttributeInfo("ThreadName", "java.lang.String", "The name of thread", true, true, false));
        v.add(new MBeanAttributeInfo("Status", "java.lang.Integer", "The status of thread, 0 - running 1-stopping 2- stopped", true, false, false));
        v.add(new MBeanAttributeInfo("Running", "java.lang.Boolean", "The running status", true, false, true));
        v.add(new MBeanAttributeInfo("Priority", "java.lang.Integer", "Priority of thread value range 1-10", true, true, false));
        return v.toArray(new MBeanAttributeInfo[v.size()]);
    }

    protected MBeanOperationInfo[] buildOperations() {
        ArrayList<MBeanOperationInfo> v = new ArrayList<MBeanOperationInfo>();
        MBeanParameterInfo[] params = new MBeanParameterInfo[]{};
        v.add(new MBeanOperationInfo("start", "start service", params, "void", 1));
        v.add(new MBeanOperationInfo("stop", "stop service", params, "void", 1));
        v.add(new MBeanOperationInfo("restart", "stop service", params, "void", 1));
        v.add(new MBeanOperationInfo("getInfor", "get configuration information and runtime state of this service", params, "java.lang.String", 1));
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("dump", "java.lang.Boolean", "boolean value indicate track thread or not")};
        v.add(new MBeanOperationInfo("setDump", "set dumping status of current thread", params, "void", 1));
        return v.toArray(new MBeanOperationInfo[v.size()]);
    }

    protected MBeanConstructorInfo[] buildConstructors() {
        ArrayList<MBeanConstructorInfo> v = new ArrayList<MBeanConstructorInfo>();
        Constructor<?>[] constructors = this.getClass().getConstructors();
        if (constructors != null && constructors.length > 0) {
            v.add(new MBeanConstructorInfo("Constructs a service object", constructors[0]));
        }
        return v.toArray(new MBeanConstructorInfo[v.size()]);
    }

    protected MBeanNotificationInfo[] buildNotifications() {
        this.dNotifications = new MBeanNotificationInfo[1];
        this.dNotifications[0] = new MBeanNotificationInfo(new String[]{"Process Status"}, Notification.class.getName(), "notification when the status of process changed");
        return this.dNotifications;
    }

    protected void buildDynamicMBeanInfo() {
        this.dDescription = "The process which run in a separator thread";
        this.dAttributes = this.buildAttributes();
        this.dConstructors = this.buildConstructors();
        this.dOperations = this.buildOperations();
        this.dNotifications = this.buildNotifications();
        this.dMBeanInfo = new MBeanInfo(this.dClassName, this.dDescription, this.dAttributes, this.dConstructors, this.dOperations, this.dNotifications);
    }
}

