/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.blocks.MessageDispatcher;
import org.jgroups.blocks.RequestHandler;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.protocols.TP;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;
import org.jgroups.util.Util;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"stack-dependent"}, sequential=true)
public class MessageDispatcherUnitTest
extends ChannelTestBase {
    MessageDispatcher d1;
    MessageDispatcher d2;
    JChannel c1;
    JChannel c2;

    @BeforeClass
    protected void setUp() throws Exception {
        this.c1 = this.createChannel(true);
        this.c1.setName("A");
        GMS gms = (GMS)this.c1.getProtocolStack().findProtocol((Class<?>)GMS.class);
        if (gms != null) {
            gms.setPrintLocalAddress(false);
        }
        MessageDispatcherUnitTest.disableBundling(this.c1);
        this.d1 = new MessageDispatcher((Channel)this.c1, null, null, null);
        this.c1.connect("MessageDispatcherUnitTest");
    }

    @AfterClass
    protected void tearDown() throws Exception {
        this.d1.stop();
        this.c1.close();
        Util.sleep(500L);
    }

    @AfterMethod
    protected void closeSecondChannel() {
        if (this.c2 != null) {
            this.d2.stop();
            this.c2.close();
            Util.sleep(500L);
        }
    }

    public void testNullMessageToSelf() {
        MyHandler handler = new MyHandler(null);
        this.d1.setRequestHandler(handler);
        RspList rsps = this.d1.castMessage(null, new Message(), new RequestOptions(2, 0L));
        System.out.println("rsps:\n" + rsps);
        MessageDispatcherUnitTest.assertNotNull(rsps);
        Assert.assertEquals((int)1, (int)rsps.size());
        Object obj = rsps.getFirst();
        assert (obj == null);
    }

    public void test200ByteMessageToSelf() {
        this.sendMessage(200);
    }

    public void test2000ByteMessageToSelf() {
        this.sendMessage(2000);
    }

    public void test20000ByteMessageToSelf() {
        this.sendMessage(20000);
    }

    public void testNullMessageToAll() throws Exception {
        this.d1.setRequestHandler(new MyHandler(null));
        this.c2 = this.createChannel(this.c1);
        this.c2.setName("B");
        MessageDispatcherUnitTest.disableBundling(this.c2);
        long start = System.currentTimeMillis();
        this.d2 = new MessageDispatcher((Channel)this.c2, null, null, new MyHandler(null));
        long stop = System.currentTimeMillis();
        this.c2.connect("MessageDispatcherUnitTest");
        Assert.assertEquals((int)2, (int)this.c2.getView().size());
        System.out.println("view: " + this.c2.getView());
        System.out.println("casting message");
        start = System.currentTimeMillis();
        RspList rsps = this.d1.castMessage(null, new Message(), new RequestOptions(2, 0L));
        stop = System.currentTimeMillis();
        System.out.println("rsps:\n" + rsps);
        System.out.println("call took " + (stop - start) + " ms");
        MessageDispatcherUnitTest.assertNotNull(rsps);
        Assert.assertEquals((int)2, (int)rsps.size());
        Rsp rsp = rsps.get(this.c1.getAddress());
        MessageDispatcherUnitTest.assertNotNull(rsp);
        Object ret = rsp.getValue();
        assert (ret == null);
        rsp = rsps.get(this.c2.getAddress());
        MessageDispatcherUnitTest.assertNotNull(rsp);
        ret = rsp.getValue();
        assert (ret == null);
        Util.close((Channel)this.c2);
    }

    public void test200ByteMessageToAll() throws Exception {
        this.sendMessageToBothChannels(200);
    }

    public void test2000ByteMessageToAll() throws Exception {
        this.sendMessageToBothChannels(2000);
    }

    public void test20000ByteMessageToAll() throws Exception {
        this.sendMessageToBothChannels(20000);
    }

    private void sendMessage(int size) {
        MyHandler handler = new MyHandler(new byte[size]);
        this.d1.setRequestHandler(handler);
        long start = System.currentTimeMillis();
        RspList rsps = this.d1.castMessage(null, new Message(), new RequestOptions(2, 0L));
        long stop = System.currentTimeMillis();
        System.out.println("rsps:\n" + rsps);
        System.out.println("call took " + (stop - start) + " ms");
        MessageDispatcherUnitTest.assertNotNull(rsps);
        Assert.assertEquals((int)1, (int)rsps.size());
        byte[] buf = (byte[])rsps.getFirst();
        MessageDispatcherUnitTest.assertNotNull(buf);
        Assert.assertEquals((int)size, (int)buf.length);
    }

    private void sendMessageToBothChannels(int size) throws Exception {
        this.d1.setRequestHandler(new MyHandler(new byte[size]));
        this.c2 = this.createChannel(this.c1);
        this.c2.setName("B");
        MessageDispatcherUnitTest.disableBundling(this.c2);
        this.d2 = new MessageDispatcher((Channel)this.c2, null, null, new MyHandler(new byte[size]));
        this.c2.connect("MessageDispatcherUnitTest");
        Assert.assertEquals((int)2, (int)this.c2.getView().size());
        System.out.println("casting message");
        long start = System.currentTimeMillis();
        RspList rsps = this.d1.castMessage(null, new Message(), new RequestOptions(2, 0L));
        long stop = System.currentTimeMillis();
        System.out.println("rsps:\n" + rsps);
        System.out.println("call took " + (stop - start) + " ms");
        MessageDispatcherUnitTest.assertNotNull(rsps);
        Assert.assertEquals((int)2, (int)rsps.size());
        Rsp rsp = rsps.get(this.c1.getAddress());
        MessageDispatcherUnitTest.assertNotNull(rsp);
        byte[] ret = (byte[])rsp.getValue();
        Assert.assertEquals((int)size, (int)ret.length);
        rsp = rsps.get(this.c2.getAddress());
        MessageDispatcherUnitTest.assertNotNull(rsp);
        ret = (byte[])rsp.getValue();
        Assert.assertEquals((int)size, (int)ret.length);
        Util.close((Channel)this.c2);
    }

    private static void disableBundling(JChannel ch) {
        ProtocolStack stack = ch.getProtocolStack();
        TP transport = stack.getTransport();
        if (transport != null) {
            transport.setEnableBundling(false);
        }
    }

    private static class MyHandler
    implements RequestHandler {
        byte[] retval = null;

        public MyHandler(byte[] retval) {
            this.retval = retval;
        }

        @Override
        public Object handle(Message msg) {
            return this.retval;
        }
    }
}

