/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.jgroups.Address;
import org.jgroups.blocks.BasicConnectionTable;
import org.jgroups.blocks.ConnectionTableNIO;
import org.jgroups.stack.IpAddress;

public class ConnectionTableDemo_NIO
implements BasicConnectionTable.Receiver,
BasicConnectionTable.ConnectionListener {
    ConnectionTableNIO ct = null;
    String dst_host = null;
    int dst_port = 0;

    @Override
    public void receive(Address sender, byte[] data, int offset, int length) {
        String s = new String(data, offset, length);
        System.out.println("<-- " + s + " (from " + sender + ')');
    }

    @Override
    public void connectionOpened(Address peer_addr) {
        System.out.println("** Connection to " + peer_addr + " opened");
    }

    @Override
    public void connectionClosed(Address peer_addr) {
        System.out.println("** Connection to " + peer_addr + " closed");
    }

    public void start(int local_port, String dst_host, int dst_port, long reaper_interval, long conn_expire_time) throws Exception {
        this.ct = reaper_interval > 0L || conn_expire_time > 0L ? new ConnectionTableNIO(local_port, reaper_interval, conn_expire_time) : new ConnectionTableNIO(local_port);
        this.ct.addConnectionListener(this);
        this.dst_host = dst_host;
        this.dst_port = dst_port;
        IpAddress dest = new IpAddress(dst_host, dst_port);
        this.ct.setReceiver(this);
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        block2: while (true) {
            try {
                while (true) {
                    System.out.print("> ");
                    System.out.flush();
                    String line = in.readLine();
                    if (line == null || line.startsWith("quit".toLowerCase()) || line.startsWith("exit".toLowerCase())) break block2;
                    if (line.startsWith("conns")) {
                        System.out.println(this.ct);
                        continue;
                    }
                    byte[] data = line.getBytes();
                    this.ct.send(dest, data, 0, data.length);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
        this.ct.stop();
    }

    public static void main(String[] args) {
        String host = "localhost";
        int port = 6666;
        int local_port = 5555;
        long reaper_interval = 0L;
        long conn_expire_time = 0L;
        for (int i = 0; i < args.length; ++i) {
            String tmp = args[i];
            if ("-local_port".equals(tmp)) {
                local_port = Integer.parseInt(args[++i]);
                continue;
            }
            if ("-remote_host".equals(tmp)) {
                host = args[++i];
                continue;
            }
            if ("-remote_port".equals(tmp)) {
                port = Integer.parseInt(args[++i]);
                continue;
            }
            if ("-reaper_interval".equals(tmp)) {
                reaper_interval = Long.parseLong(args[++i]);
                continue;
            }
            if ("-conn_expire_time".equals(tmp)) {
                conn_expire_time = Long.parseLong(args[++i]);
                continue;
            }
            ConnectionTableDemo_NIO.help();
            return;
        }
        try {
            if (reaper_interval > 0L || conn_expire_time > 0L) {
                if (reaper_interval <= 0L) {
                    reaper_interval = 60000L;
                }
                if (conn_expire_time <= 0L) {
                    conn_expire_time = 300000L;
                }
                new ConnectionTableDemo_NIO().start(local_port, host, port, reaper_interval, conn_expire_time);
            } else {
                new ConnectionTableDemo_NIO().start(local_port, host, port, 0L, 0L);
            }
        }
        catch (Exception ex) {
            System.err.println("ConnectionTableTest_NIO.main(): " + ex);
            ex.printStackTrace();
        }
    }

    static void help() {
        System.out.println("ConnectionTableTest_NIO [-help] [-local_port <port>] [-remote_host <host>] [-remote_port <port>] [-reaper_interval <interval (msecs)>] [-conn_expire_time <time (msecs)>]");
    }
}

