/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.common;

import com.viettel.common.ViettelMsg;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OriginalViettelMsg
implements ViettelMsg {
    private static final long serialVersionUID = 20091403111400L;
    private static long MSG_ID;
    protected transient Hashtable<String, Object> properties;
    protected Hashtable<String, Object> fields;
    private transient long id = OriginalViettelMsg.getMsgIds();
    protected String clientId;
    protected long systemTrace;
    protected String command;
    protected Date transactionTime;
    protected String error;

    public OriginalViettelMsg() {
        this.properties = new Hashtable();
        this.fields = new Hashtable();
    }

    @Override
    public ViettelMsg getResponse() {
        OriginalViettelMsg response = new OriginalViettelMsg();
        response.setClientId(this.clientId);
        response.setSystemTrace(this.systemTrace);
        response.setCommand(this.command);
        response.setProperties(this.properties);
        return response;
    }

    private static final synchronized long getMsgIds() {
        if (MSG_ID == Long.MAX_VALUE) {
            MSG_ID = 0L;
        }
        return MSG_ID++;
    }

    @Override
    public void clearProperties() {
        this.properties.clear();
    }

    @Override
    public Enumeration<String> getPropertyKeys() {
        return this.properties.keys();
    }

    @Override
    public boolean hasProperty(String key) {
        return this.properties.containsKey(key);
    }

    @Override
    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    @Override
    public boolean setProperty(String key, Object value) {
        if (this.properties.containsKey(key)) {
            return false;
        }
        this.properties.put(key, value);
        return true;
    }

    @Override
    public void setProperties(Hashtable<String, Object> params) {
        this.properties.clear();
        this.properties.putAll(params);
    }

    public Hashtable<String, Object> getProperties() {
        Hashtable<String, Object> newTable = new Hashtable<String, Object>();
        newTable.putAll(this.properties);
        return newTable;
    }

    public void setFields(Hashtable<String, Object> params) {
        this.fields.clear();
        this.fields.putAll(params);
    }

    public Hashtable<String, Object> getFields() {
        Hashtable<String, Object> newTable = new Hashtable<String, Object>();
        newTable.putAll(this.fields);
        return newTable;
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        if (MSG_ID == Long.MAX_VALUE) {
            MSG_ID = 0L;
        }
        this.id = MSG_ID++;
        this.properties = new Hashtable();
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Override
    public String getCommand() {
        return this.command;
    }

    @Override
    public void setCommand(String val) {
        this.command = val;
    }

    @Override
    public long getSystemTrace() {
        return this.systemTrace;
    }

    @Override
    public void setSystemTrace(long systemTrace) {
        this.systemTrace = systemTrace;
    }

    @Override
    public Enumeration<String> getKeys() {
        return this.fields.keys();
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public Date getTransactionTime() {
        if (this.transactionTime != null) {
            return new Date(this.transactionTime.getTime());
        }
        return new Date();
    }

    @Override
    public void setTransactionTime(Date date) {
        if (date != null) {
            if (this.transactionTime != null) {
                this.transactionTime.setTime(date.getTime());
            } else {
                this.transactionTime = new Date(date.getTime());
            }
        }
    }

    @Override
    public String getError() {
        return this.error;
    }

    @Override
    public void setError(String error) {
        this.error = error;
    }

    @Override
    public void set(String name, Object val) {
        if (val != null) {
            this.fields.put(name, val);
        }
    }

    public void remove(String name) {
        if (name != null) {
            this.fields.remove(name);
        }
    }

    @Override
    public Object get(String name) {
        return this.fields.get(name);
    }

    public String get(String[] names) {
        String mp = "None";
        for (int i = 0; i < names.length; ++i) {
            String value = (String)this.get(names[i]);
            if (value == null) continue;
            mp = value;
            break;
        }
        return mp;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("<Original Id=" + this.id);
        buff.append(",SystemTrace=" + this.systemTrace);
        if (this.clientId != null) {
            buff.append(", ClientId=" + this.clientId);
        }
        if (this.command != null) {
            buff.append(", Command=" + this.command);
        }
        buff.append('>');
        buff.append("\r\n\t<Transaction Time>" + this.getTransactionTime() + "</Transaction Time>");
        if (this.error != null) {
            buff.append("\r\n\t<Error>" + this.error + "</Error>");
        }
        if (this.fields.size() > 0) {
            Enumeration<String> e = this.getKeys();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                Object value = this.get(key);
                if (key == null || value == null) continue;
                buff.append("\r\n\t<" + key + ">" + value + "<" + key + "/>");
            }
        }
        buff.append("\r\n</Original>");
        return buff.toString();
    }
}

