/*
 * Decompiled with CFR 0.152.
 */
package filter;

import filter.ServiceFilter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Vector;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import org.apache.log4j.Logger;
import transport.message.Request;
import transport.message.Response;
import transport.message.ServiceMessage;
import utils.ConnectionException;
import utils.DataStores;
import utils.LoadableAgentMX;
import vasp.utils.CommandUtils;
import vasp.utils.VaspUtils;

public class BlackList
extends LoadableAgentMX
implements ServiceFilter {
    private Vector<Record> list;
    private Logger logger = Logger.getLogger((String)"BlackList");

    public BlackList() {
        this.list = new Vector();
        this.reload();
        try {
            this.registerAgent("smsws.gateway:type=Events,name=BlackList");
        }
        catch (MalformedObjectNameException ex) {
            this.logger.error((Object)"register service agent error");
            this.logger.error((Object)("exception:" + ex.toString()));
        }
        catch (InstanceAlreadyExistsException ex) {
            this.logger.error((Object)"register service agent error");
            this.logger.error((Object)("exception:" + ex.toString()));
        }
        catch (MBeanRegistrationException ex) {
            this.logger.error((Object)"register service agent error");
            this.logger.error((Object)("exception:" + ex.toString()));
        }
        catch (NotCompliantMBeanException ex) {
            this.logger.error((Object)"register service agent error");
            this.logger.error((Object)("exception:" + ex.toString()));
        }
    }

    private void addRecord(String msisdn, String serviceId) {
        msisdn = VaspUtils.formatMobile(msisdn);
        for (Record record : this.list) {
            if (!record.equals(msisdn, serviceId)) continue;
            return;
        }
        this.list.addElement(new Record(msisdn, serviceId.toUpperCase(Locale.getDefault())));
    }

    @Override
    public String getName() {
        return "blacklist";
    }

    @Override
    public String getInfor() {
        StringBuffer buff = new StringBuffer(CommandUtils.format("Msisdn", 1, 16) + CommandUtils.format("Service", 1, 16));
        for (Record r : this.list) {
            buff.append("\r\n(" + r.toString() + ")");
        }
        return buff.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reload() {
        ResultSet rs = null;
        try {
            if (!DataStores.isInstanced()) {
                this.logger.warn((Object)"the DataStore hasn't instanced");
                return;
            }
            this.list.clear();
            String sql = "select msisdn,service from blacklist where subcriber_type=1";
            rs = DataStores.doQuery((String)sql);
            this.logger.info((Object)sql);
            while (rs.next()) {
                String msisdn = rs.getString("msisdn");
                String service = rs.getString("service");
                this.addRecord(msisdn, service);
            }
            rs.close();
        }
        catch (ConnectionException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    @Override
    public void destroy() {
        try {
            this.unregisterAgent("smsws.gateway:type=Events,name=BlackList");
        }
        catch (MalformedObjectNameException ex) {
            this.logger.info((Object)("unregister agent error:" + ex.toString()));
            this.logger.error((Object)("exception:" + ex.toString()));
        }
        catch (InstanceNotFoundException ex) {
            this.logger.info((Object)("unregister agent error:" + ex.toString()));
            this.logger.error((Object)("exception:" + ex.toString()));
        }
        catch (MBeanRegistrationException ex) {
            this.logger.info((Object)("unregister agent error:" + ex.toString()));
            this.logger.error((Object)("exception:" + ex.toString()));
        }
    }

    @Override
    public String filter(ServiceMessage message) {
        if (message instanceof Request) {
            String msisdn = message.getSender();
            String serviceId = ((Request)message).getServiceId();
            for (Record record : this.list) {
                if (!record.equals(msisdn, serviceId)) continue;
                return "Ignore";
            }
            return "Ok";
        }
        if (message instanceof Response) {
            String msisdn = message.getReceiver();
            String serviceId = ((Response)message).getServiceId();
            for (Record record : this.list) {
                if (!record.equals(msisdn, serviceId)) continue;
                return "Ignore";
            }
            return "Ok";
        }
        return "Ok";
    }

    static class Record {
        public String msisdn;
        public String serviceId;

        public Record(String msisdn, String serviceId) {
            this.msisdn = msisdn;
            this.serviceId = serviceId;
        }

        public boolean equals(String mobile, String serviceId) {
            return this.msisdn != null && this.msisdn.equalsIgnoreCase(mobile) && this.serviceId != null && (this.serviceId.equalsIgnoreCase(serviceId) || this.serviceId.equalsIgnoreCase("ALL"));
        }

        public String toString() {
            return CommandUtils.format(this.msisdn, 1, 16) + CommandUtils.format(this.serviceId, 1, 16);
        }
    }
}

