/*
 * Decompiled with CFR 0.152.
 */
package utils;

import org.apache.log4j.Logger;
import org.nfunk.jep.JEP;

public class Rule {
    protected String expression;
    protected Logger logger;
    protected JEP parser;

    public Rule() {
        this.logger = Logger.getLogger((String)"Rule");
        this.parser = new JEP();
        this.parser.addStandardFunctions();
        this.parser.addStandardConstants();
    }

    public Rule(String logName) {
        this.logger = Logger.getLogger((String)logName);
        this.parser = new JEP();
        this.parser.addStandardFunctions();
        this.parser.addStandardConstants();
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.logger.debug((Object)("expression=" + expression));
        this.expression = expression;
    }

    public void setVariable(String name, Object value) {
        this.logger.debug((Object)("add variable (" + name + "=" + value.toString() + ")"));
        this.parser.addVariable(name, value);
    }

    public boolean parser() {
        this.logger.debug((Object)"begin parsing rule");
        this.logger.debug((Object)("expression:" + this.expression));
        try {
            this.parser.parseExpression(this.expression);
        }
        catch (Exception ex) {
            this.logger.error((Object)"exception when try to parse expression.", (Throwable)ex);
            return false;
        }
        if (this.parser.hasError()) {
            this.logger.debug((Object)"Error while parsing, return false");
            this.logger.debug((Object)this.expression);
            return false;
        }
        double value = this.parser.getValue();
        this.logger.debug((Object)("parse rule result =" + value));
        return value == 1.0;
    }
}

