/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDriver;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.log4j.Logger;
import utils.ConnectionException;
import utils.DataSource;
import utils.Param;
import utils.ParamList;

public class DataStores {
    public static final int BUFSIZE = 1024;
    static Logger logger = Logger.getLogger((String)"DataStores");
    static Connection connection;
    static Statement stmt;
    static boolean pooling;
    static String driver;
    static String cnString;
    static String username;
    static String password;
    static String sqlcheck;
    static boolean instanced;
    static final Object lock;

    private DataStores() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(String configFile) throws Exception {
        FileReader r = null;
        try {
            r = new FileReader(configFile);
            Properties properties = new Properties();
            properties.load(r);
            r.close();
            String dbdriver = properties.getProperty("driver");
            String dbconnStr = properties.getProperty("connection");
            String dbusername = properties.getProperty("username");
            String dbpassword = properties.getProperty("password");
            String dbsqlcheck = properties.getProperty("sqlcheck", "select 1 from dual");
            boolean dbpooling = "true".equals(properties.getProperty("pooling", "false"));
            DataStores.init(dbdriver, dbconnStr, dbusername, dbpassword, dbsqlcheck, dbpooling);
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (IOException ex) {
                    logger.error((Object)("close buffer reader exception:" + ex));
                }
            }
        }
    }

    public static void init(Properties properties) throws Exception {
        String dbdriver = properties.getProperty("driver");
        String dbconnStr = properties.getProperty("connection");
        String dbusername = properties.getProperty("username");
        String dbpassword = properties.getProperty("password");
        String dbsqlcheck = properties.getProperty("sqlcheck", "select 1 from dual");
        boolean dbpooling = "true".equals(properties.getProperty("pooling", "false"));
        DataStores.init(dbdriver, dbconnStr, dbusername, dbpassword, dbsqlcheck, dbpooling);
    }

    public static void init(String driver, String cnString, String username, String password, String sqlcheck) throws Exception {
        DataStores.init(driver, cnString, username, password, sqlcheck, false);
    }

    public static void init(String driver, String cnString, String username, String password, String sqlcheck, boolean pooling) throws Exception {
        if (instanced) {
            logger.info((Object)"the DataStore has been instanced");
            return;
        }
        try {
            DataStores.driver = driver;
            DataStores.pooling = pooling;
            DataStores.cnString = cnString;
            DataStores.username = username;
            DataStores.password = password;
            DataStores.sqlcheck = sqlcheck;
            logger.info((Object)("instance driver:" + driver));
            Class.forName(driver);
            if (pooling) {
                logger.info((Object)"instance pool");
                DataStores.instancePool(cnString, username, password);
            }
            instanced = true;
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            instanced = false;
            throw e;
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            instanced = false;
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reload(String cnString, String username, String password, boolean pooling) {
        Object object = lock;
        synchronized (object) {
            if (!(DataStores.cnString.equals(cnString) && DataStores.username.equals(username) && DataStores.password.equals(password))) {
                DataStores.cnString = cnString;
                DataStores.username = username;
                DataStores.password = password;
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException ex) {
                        logger.error((Object)ex.getMessage(), (Throwable)ex);
                    }
                    finally {
                        connection = null;
                    }
                }
                if (DataStores.pooling) {
                    try {
                        PoolingDriver poolDriver = (PoolingDriver)DriverManager.getDriver("jdbc:apache:commons:dbcp:");
                        if (poolDriver != null) {
                            poolDriver.closePool("pool");
                        }
                    }
                    catch (SQLException ex) {
                        logger.error((Object)ex.getMessage(), (Throwable)ex);
                    }
                }
            }
            DataStores.pooling = pooling;
            if (pooling) {
                try {
                    DataStores.instancePool(cnString, username, password);
                }
                catch (ClassNotFoundException ex) {
                    logger.error((Object)ex.getMessage(), (Throwable)ex);
                }
                catch (SQLException ex) {
                    logger.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        }
    }

    private static void instancePool(String cnString, String username, String password) throws ClassNotFoundException, SQLException {
        GenericObjectPool connectionPool = new GenericObjectPool(null, 10);
        DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(cnString, username, password);
        new PoolableConnectionFactory((ConnectionFactory)connectionFactory, (ObjectPool)connectionPool, null, null, false, true);
        Class.forName("org.apache.commons.dbcp.PoolingDriver");
        PoolingDriver drivers = (PoolingDriver)DriverManager.getDriver("jdbc:apache:commons:dbcp:");
        drivers.registerPool("pool", (ObjectPool)connectionPool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroy() {
        Object object = lock;
        synchronized (object) {
            try {
                if (stmt != null) {
                    logger.info((Object)"close statement");
                    stmt.close();
                }
            }
            catch (SQLException ex) {
                logger.error((Object)("close statement error:" + ex.getMessage()));
            }
            try {
                if (connection != null) {
                    logger.info((Object)"close connection");
                    connection.close();
                }
            }
            catch (SQLException ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
            try {
                if (pooling) {
                    logger.info((Object)"close connection pool");
                    PoolingDriver poolDriver = (PoolingDriver)DriverManager.getDriver("jdbc:apache:commons:dbcp:");
                    poolDriver.closePool("pool");
                }
            }
            catch (SQLException ex) {
                logger.error((Object)("close pool exception: " + ex.getMessage()));
            }
            instanced = false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int doUpdate(String sql) throws SQLException, ConnectionException {
        DataStores.check();
        Object object = lock;
        synchronized (object) {
            logger.debug((Object)sql);
            Statement cstmt = null;
            SQLException exception = null;
            if (connection == null) {
                logger.info((Object)"the connection is null, create connection");
                connection = DataStores.connection();
            }
            try {
                cstmt = connection.createStatement();
                int r = cstmt.executeUpdate(sql);
                cstmt.close();
                int n = r;
                return n;
            }
            catch (SQLException e) {
                logger.error((Object)"update database error");
                exception = e;
                throw e;
            }
            finally {
                if (cstmt != null) {
                    try {
                        logger.info((Object)"close open statement");
                        cstmt.close();
                    }
                    catch (SQLException ex) {
                        logger.error((Object)("close statement error:" + ex));
                    }
                }
                if (exception != null) {
                    logger.info((Object)"validate the connection now, may be it has been closed");
                    DataStores.validate();
                }
            }
        }
    }

    public static ResultSet doQuery(String sql) throws SQLException, ConnectionException {
        DataStores.check();
        Object object = lock;
        synchronized (object) {
            logger.debug((Object)sql);
            if (connection == null) {
                logger.info((Object)"the connection is null, create connection");
                connection = DataStores.connection();
            }
            try {
                return stmt.executeQuery(sql);
            }
            catch (SQLException e) {
                logger.error((Object)"execute query error");
                logger.info((Object)"validate the connection now, may be it has been closed");
                DataStores.validate();
                throw e;
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static DataSource[] retrieveData(ParamList param, String table) throws SQLException, IOException, ConnectionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 1[TRYBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int updateData(ParamList param, String table) throws SQLException, IOException, ConnectionException {
        DataStores.check();
        Object object = lock;
        synchronized (object) {
            int i;
            if (param == null || param.size() == 0) {
                return 0;
            }
            Param[] pin = param.paramIn();
            Param[] pout = param.paramOut();
            if (pout == null || pout.length == 0) {
                return 0;
            }
            StringBuffer bufsql = new StringBuffer();
            bufsql.append("UPDATE ");
            bufsql.append(table);
            bufsql.append(" SET ");
            for (i = 0; i < pout.length; ++i) {
                bufsql.append(pout[i].getName());
                bufsql.append('=');
                if (pout[i].getDatatype().equals("string")) {
                    bufsql.append('\'');
                    bufsql.append(pout[i].getValue());
                    bufsql.append('\'');
                } else {
                    bufsql.append(pout[i].getValue());
                }
                if (i == pout.length - 1) continue;
                bufsql.append(',');
            }
            if (pin != null && pin.length > 0) {
                bufsql.append(" WHERE ");
                for (i = 0; i < pin.length; ++i) {
                    bufsql.append(pin[i].getName());
                    bufsql.append('=');
                    if (pin[i].getDatatype().equals("string")) {
                        bufsql.append('\'');
                        bufsql.append(pin[i].getValue());
                        bufsql.append('\'');
                    } else {
                        bufsql.append(pin[i].getValue());
                    }
                    if (i == pin.length - 1) continue;
                    bufsql.append(" AND ");
                }
            }
            String sql = bufsql.toString();
            return DataStores.doUpdate(sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int insertData(ParamList param, String table) throws SQLException, IOException, ConnectionException {
        DataStores.check();
        Object object = lock;
        synchronized (object) {
            int i;
            if (param == null || param.size() == 0) {
                return 0;
            }
            Param[] pout = param.paramOut();
            if (pout == null || pout.length == 0) {
                return 0;
            }
            StringBuffer bufsql = new StringBuffer();
            bufsql.append("INSERT INTO ");
            bufsql.append(table);
            bufsql.append('(');
            for (i = 0; i < pout.length; ++i) {
                bufsql.append(pout[i].getName());
                if (i == pout.length - 1) continue;
                bufsql.append(',');
            }
            bufsql.append(") VALUES (");
            for (i = 0; i < pout.length; ++i) {
                if (pout[i].getDatatype().equals("string")) {
                    bufsql.append('\'');
                    bufsql.append(pout[i].getValue());
                    bufsql.append('\'');
                } else {
                    bufsql.append(pout[i].getValue());
                }
                if (i == pout.length - 1) continue;
                bufsql.append(',');
            }
            bufsql.append(')');
            String sql = bufsql.toString();
            return DataStores.doUpdate(sql);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int insertData(ParamList[] param, String table) throws SQLException, IOException, ConnectionException {
        DataStores.check();
        Object object = lock;
        synchronized (object) {
            if (param == null || param.length == 0) {
                return 0;
            }
            if (connection == null) {
                logger.info((Object)"the connection is null, create connection");
                connection = DataStores.connection();
            }
            Statement pstmt = null;
            SQLException exception = null;
            try {
                StringBuffer bufsql = new StringBuffer();
                StringBuffer bufvl = new StringBuffer();
                bufsql.append("INSERT INTO ");
                bufsql.append(table);
                bufsql.append('(');
                bufvl.append(") VALUES (");
                for (int i = 0; i < param[0].size(); ++i) {
                    bufsql.append(param[0].allParam()[i].getName());
                    bufvl.append('?');
                    if (i == param[0].size() - 1) continue;
                    bufsql.append(',');
                    bufvl.append(',');
                }
                bufvl.append(')');
                bufsql.append(bufvl);
                String sql = bufsql.toString();
                logger.debug((Object)sql);
                pstmt = connection.prepareStatement(sql);
                ParamList[] arr$ = param;
                int len$ = arr$.length;
                int i$ = 0;
                while (true) {
                    block27: {
                        Param[] pout;
                        block28: {
                            block26: {
                                if (i$ >= len$) break block26;
                                ParamList p = arr$[i$];
                                pout = p.paramOut();
                                if (pout == null || pout.length == 0) break block27;
                                break block28;
                            }
                            int result = pstmt.executeBatch().length;
                            pstmt.close();
                            int n = result;
                            return n;
                        }
                        for (int i = 1; i <= pout.length; ++i) {
                            String type = pout[i - 1].getDatatype();
                            Object value = pout[i - 1].getValue();
                            if (type.equals("byte")) {
                                pstmt.setByte(i, (Byte)value);
                                continue;
                            }
                            if (type.equals("short")) {
                                pstmt.setShort(i, (Short)value);
                                continue;
                            }
                            if (type.equals("int")) {
                                pstmt.setInt(i, (Integer)value);
                                continue;
                            }
                            if (type.equals("long")) {
                                pstmt.setLong(i, (Long)value);
                                continue;
                            }
                            if (type.equals("float")) {
                                pstmt.setFloat(i, ((Float)value).floatValue());
                                continue;
                            }
                            if (type.equals("double")) {
                                pstmt.setDouble(i, (Double)value);
                                continue;
                            }
                            if (type.equals("boolean")) {
                                pstmt.setBoolean(i, (Boolean)value);
                                continue;
                            }
                            if (type.equals("date")) {
                                pstmt.setDate(i, (Date)value);
                                continue;
                            }
                            if (!type.equals("string")) continue;
                            pstmt.setString(i, (String)value);
                        }
                        pstmt.addBatch();
                    }
                    ++i$;
                }
            }
            catch (SQLException e) {
                logger.error((Object)"insert data error");
                exception = e;
                throw e;
            }
            finally {
                if (pstmt != null) {
                    try {
                        logger.info((Object)"close open prepare statement");
                        pstmt.close();
                    }
                    catch (SQLException ex) {
                        logger.error((Object)("close statement error:" + ex));
                    }
                }
                if (exception != null) {
                    logger.info((Object)"validate the connection now, may be it has been closed");
                    DataStores.validate();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection getConnection() throws SQLException, ConnectionException {
        logger.info((Object)"get connection from DataStore");
        DataStores.check();
        Object object = lock;
        synchronized (object) {
            if (DataStores.isPooling()) {
                logger.info((Object)"return connection from pool");
                return DriverManager.getConnection("jdbc:apache:commons:dbcp:pool");
            }
            return DataStores.check(connection) ? connection : DataStores.connection();
        }
    }

    public static void connect() throws ConnectionException {
        DataStores.connection();
    }

    private static Connection connection() throws ConnectionException {
        try {
            logger.info((Object)"create new connetion");
            logger.info((Object)("connection url: " + cnString));
            logger.info((Object)"connecting ...");
            connection = DriverManager.getConnection(cnString, username, password);
            stmt = connection.createStatement();
            logger.info((Object)"connected");
            return connection;
        }
        catch (SQLException ex) {
            logger.error((Object)"create connection error");
            connection = null;
            throw new ConnectionException(ex.getMessage(), cnString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean check(Connection conn) {
        if (conn != null) {
            Statement cstmt = null;
            try {
                logger.info((Object)"check connection");
                logger.debug((Object)sqlcheck);
                cstmt = conn.createStatement();
                cstmt.executeQuery(sqlcheck);
                logger.info((Object)"connection is ok");
                cstmt.close();
                cstmt = null;
                boolean bl = true;
                return bl;
            }
            catch (SQLException ex) {
                logger.info((Object)("connection is broken down:" + ex));
                boolean bl = false;
                return bl;
            }
            finally {
                if (cstmt != null) {
                    try {
                        cstmt.close();
                    }
                    catch (SQLException ex) {}
                }
            }
        }
        return false;
    }

    private static void check() throws ConnectionException {
        if (!instanced) {
            throw new ConnectionException("the DataStore hasn't been instanced", cnString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void validate() {
        Object object = lock;
        synchronized (object) {
            if (connection != null) {
                try {
                    logger.info((Object)"check connection");
                    logger.debug((Object)sqlcheck);
                    stmt.executeQuery(sqlcheck);
                    logger.info((Object)"connection is ok");
                }
                catch (SQLException ex) {
                    logger.error((Object)("check connection error:" + ex.toString()));
                    logger.error((Object)"the connection has been broken down, set it to null to recreate");
                    connection = null;
                }
            }
        }
    }

    public static boolean isPooling() {
        return pooling;
    }

    public static boolean isInstanced() {
        return instanced;
    }

    public static boolean isConnected() {
        return DataStores.isInstanced() && connection != null;
    }

    public static void setLogger(Logger logger) {
        DataStores.logger = logger;
    }

    static {
        lock = new Object();
    }
}

