/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.telnetd.net;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.text.MessageFormat;
import java.util.Properties;
import net.wimpi.telnetd.BootException;
import net.wimpi.telnetd.net.ConnectionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PortListener
implements Runnable {
    private static Log log = LogFactory.getLog(PortListener.class);
    private String m_Name;
    private int m_Port;
    private int m_FloodProtection;
    private ServerSocket m_ServerSocket = null;
    private Thread m_Thread;
    private ConnectionManager m_ConnectionManager;
    private boolean m_Stopping = false;
    private boolean m_Available;
    private static final String logmsg = "Listening to Port {0,number,integer} with a connectivity queue size of {1,number,integer}.";

    private PortListener(String name, int port, int floodprot) {
        this.m_Name = name;
        this.m_Available = false;
        this.m_Port = port;
        this.m_FloodProtection = floodprot;
    }

    public String getName() {
        return this.m_Name;
    }

    public boolean isAvailable() {
        return this.m_Available;
    }

    public void setAvailable(boolean b) {
        this.m_Available = b;
    }

    public void start() {
        log.debug((Object)"start()");
        this.m_Thread = new Thread(this);
        this.m_Thread.setName("telnet_listener");
        this.m_Thread.start();
        this.m_Available = true;
    }

    public void stop() {
        log.debug((Object)("stop()::" + this.toString()));
        this.m_Stopping = true;
        this.m_Available = false;
        this.m_ConnectionManager.stop();
        try {
            this.m_ServerSocket.close();
        }
        catch (IOException ex) {
            log.error((Object)"stop()", (Throwable)ex);
        }
        try {
            this.m_Thread.join();
        }
        catch (InterruptedException iex) {
            log.error((Object)"stop()", (Throwable)iex);
        }
        log.info((Object)("stop()::Stopped " + this.toString()));
    }

    public void run() {
        try {
            this.m_ServerSocket = new ServerSocket(this.m_Port, this.m_FloodProtection);
            Object[] args = new Object[]{new Integer(this.m_Port), new Integer(this.m_FloodProtection)};
            log.info((Object)MessageFormat.format(logmsg, args));
            do {
                try {
                    Socket s = this.m_ServerSocket.accept();
                    if (this.m_Available) {
                        this.m_ConnectionManager.makeConnection(s);
                        continue;
                    }
                    s.close();
                }
                catch (SocketException ex) {
                    if (this.m_Stopping) {
                        log.debug((Object)"run(): ServerSocket closed by stop()");
                        continue;
                    }
                    log.error((Object)"run()", (Throwable)ex);
                }
            } while (!this.m_Stopping);
        }
        catch (IOException e) {
            log.error((Object)"run()", (Throwable)e);
        }
        log.debug((Object)"run(): returning.");
    }

    public ConnectionManager getConnectionManager() {
        return this.m_ConnectionManager;
    }

    public static PortListener createPortListener(String name, Properties settings) throws BootException {
        PortListener pl = null;
        try {
            int port = Integer.parseInt(settings.getProperty(name + ".port"));
            int floodprot = Integer.parseInt(settings.getProperty(name + ".floodprotection"));
            if (new Boolean(settings.getProperty(name + ".secure")).booleanValue()) {
                // empty if block
            }
            pl = new PortListener(name, port, floodprot);
        }
        catch (Exception ex) {
            log.error((Object)"createPortListener()", (Throwable)ex);
            throw new BootException("Failure while creating PortListener instance:\n" + ex.getMessage());
        }
        if (pl.m_ConnectionManager == null) {
            pl.m_ConnectionManager = ConnectionManager.createConnectionManager(name, settings);
            try {
                pl.m_ConnectionManager.start();
            }
            catch (Exception exc) {
                log.error((Object)"createPortListener()", (Throwable)exc);
                throw new BootException("Failure while starting ConnectionManager watchdog thread:\n" + exc.getMessage());
            }
        }
        return pl;
    }
}

