/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.telnetd.io.toolkit;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Vector;
import net.wimpi.telnetd.io.BasicTerminalIO;
import net.wimpi.telnetd.io.toolkit.Statusbar;

public class Pager {
    private BasicTerminalIO m_IO;
    private StringReader m_Source;
    private String m_Prompt;
    private int m_StopKey;
    private Vector m_Chunks;
    private int m_ChunkPos;
    private int m_LastNewChunk;
    private boolean m_EOS;
    private int m_TermRows;
    private int m_TermCols;
    private boolean m_NoPrompt;
    private boolean m_ShowPos;
    private Statusbar m_Status;
    private static final char DEFAULT_STOPKEY = 's';
    private static final String DEFAULT_PROMPT = "[Cursor Up,Cursor Down,Space,s (stop)] ";
    private static final int SPACE = 32;

    public Pager(BasicTerminalIO io) {
        this.m_IO = io;
        this.setPrompt(DEFAULT_PROMPT);
        this.setStopKey('s');
        this.m_TermRows = this.m_IO.getRows();
        this.m_TermCols = this.m_IO.getColumns();
        this.m_Status = new Statusbar(this.m_IO, "Pager Status");
        this.m_Status.setAlignment(2);
    }

    public Pager(BasicTerminalIO io, String prompt, char stopKey) {
        this.m_IO = io;
        this.setPrompt(prompt);
        this.m_StopKey = stopKey;
        this.m_TermRows = this.m_IO.getRows();
        this.m_TermCols = this.m_IO.getColumns();
        this.m_Status.setAlignment(2);
    }

    public void setStopKey(char key) {
        this.m_StopKey = key;
    }

    public void setPrompt(String prompt) {
        this.m_Prompt = prompt;
    }

    private void updateStatus() {
        if (this.m_ShowPos) {
            this.m_Status.setStatusText(this.m_Prompt + " [" + (this.m_ChunkPos + 1) + "/" + this.m_Chunks.size() + "]");
        } else {
            this.m_Status.setStatusText(this.m_Prompt);
        }
    }

    public void setShowPosition(boolean b) {
        this.m_ShowPos = b;
    }

    public void page(String str) throws IOException {
        this.terminalGeometryChanged();
        boolean autoflush = this.m_IO.isAutoflushing();
        this.m_IO.setAutoflushing(true);
        this.m_Source = new StringReader(str);
        this.m_ChunkPos = 0;
        this.m_LastNewChunk = 0;
        this.m_EOS = false;
        this.m_NoPrompt = false;
        this.renderChunks();
        if (this.m_Chunks.size() == 1) {
            this.m_IO.write((String)this.m_Chunks.elementAt(0));
        } else {
            this.m_IO.homeCursor();
            this.m_IO.eraseScreen();
            this.m_IO.write((String)this.m_Chunks.elementAt(this.m_ChunkPos));
            this.updateStatus();
            this.m_Status.draw();
            int in = 0;
            block7: do {
                this.m_NoPrompt = false;
                in = this.m_IO.read();
                if (this.terminalGeometryChanged()) {
                    try {
                        this.m_Source.reset();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    this.renderChunks();
                    this.m_ChunkPos = 0;
                    this.m_LastNewChunk = 0;
                    this.m_EOS = false;
                    this.m_NoPrompt = false;
                    this.m_IO.homeCursor();
                    this.m_IO.eraseScreen();
                    this.m_IO.write((String)this.m_Chunks.elementAt(this.m_ChunkPos));
                    this.updateStatus();
                    this.m_Status.draw();
                    continue;
                }
                switch (in) {
                    case 1001: {
                        this.drawPreviousPage();
                        break;
                    }
                    case 1002: {
                        this.drawNextPage();
                        break;
                    }
                    case 32: {
                        this.drawNextPage();
                        break;
                    }
                    default: {
                        if (in == this.m_StopKey) {
                            in = -1;
                            continue block7;
                        }
                        this.m_IO.bell();
                        continue block7;
                    }
                }
                if (this.m_EOS) {
                    in = -1;
                    continue;
                }
                if (this.m_NoPrompt) continue;
                this.updateStatus();
                this.m_Status.draw();
            } while (in != -1);
            this.m_IO.eraseToEndOfLine();
        }
        this.m_IO.write("\n");
        this.m_Source.close();
        this.m_IO.setAutoflushing(autoflush);
    }

    public void page(InputStream in) throws IOException {
        StringBuffer inbuf = new StringBuffer(3060);
        int b = 0;
        while (b != -1) {
            b = in.read();
            if (b == -1) continue;
            inbuf.append((char)b);
        }
        this.page(inbuf.toString());
    }

    private void drawNextPage() throws IOException {
        if (this.m_ChunkPos == this.m_LastNewChunk) {
            this.drawNewPage();
        } else {
            this.m_IO.homeCursor();
            this.m_IO.eraseScreen();
            this.m_IO.write((String)this.m_Chunks.elementAt(++this.m_ChunkPos));
        }
    }

    private void drawPreviousPage() throws IOException {
        if (this.m_ChunkPos > 0) {
            this.m_IO.homeCursor();
            this.m_IO.eraseScreen();
            this.m_IO.write((String)this.m_Chunks.elementAt(--this.m_ChunkPos));
        } else {
            this.m_IO.bell();
            this.m_NoPrompt = true;
        }
    }

    private void drawNewPage() throws IOException {
        ++this.m_ChunkPos;
        ++this.m_LastNewChunk;
        if (this.m_ChunkPos < this.m_Chunks.size()) {
            this.m_IO.homeCursor();
            this.m_IO.eraseScreen();
            this.m_IO.write((String)this.m_Chunks.elementAt(this.m_ChunkPos));
        } else {
            this.m_EOS = true;
            this.m_NoPrompt = true;
        }
    }

    private void renderChunks() {
        this.m_Chunks = new Vector(20);
        StringBuffer sbuf = new StringBuffer((this.m_TermCols + 25) * 25);
        int b = 0;
        int cols = 0;
        int rows = 0;
        boolean colorskip = false;
        do {
            if (rows == this.m_TermRows - 1) {
                this.m_Chunks.addElement(sbuf.toString());
                sbuf = new StringBuffer((this.m_TermCols + 25) * 25);
                cols = 0;
                rows = 0;
            }
            try {
                b = this.m_Source.read();
            }
            catch (IOException ioex) {
                b = -1;
            }
            if (b == -1) {
                this.m_Chunks.addElement(sbuf.toString());
                continue;
            }
            if (b == 1 || colorskip) {
                sbuf.append((char)b);
                if (!colorskip) {
                    colorskip = true;
                    continue;
                }
                colorskip = false;
                continue;
            }
            if (b == 13) {
                ++rows;
                cols = 0;
                sbuf.append("\n");
                try {
                    b = this.m_Source.read();
                }
                catch (IOException ex) {
                    b = -1;
                }
                if (b == -1 || b == 10) continue;
                sbuf.append((char)b);
                continue;
            }
            if (b == 10) {
                ++rows;
                cols = 0;
                sbuf.append("\n");
                continue;
            }
            sbuf.append((char)b);
            if (++cols != this.m_TermCols) continue;
            ++rows;
            sbuf.append("\n");
            cols = 0;
        } while (b != -1);
    }

    private boolean terminalGeometryChanged() {
        if (this.m_TermRows != this.m_IO.getRows() || this.m_TermCols != this.m_IO.getColumns()) {
            this.m_TermRows = this.m_IO.getRows();
            this.m_TermCols = this.m_IO.getColumns();
            return true;
        }
        return false;
    }
}

