/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import org.jgroups.Address;

public class Rsp<T> {
    boolean received;
    boolean suspected;
    Address sender;
    T retval;

    public Rsp(Address sender) {
        this.sender = sender;
    }

    public Rsp(Address sender, boolean suspected) {
        this.sender = sender;
        this.suspected = suspected;
    }

    public Rsp(Address sender, T retval) {
        this.sender = sender;
        this.retval = retval;
        this.received = true;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Rsp)) {
            return false;
        }
        Rsp other = (Rsp)obj;
        if (this.sender != null) {
            return this.sender.equals(other.sender);
        }
        return other.sender == null;
    }

    public int hashCode() {
        return this.sender != null ? this.sender.hashCode() : 0;
    }

    public T getValue() {
        return this.retval;
    }

    public void setValue(T val) {
        this.retval = val;
    }

    public Address getSender() {
        return this.sender;
    }

    public boolean wasReceived() {
        return this.received;
    }

    public void setReceived(boolean received) {
        this.received = received;
        if (received) {
            this.suspected = false;
        }
    }

    public boolean wasSuspected() {
        return this.suspected;
    }

    public boolean setSuspected(boolean suspected) {
        boolean changed = !this.suspected && suspected;
        this.suspected = suspected;
        if (suspected) {
            this.received = false;
        }
        return changed;
    }

    public String toString() {
        return "sender=" + this.sender + ", retval=" + this.retval + ", received=" + this.received + ", suspected=" + this.suspected;
    }
}

