/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.util.Buffer;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class UtilTest {
    public static void testGetProperty() {
        Properties props = new Properties();
        props.setProperty("name", "Bela");
        props.setProperty("key", "val");
        System.setProperty("name", "Michelle");
        System.setProperty("name2", "Nicole");
        String retval = Util.getProperty(new String[]{"name", "name2"}, props, "name", false, "Jeannette");
        Assert.assertEquals((String)"Michelle", (String)retval);
        props.setProperty("name", "Bela");
        props.setProperty("key", "val");
        retval = Util.getProperty(new String[]{"name2", "name"}, props, "name", false, "Jeannette");
        Assert.assertEquals((String)"Nicole", (String)retval);
        props.setProperty("name", "Bela");
        props.setProperty("key", "val");
        retval = Util.getProperty(new String[]{"name3", "name"}, props, "name", false, "Jeannette");
        Assert.assertEquals((String)"Michelle", (String)retval);
        props.setProperty("name", "Bela");
        props.setProperty("key", "val");
        retval = Util.getProperty(new String[]{"name3", "name4"}, props, "name", false, "Jeannette");
        Assert.assertEquals((String)"Bela", (String)retval);
        props.setProperty("name", "Bela");
        props.setProperty("key", "val");
        retval = Util.getProperty(new String[]{"name2", "name"}, props, "name", true, "Jeannette");
        Assert.assertEquals((String)"Bela", (String)retval);
        props.setProperty("name", "Bela");
        props.setProperty("key", "val");
        retval = Util.getProperty(new String[]{"name2", "name"}, props, "name2", true, "Jeannette");
        Assert.assertEquals((String)"Jeannette", (String)retval);
        props.setProperty("name", "Bela");
        props.setProperty("key", "val");
        retval = Util.getProperty(new String[]{"name2", "name"}, props, "name2", true, null);
        assert (retval == null);
        props.setProperty("name", "Bela");
        props.setProperty("key", "val");
    }

    public static void testGetProperty2() {
        String input = "foo, bar,  foobar: 1000";
        String result = Util.getProperty(input);
        assert (result != null && result.equals("1000"));
        input = "foo, bar,  foobar";
        result = Util.getProperty(input);
        assert (result == null);
        System.setProperty("foobar", "900");
        input = "foo, bar,  foobar: 1000";
        result = Util.getProperty(input);
        assert (result != null && result.equals("900"));
        input = "foo, bar,  foobar";
        result = Util.getProperty(input);
        assert (result != null && result.equals("900"));
        System.setProperty("bar", "500");
        input = "foo, bar,  foobar: 1000";
        result = Util.getProperty(input);
        assert (result != null && result.equals("500"));
        input = "foo, bar,  foobar";
        result = Util.getProperty(input);
        assert (result != null && result.equals("500"));
        System.setProperty("foo", "200");
        input = "foo, bar,  foobar: 1000";
        result = Util.getProperty(input);
        assert (result != null && result.equals("200"));
        input = "foo, bar,  foobar";
        result = Util.getProperty(input);
        assert (result != null && result.equals("200"));
    }

    public static void testFlags() {
        boolean ONE = true;
        int FIVE = 16;
        int SEVEN = 64;
        byte flags = 0;
        flags = Util.setFlag(flags, (byte)1);
        assert (Util.isFlagSet(flags, (byte)1));
        flags = 0;
        flags = Util.setFlag(flags, (byte)65);
        assert (Util.isFlagSet(flags, (byte)1));
        assert (Util.isFlagSet(flags, (byte)64));
        assert (!Util.isFlagSet(flags, (byte)16));
        flags = Util.clearFlags(flags, (byte)1);
        assert (!Util.isFlagSet(flags, (byte)1));
        flags = Util.setFlag(flags, (byte)16);
        assert (Util.isFlagSet(flags, (byte)16));
        assert (Util.isFlagSet(flags, (byte)64));
    }

    public static void testIgnoreBindAddress() {
        boolean retval = Util.isBindAddressPropertyIgnored();
        assert (!retval);
        System.setProperty("jgroups.ignore.bind_addr", "true");
        retval = Util.isBindAddressPropertyIgnored();
        assert (retval);
        System.setProperty("jgroups.ignore.bind_addr", "true2");
        retval = Util.isBindAddressPropertyIgnored();
        assert (!retval);
        System.setProperty("jgroups.ignore.bind_addr", "false");
        retval = Util.isBindAddressPropertyIgnored();
        assert (!retval);
        System.getProperties().remove("jgroups.ignore.bind_addr");
        System.setProperty("ignore.bind.address", "false");
        retval = Util.isBindAddressPropertyIgnored();
        assert (!retval);
        System.getProperties().remove("jgroups.ignore.bind_addr");
        System.setProperty("ignore.bind.address", "true");
        retval = Util.isBindAddressPropertyIgnored();
        assert (retval);
        System.setProperty("jgroups.ignore.bind_addr", "true");
        System.setProperty("ignore.bind.address", "true");
        retval = Util.isBindAddressPropertyIgnored();
        assert (retval);
    }

    public static void testPrintBytes() {
        long num = 1L;
        String s = Util.printBytes(num);
        System.out.println(num + " is " + s);
        Assert.assertEquals((String)"1b", (String)s);
        num = 999L;
        s = Util.printBytes(num);
        System.out.println(num + " is " + s);
        Assert.assertEquals((String)"999b", (String)s);
        num = 1000L;
        s = Util.printBytes(num);
        System.out.println(num + " is " + s);
        Assert.assertEquals((String)"1KB", (String)s);
        num = 1001L;
        s = Util.printBytes(num);
        System.out.println(num + " is " + s);
        Assert.assertEquals((String)"1KB", (String)s);
        num = 1010L;
        s = Util.printBytes(num);
        System.out.println(num + " is " + s);
        Assert.assertEquals((String)"1.01KB", (String)s);
        num = 1543L;
        s = Util.printBytes(num);
        System.out.println(num + " is " + s);
        Assert.assertEquals((String)"1.54KB", (String)s);
        num = 10000L;
        s = Util.printBytes(num);
        System.out.println(num + " is " + s);
        Assert.assertEquals((String)"10KB", (String)s);
        num = 150000L;
        s = Util.printBytes(num);
        System.out.println(num + " is " + s);
        Assert.assertEquals((String)"150KB", (String)s);
        num = 150023L;
        s = Util.printBytes(num);
        System.out.println(num + " is " + s);
        Assert.assertEquals((String)"150.02KB", (String)s);
        num = 1200000L;
        s = Util.printBytes(num);
        System.out.println(num + " is " + s);
        Assert.assertEquals((String)"1.2MB", (String)s);
        num = 150000000L;
        s = Util.printBytes(num);
        System.out.println(num + " is " + s);
        Assert.assertEquals((String)"150MB", (String)s);
        num = 150030000L;
        s = Util.printBytes(num);
        System.out.println(num + " is " + s);
        Assert.assertEquals((String)"150.03MB", (String)s);
        num = 1200000000L;
        s = Util.printBytes(num);
        System.out.println(num + " is " + s);
        Assert.assertEquals((String)"1.2GB", (String)s);
    }

    public static void testReadBytes() {
        assert (10 == Util.readBytesInteger("10"));
        assert (10 == Util.readBytesInteger("10 "));
        assert (10 == Util.readBytesInteger(" 10"));
        assert (1000 == Util.readBytesInteger("1000"));
        assert (1000 == Util.readBytesInteger("1kb"));
        assert (1000 == Util.readBytesInteger("1 kb"));
        assert (1000 == Util.readBytesInteger("1k"));
        assert (1000 == Util.readBytesInteger("1KB"));
        assert (1000 == Util.readBytesInteger("1 K"));
        assert (1000 == Util.readBytesInteger("1K"));
        assert (1234 == Util.readBytesInteger("1.234K"));
        long M = 1000000L;
        assert (M == Util.readBytesLong("1M"));
        assert (M == Util.readBytesLong("1  M"));
        assert (M == Util.readBytesLong("1MB"));
        assert (M == Util.readBytesLong("1 mb"));
        assert (M == Util.readBytesLong("1m"));
        assert (M == Util.readBytesLong("1 m"));
        M = 25500000L;
        assert (M == Util.readBytesLong("25.5M"));
        assert (M == Util.readBytesLong("25.5m"));
        assert (M == Util.readBytesLong("25.5 MB"));
        assert (M == Util.readBytesLong("25.5 mB"));
        assert (M == Util.readBytesLong("25.5   m"));
        assert (M == Util.readBytesLong("25500K"));
        M = 1500000000L;
        assert (M == Util.readBytesLong("1.5GB"));
        assert (M == Util.readBytesLong("1.5gb"));
        assert (M == Util.readBytesLong("1.5g"));
        assert (M == Util.readBytesLong("1.5G"));
        assert (M == Util.readBytesLong("1500m"));
        assert (M == Util.readBytesLong("1500000K"));
        assert (M == Util.readBytesLong("1.5 gb"));
        double D = 3.123456789;
        assert (D == Util.readBytesDouble("3.123456789"));
        assert (D * 10.0 == Util.readBytesDouble("31.23456789"));
        assert (D * 100.0 == Util.readBytesDouble("312.3456789"));
        assert (D * 1000.0 == Util.readBytesDouble("3123.456789"));
        assert (D * 1000.0 == Util.readBytesDouble("3.123456789K"));
        assert (D * 1000000.0 == Util.readBytesDouble("3.123456789M"));
        assert (D * 1000000.0 == Util.readBytesDouble("3123456.789"));
    }

    public static void testObjectToFromByteBuffer() throws Exception {
        Address addr = Util.createRandomAddress();
        ArrayList<String> list = new ArrayList<String>();
        list.add("Bela");
        list.add("Jeannette");
        byte[] buf = Util.objectToByteBuffer(addr);
        Address addr2 = (Address)Util.objectFromByteBuffer(buf);
        System.out.println("addr=" + addr + ", addr2=" + addr2);
        Assert.assertEquals((Object)addr, (Object)addr2);
        buf = Util.objectToByteBuffer(list);
        List list2 = (List)Util.objectFromByteBuffer(buf);
        System.out.println("list=" + list + ", list2=" + list2);
        Assert.assertEquals(list, (Collection)list2);
        byte[] buffer = new byte[]{66, 101, 108, 97, 32, 66, 97, 110};
        buf = Util.objectToByteBuffer(buffer);
        byte[] buffer2 = (byte[])Util.objectFromByteBuffer(buf);
        assert (buffer2 != null && buffer.length == buffer2.length);
        assert (Arrays.equals(buffer, buffer2));
        Object obj = null;
        buf = Util.objectToByteBuffer(obj);
        assert (buf != null);
        assert (buf.length > 0);
        obj = Util.objectFromByteBuffer(buf);
        assert (obj == null);
        Object[] values = new Object[]{Boolean.TRUE, Boolean.FALSE, new Byte(22), new Byte("2"), new Character('5'), new Double(3.14), new Float(352.3), new Integer(100), new Long(322649L), new Short(22), "Bela Ban"};
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            UtilTest.marshal(value);
        }
    }

    public static void testMessageToByteBuffer() throws Exception {
        UtilTest._testMessage(new Message());
        UtilTest._testMessage(new Message(null, null, (Serializable)((Object)"hello world")));
        UtilTest._testMessage(new Message(null, Util.createRandomAddress(), null));
        UtilTest._testMessage(new Message(null, Util.createRandomAddress(), null));
        UtilTest._testMessage(new Message(null, Util.createRandomAddress(), (Serializable)((Object)"bela")));
    }

    private static void _testMessage(Message msg) throws Exception {
        Buffer buf = Util.messageToByteBuffer(msg);
        Message msg2 = Util.byteBufferToMessage(buf.getBuf(), buf.getOffset(), buf.getLength());
        Assert.assertEquals((Object)msg.getSrc(), (Object)msg2.getSrc());
        Assert.assertEquals((Object)msg.getDest(), (Object)msg2.getDest());
        Assert.assertEquals((int)msg.getLength(), (int)msg2.getLength());
    }

    public static void testObjectToByteArrayWithLargeString() throws Exception {
        UtilTest.marshalString(Short.MAX_VALUE);
    }

    public static void testObjectToByteArrayWithLargeString2() throws Exception {
        UtilTest.marshalString(32667);
    }

    public static void testObjectToByteArrayWithLargeString3() throws Exception {
        UtilTest.marshalString(32768);
    }

    public static void testObjectToByteArrayWithLargeString4() throws Exception {
        UtilTest.marshalString(32867);
    }

    public static void testObjectToByteArrayWithLargeString5() throws Exception {
        UtilTest.marshalString(132767);
    }

    private static void marshalString(int size) throws Exception {
        byte[] tmp = new byte[size];
        String str = new String(tmp, 0, tmp.length);
        byte[] retval = Util.objectToByteBuffer(str);
        System.out.println("length=" + retval.length + " bytes");
        String obj = (String)Util.objectFromByteBuffer(retval);
        System.out.println("read " + obj.length() + " string");
    }

    static void marshal(Object obj) throws Exception {
        byte[] buf = Util.objectToByteBuffer(obj);
        assert (buf != null);
        assert (buf.length > 0);
        Object obj2 = Util.objectFromByteBuffer(buf);
        System.out.println("obj=" + obj + ", obj2=" + obj2 + " (type=" + obj.getClass().getName() + ", length=" + buf.length + " bytes)");
        Assert.assertEquals((Object)obj, (Object)obj2);
    }

    public static void testWriteStreamable() throws IOException, IllegalAccessException, InstantiationException {
        Message m = new Message(null, null, (Serializable)((Object)"Hello"));
        ViewId vid = new ViewId(null, 12345L);
        ViewId vid2 = new ViewId(Util.createRandomAddress(), 35623L);
        ByteArrayOutputStream outstream = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(outstream);
        Util.writeGenericStreamable(m, dos);
        Util.writeGenericStreamable(vid, dos);
        Util.writeGenericStreamable(vid2, dos);
        dos.close();
        byte[] buf = outstream.toByteArray();
        ByteArrayInputStream instream = new ByteArrayInputStream(buf);
        DataInputStream dis = new DataInputStream(instream);
        Message m2 = (Message)Util.readGenericStreamable(dis);
        ViewId v3 = (ViewId)Util.readGenericStreamable(dis);
        ViewId v4 = (ViewId)Util.readGenericStreamable(dis);
        assert (m2.getBuffer() != null);
        Assert.assertEquals((int)m.getLength(), (int)m2.getLength());
        assert (v3 != null);
        Assert.assertEquals((Object)vid, (Object)v3);
        assert (v4 != null);
        Assert.assertEquals((Object)vid2, (Object)v4);
    }

    public static void testWriteViewIdWithNullCoordinator() throws IOException, IllegalAccessException, InstantiationException {
        ViewId vid = new ViewId(null, 12345L);
        ByteArrayOutputStream outstream = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(outstream);
        Util.writeGenericStreamable(vid, dos);
        dos.close();
        byte[] buf = outstream.toByteArray();
        ByteArrayInputStream instream = new ByteArrayInputStream(buf);
        DataInputStream dis = new DataInputStream(instream);
        ViewId v4 = (ViewId)Util.readGenericStreamable(dis);
        Assert.assertEquals((Object)vid, (Object)v4);
    }

    public static void testWriteView() throws IOException, IllegalAccessException, InstantiationException {
        ViewId vid = new ViewId(null, 12345L);
        Vector<Address> members = new Vector<Address>();
        Address a1 = Util.createRandomAddress();
        Address a2 = Util.createRandomAddress();
        Address a4 = Util.createRandomAddress();
        members.add(a1);
        members.add(a2);
        members.add(a4);
        View v = new View(vid, members);
        ByteArrayOutputStream outstream = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(outstream);
        Util.writeGenericStreamable(v, dos);
        Util.writeStreamable(v, dos);
        dos.close();
        byte[] buf = outstream.toByteArray();
        ByteArrayInputStream instream = new ByteArrayInputStream(buf);
        DataInputStream dis = new DataInputStream(instream);
        View v2 = (View)Util.readGenericStreamable(dis);
        Assert.assertEquals((Object)v, (Object)v2);
        v2 = (View)Util.readStreamable(View.class, dis);
        Assert.assertEquals((Object)v, (Object)v2);
    }

    public static void testWriteString() throws IOException {
        String s1 = "Bela Ban";
        String s2 = "Michelle Ban";
        ByteArrayOutputStream outstream = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(outstream);
        Util.writeString(s1, dos);
        Util.writeString(s2, dos);
        dos.close();
        byte[] buf = outstream.toByteArray();
        ByteArrayInputStream instream = new ByteArrayInputStream(buf);
        DataInputStream dis = new DataInputStream(instream);
        String s3 = Util.readString(dis);
        String s4 = Util.readString(dis);
        Assert.assertEquals((String)s1, (String)s3);
        Assert.assertEquals((String)s2, (String)s4);
    }

    public static void writeAddress() throws IOException, IllegalAccessException, InstantiationException {
        Address a1 = Util.createRandomAddress();
        Address a2 = Util.createRandomAddress();
        Address a4 = Util.createRandomAddress();
        ByteArrayOutputStream outstream = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(outstream);
        Util.writeAddress(a1, dos);
        Util.writeAddress(a2, dos);
        Util.writeAddress(a4, dos);
        dos.close();
        byte[] buf = outstream.toByteArray();
        ByteArrayInputStream instream = new ByteArrayInputStream(buf);
        DataInputStream dis = new DataInputStream(instream);
        Assert.assertEquals((Object)a1, (Object)Util.readAddress(dis));
        Assert.assertEquals((Object)a2, (Object)Util.readAddress(dis));
        Assert.assertEquals((Object)a4, (Object)Util.readAddress(dis));
    }

    public static void writeNullAddress() throws IOException, IllegalAccessException, InstantiationException {
        Address a1 = null;
        ByteArrayOutputStream outstream = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(outstream);
        Util.writeAddress(a1, dos);
        dos.close();
        byte[] buf = outstream.toByteArray();
        ByteArrayInputStream instream = new ByteArrayInputStream(buf);
        DataInputStream dis = new DataInputStream(instream);
        assert (Util.readAddress(dis) == null);
    }

    public static void testWriteByteBuffer() throws IOException {
        byte[] buf = new byte[1024];
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = 0;
        }
        ByteArrayOutputStream outstream = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(outstream);
        Util.writeByteBuffer(buf, dos);
        dos.close();
        byte[] tmp = outstream.toByteArray();
        ByteArrayInputStream instream = new ByteArrayInputStream(tmp);
        DataInputStream dis = new DataInputStream(instream);
        byte[] buf2 = Util.readByteBuffer(dis);
        assert (buf2 != null);
        Assert.assertEquals((int)buf.length, (int)buf2.length);
    }

    public static void testMatch() {
        long[] a = new long[]{1L, 2L, 3L};
        long[] b = new long[]{2L, 3L, 4L};
        long[] c = null;
        long[] d = new long[]{1L, 2L, 3L, 4L};
        long[] e = new long[]{1L, 2L, 3L};
        assert (Util.match(a, a));
        assert (!Util.match(a, b));
        assert (!Util.match(a, c));
        assert (!Util.match(a, d));
        assert (Util.match(a, e));
        assert (Util.match(c, c));
        assert (!Util.match(c, a));
    }

    public static void testLeftMembers() {
        Address a = Util.createRandomAddress();
        Address b = Util.createRandomAddress();
        Address c = Util.createRandomAddress();
        Address d = Util.createRandomAddress();
        Vector<Address> v1 = new Vector<Address>();
        v1.add(a);
        v1.add(b);
        v1.add(c);
        v1.add(d);
        Vector<Address> v2 = new Vector<Address>();
        v2.add(c);
        v2.add(d);
        View one = new View(new ViewId(a, 1L), v1);
        View two = new View(new ViewId(b, 2L), v2);
        List<Address> left = Util.leftMembers(one, two);
        System.out.println("left = " + left);
        assert (left != null);
        assert (left.size() == 2);
        assert (left.contains(a));
        assert (left.contains(b));
    }

    public static void testLeftMembers2() {
        Address a = Util.createRandomAddress();
        Address b = Util.createRandomAddress();
        Address c = Util.createRandomAddress();
        Address d = Util.createRandomAddress();
        Vector<Address> v1 = new Vector<Address>();
        v1.add(a);
        v1.add(b);
        v1.add(c);
        v1.add(d);
        Vector<Address> v2 = new Vector<Address>();
        v2.add(c);
        v2.add(d);
        v2.add(a);
        v2.add(b);
        View one = new View(new ViewId(a, 1L), v1);
        View two = new View(new ViewId(b, 2L), v2);
        List<Address> left = Util.leftMembers(one, two);
        System.out.println("left = " + left);
        assert (left != null);
        assert (left.isEmpty());
    }

    public static void testNewMembers() {
        Address a = Util.createRandomAddress();
        Address b = Util.createRandomAddress();
        Address c = Util.createRandomAddress();
        Address d = Util.createRandomAddress();
        Address e = Util.createRandomAddress();
        ArrayList<Address> old = new ArrayList<Address>();
        ArrayList<Address> new_list = new ArrayList<Address>();
        old.add(a);
        old.add(b);
        old.add(c);
        new_list.add(b);
        new_list.add(a);
        new_list.add(c);
        new_list.add(d);
        new_list.add(e);
        System.out.println("old: " + old);
        System.out.println("new: " + new_list);
        List<Address> new_nodes = Util.newMembers(old, new_list);
        System.out.println("new_nodes = " + new_nodes);
        assert (new_nodes.size() == 2) : "list should have d and e";
        assert (new_nodes.contains(d));
        assert (new_nodes.contains(e));
    }

    public static void testPickRandomElement() {
        Vector<Integer> v = new Vector<Integer>();
        for (int i = 0; i < 10; ++i) {
            v.add(new Integer(i));
        }
        for (int i = 0; i < 10000; ++i) {
            Integer el = (Integer)Util.pickRandomElement(v);
            assert (el >= 0 && el < 10);
        }
    }

    public static void testAll() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("one");
        l.add("two");
        l.add("one");
        System.out.println("-- list is " + l);
        assert (!Util.all(l, "one"));
        l.remove("two");
        System.out.println("-- list is " + l);
        assert (Util.all(l, "one"));
    }

    public static void testParseCommaDelimitedString() {
        String input = "1,2,3,4,5,6,7,8,9,10 , 11, 12 ,13";
        List<String> list = Util.parseCommaDelimitedStrings(input);
        System.out.println("list: " + list);
        Assert.assertEquals((int)13, (int)list.size());
        Assert.assertEquals((Object)"1", (Object)list.get(0));
        Assert.assertEquals((Object)"13", (Object)list.get(list.size() - 1));
    }

    public static void testParseSemicolonDelimitedString() {
        String input = "one;two ; three; four ; five;six";
        List<String> list = Util.parseStringList(input, ";");
        System.out.println("list: " + list);
        Assert.assertEquals((int)6, (int)list.size());
        Assert.assertEquals((Object)"one", (Object)list.get(0));
        Assert.assertEquals((Object)"six", (Object)list.get(list.size() - 1));
    }

    public static void testParseSemicolonDelimitedString2() {
        String input = "  myID1::subID1 ; myID2::mySubID2; myID3 ;myID4::blaSubID4";
        List<String> list = Util.parseStringList(input, ";");
        System.out.println("list: " + list);
        Assert.assertEquals((int)4, (int)list.size());
        Assert.assertEquals((Object)"myID1::subID1", (Object)list.get(0));
        Assert.assertEquals((Object)"myID4::blaSubID4", (Object)list.get(list.size() - 1));
    }

    public static void testReadLine() throws IOException {
        String input = "   hello world\nthis is \r\n just an example\r\nthis is line 2 \r\n";
        BufferedInputStream in = new BufferedInputStream(new ByteArrayInputStream("   hello world\nthis is \r\n just an example\r\nthis is line 2 \r\n".getBytes()));
        ArrayList<String> list = new ArrayList<String>(4);
        for (int i = 0; i < 4; ++i) {
            String line = Util.readLine(in);
            System.out.println("line = \"" + line + "\"");
            list.add(line);
        }
        assert (list.size() == 4);
    }

    public static void testVariableSubstitution() {
        String val = "hello world";
        String replacement = Util.substituteVariable(val);
        Assert.assertEquals((String)val, (String)replacement);
        val = "my name is ${user.name}";
        replacement = Util.substituteVariable(val);
        Assert.assertNotSame((Object)val, (Object)replacement);
        assert (!val.equals(replacement));
        val = "my name is ${user.name} and ${user.name}";
        replacement = Util.substituteVariable(val);
        assert (!val.equals(replacement));
        Assert.assertEquals((int)-1, (int)replacement.indexOf("${"));
        val = "my name is ${unknown.var:Bela Ban}";
        replacement = Util.substituteVariable(val);
        assert (replacement.contains("Bela Ban"));
        Assert.assertEquals((int)-1, (int)replacement.indexOf("${"));
        val = "my name is ${unknown.var}";
        replacement = Util.substituteVariable(val);
        assert (replacement.contains("${"));
        val = "here is an invalid ${argument because it doesn't contains a closing bracket";
        try {
            replacement = Util.substituteVariable(val);
            assert (false) : "should be an IllegalArgumentException";
        }
        catch (Throwable t) {
            Assert.assertEquals(IllegalArgumentException.class, t.getClass());
        }
    }

    public static void testDetermineMergeParticipantsAndMergeCoords() {
        Address a = Util.createRandomAddress();
        Address b = Util.createRandomAddress();
        Address c = Util.createRandomAddress();
        UUID.add((UUID)a, "A");
        UUID.add((UUID)b, "B");
        UUID.add((UUID)c, "C");
        View v1 = Util.createView(b, 1L, b, a, c);
        View v2 = Util.createView(b, 2L, b, c);
        View v3 = Util.createView(b, 2L, b, c);
        HashMap<Address, View> map = new HashMap<Address, View>();
        map.put(a, v1);
        map.put(b, v2);
        map.put(c, v3);
        StringBuilder sb = new StringBuilder("map:\n");
        for (Map.Entry entry : map.entrySet()) {
            sb.append(entry.getKey() + ": " + entry.getValue() + "\n");
        }
        System.out.println(sb);
        Collection<Address> merge_participants = Util.determineMergeParticipants(map);
        System.out.println("merge_participants = " + merge_participants);
        assert (merge_participants.size() == 2);
        assert (merge_participants.contains(a) && merge_participants.contains(b));
        Collection<Address> merge_coords = Util.determineMergeCoords(map);
        System.out.println("merge_coords = " + merge_coords);
        assert (merge_coords.size() == 1);
        assert (merge_coords.contains(b));
    }

    public static void testDetermineMergeParticipantsAndMergeCoords2() {
        Address a = Util.createRandomAddress();
        Address b = Util.createRandomAddress();
        Address c = Util.createRandomAddress();
        Address d = Util.createRandomAddress();
        UUID.add((UUID)a, "A");
        UUID.add((UUID)b, "B");
        UUID.add((UUID)c, "C");
        UUID.add((UUID)d, "D");
        View v1 = Util.createView(a, 1L, a, b);
        View v2 = Util.createView(a, 1L, a, b);
        View v3 = Util.createView(c, 2L, c, d);
        View v4 = Util.createView(c, 2L, c, d);
        HashMap<Address, View> map = new HashMap<Address, View>();
        map.put(a, v1);
        map.put(b, v2);
        map.put(c, v3);
        map.put(d, v4);
        StringBuilder sb = new StringBuilder("map:\n");
        for (Map.Entry entry : map.entrySet()) {
            sb.append(entry.getKey() + ": " + entry.getValue() + "\n");
        }
        System.out.println(sb);
        Collection<Address> merge_participants = Util.determineMergeParticipants(map);
        System.out.println("merge_participants = " + merge_participants);
        assert (merge_participants.size() == 2);
        assert (merge_participants.contains(a) && merge_participants.contains(c));
        Collection<Address> merge_coords = Util.determineMergeCoords(map);
        System.out.println("merge_coords = " + merge_coords);
        assert (merge_coords.size() == 2);
        assert (merge_coords.contains(a) && merge_coords.contains(c));
    }

    public static void testDetermineMergeParticipantsAndMergeCoords3() {
        Address a = Util.createRandomAddress();
        Address b = Util.createRandomAddress();
        Address c = Util.createRandomAddress();
        Address d = Util.createRandomAddress();
        UUID.add((UUID)a, "A");
        UUID.add((UUID)b, "B");
        UUID.add((UUID)c, "C");
        UUID.add((UUID)d, "D");
        View v1 = Util.createView(a, 1L, a, b, c, d);
        View v2 = Util.createView(a, 1L, a, b, c, d);
        View v3 = Util.createView(a, 2L, a, b, c, d);
        View v4 = Util.createView(a, 3L, a, b, c, d);
        HashMap<Address, View> map = new HashMap<Address, View>();
        map.put(a, v1);
        map.put(b, v2);
        map.put(c, v3);
        map.put(d, v4);
        StringBuilder sb = new StringBuilder("map:\n");
        for (Map.Entry entry : map.entrySet()) {
            sb.append(entry.getKey() + ": " + entry.getValue() + "\n");
        }
        System.out.println(sb);
        Collection<Address> merge_participants = Util.determineMergeParticipants(map);
        System.out.println("merge_participants = " + merge_participants);
        assert (merge_participants.size() == 1);
        assert (merge_participants.contains(a));
        Collection<Address> merge_coords = Util.determineMergeCoords(map);
        System.out.println("merge_coords = " + merge_coords);
        assert (merge_coords.size() == 1);
        assert (merge_coords.contains(a));
    }

    public static void testDetermineMergeParticipantsAndMergeCoords4() {
        Address a = Util.createRandomAddress();
        Address b = Util.createRandomAddress();
        Address c = Util.createRandomAddress();
        Address d = Util.createRandomAddress();
        UUID.add((UUID)a, "A");
        UUID.add((UUID)b, "B");
        UUID.add((UUID)c, "C");
        UUID.add((UUID)d, "D");
        View v1 = Util.createView(a, 1L, a, b);
        View v2 = Util.createView(c, 1L, c, d);
        HashMap<Address, View> map = new HashMap<Address, View>();
        map.put(a, v1);
        map.put(b, v1);
        map.put(d, v2);
        StringBuilder sb = new StringBuilder("map:\n");
        for (Map.Entry entry : map.entrySet()) {
            sb.append(entry.getKey() + ": " + entry.getValue() + "\n");
        }
        System.out.println(sb);
        Collection<Address> merge_participants = Util.determineMergeParticipants(map);
        System.out.println("merge_participants = " + merge_participants);
        assert (merge_participants.size() == 3);
        assert (merge_participants.contains(a) && merge_participants.contains(c) && merge_participants.contains(d));
        Collection<Address> merge_coords = Util.determineMergeCoords(map);
        System.out.println("merge_coords = " + merge_coords);
        assert (merge_coords.size() == 2);
        assert (merge_coords.contains(a) && merge_coords.contains(c));
    }

    public static void testAttributeNameToMethodName() {
        UtilTest._testAttributeNameToMethodName("my_name", "MyName");
        UtilTest._testAttributeNameToMethodName("bela", "Bela");
        UtilTest._testAttributeNameToMethodName("oob_max_input_size", "OobMaxInputSize");
        UtilTest._testAttributeNameToMethodName("a_b_c", "ABC");
        UtilTest._testAttributeNameToMethodName("aa_bb_cc", "AaBbCc");
        UtilTest._testAttributeNameToMethodName("i", "I");
        UtilTest._testAttributeNameToMethodName("tmp", "Tmp");
        UtilTest._testAttributeNameToMethodName("inet_address_method", "InetAddressMethod");
    }

    public static void testMethodNameToAttributeName() {
        UtilTest._testMethodNameToAttributeName("setFoo", "foo");
        UtilTest._testMethodNameToAttributeName("getFoo", "foo");
        UtilTest._testMethodNameToAttributeName("isLogDiscardMessages", "log_discard_messages");
        UtilTest._testMethodNameToAttributeName("setOOBMinPoolSize", "oob_min_pool_size");
        UtilTest._testMethodNameToAttributeName("isOOBThreadPoolEnabled", "oob_thread_pool_enabled");
        UtilTest._testMethodNameToAttributeName("OOBMinPoolSize", "oob_min_pool_size");
        UtilTest._testMethodNameToAttributeName("inetAddressMethod", "inet_address_method");
    }

    private static void _testMethodNameToAttributeName(String input, String expected_output) {
        String atttr_name = Util.methodNameToAttributeName(input);
        System.out.println("method name=" + input + ", attrname=" + atttr_name + ", expected output=" + expected_output);
        assert (atttr_name.equals(expected_output)) : "method name=" + input + ", attrname=" + atttr_name + ", expected output=" + expected_output;
    }

    private static void _testAttributeNameToMethodName(String input, String expected_output) {
        String method_name = Util.attributeNameToMethodName(input);
        System.out.println("attrname=" + input + ", method name=" + method_name + ", expected output=" + expected_output);
        assert (method_name.equals(expected_output)) : "attrname=" + input + ", method name=" + method_name + ", expected output=" + expected_output;
    }
}

